/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Snippet002UpdateComboRetainSelection {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            ViewModel viewModel = new ViewModel();
            Shell shell = new View(viewModel).createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            System.out.println(viewModel.getText());
        });
        display.dispose();
    }

    private static IObservableFactory<Collection<String>, IObservableList<String>> createListDetailFactory() {
        return target -> {
            WritableList list = WritableList.withElementType(String.class);
            list.addAll(target);
            return list;
        };
    }

    public static abstract class AbstractModelObject {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    static class View {
        private final ViewModel viewModel;
        static int count;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Shell shell = new Shell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Combo combo = new Combo((Composite)shell, 2056);
            combo.setLayoutData((Object)new GridData(4, 0x1000008, true, false));
            Button reset = new Button((Composite)shell, 0);
            reset.setText("reset collection");
            reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<String> newList = new ArrayList<String>();
                    newList.add("Chocolate");
                    newList.add("Vanilla");
                    newList.add("Mango Parfait");
                    newList.add("beef");
                    newList.add("Cheesecake");
                    newList.add(Integer.toString(++count));
                    viewModel.setChoices(newList);
                }
            });
            System.out.println(this.viewModel.getText());
            DataBindingContext bindingContext = new DataBindingContext();
            IBeanValueProperty choices = BeanProperties.value(ViewModel.class, (String)"choices", List.class);
            IObservableList list = MasterDetailObservables.detailList((IObservableValue)choices.observe((Object)this.viewModel), Snippet002UpdateComboRetainSelection.createListDetailFactory(), String.class);
            bindingContext.bindList((IObservableList)WidgetProperties.items().observe((Widget)combo), list);
            bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)combo), BeanProperties.value(ViewModel.class, (String)"text").observe((Object)this.viewModel));
            shell.pack();
            shell.open();
            return shell;
        }
    }

    public static class ViewModel
    extends AbstractModelObject {
        private String text = "beef";
        private List<String> choices = new ArrayList<String>();

        public ViewModel() {
            this.choices.add("pork");
            this.choices.add("beef");
            this.choices.add("poultry");
            this.choices.add("vegatables");
        }

        public List<String> getChoices() {
            return this.choices;
        }

        public void setChoices(List<String> choices) {
            List<String> old = this.choices;
            this.choices = choices;
            this.firePropertyChange("choices", old, choices);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.firePropertyChange("text", oldValue, text);
        }
    }
}

