/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet004DataBindingContextErrorLabel {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = Snippet004DataBindingContextErrorLabel.createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private static Shell createShell() {
        Shell shell = new Shell();
        shell.setText("Data Binding Snippet 004");
        shell.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)shell, 0).setText("Enter '5' to be valid:");
        Text text = new Text((Composite)shell, 2048);
        WritableValue value = WritableValue.withValueType(String.class);
        new Label((Composite)shell, 0).setText("Error:");
        Label errorLabel = new Label((Composite)shell, 2048);
        errorLabel.setForeground(Display.getCurrent().getSystemColor(3));
        GridDataFactory.swtDefaults().hint(200, -1).applyTo((Control)errorLabel);
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text), (IObservableValue)value, new UpdateValueStrategy().setAfterConvertValidator((IValidator)new FiveValidator()), null);
        bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)errorLabel), (IObservableValue)new AggregateValidationStatus((IObservableCollection)bindingContext.getBindings(), 2));
        shell.pack();
        shell.open();
        return shell;
    }

    private static class FiveValidator
    implements IValidator<String> {
        private FiveValidator() {
        }

        public IStatus validate(String value) {
            return "5".equals(value) ? Status.OK_STATUS : ValidationStatus.error((String)("the value was '" + value + "', not '5'"));
        }
    }
}

