/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.internal.databinding.provisional.swt.TableUpdater;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class Snippet006Spreadsheet {
    private static final int COUNTER_UPDATE_DELAY = 1000;
    private static final int NUM_COLUMNS = 6;
    private static final int NUM_ROWS = 16;
    private static int DEBUG_LEVEL = 0;
    private static boolean FUNKY_COUNTER = false;
    private static boolean FUNKY_FORMULAS = true;
    static WritableValue<String>[][] cellFormulas = new WritableValue[16][6];
    static ComputedValue<String>[][] cellValues = new ComputedValue[16][6];
    protected static int counter;

    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = Snippet006Spreadsheet.createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private static Shell createShell() {
        final Shell shell = new Shell();
        shell.setText("Data Binding Snippet 006");
        final Table table = new Table((Composite)shell, 268503042);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        int i1 = 0;
        while (i1 < 6) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(Character.toString((char)(65 + i1)));
            tableColumn.setWidth(60);
            ++i1;
        }
        WritableList list = new WritableList();
        int i2 = 0;
        while (i2 < 16) {
            list.add(new Object());
            int j = 0;
            while (j < 6) {
                Snippet006Spreadsheet.cellFormulas[i2][j] = new WritableValue();
                Snippet006Spreadsheet.cellValues[i2][j] = new ComputedCellValue((IObservableValue<String>)cellFormulas[i2][j]);
                if (!FUNKY_FORMULAS || i2 == 0 || j == 0) {
                    cellFormulas[i2][j].setValue((Object)"");
                } else {
                    cellFormulas[i2][j].setValue((Object)("=" + Snippet006Spreadsheet.cellReference(i2 - 1, j) + "+" + Snippet006Spreadsheet.cellReference(i2, j - 1)));
                }
                ++j;
            }
            ++i2;
        }
        new TableUpdater<Object>(table, (IObservableList)list){

            protected void updateItem(int rowIndex, TableItem item, Object element) {
                if (DEBUG_LEVEL >= 1) {
                    System.out.println("updating row " + rowIndex);
                }
                int j = 0;
                while (j < 6) {
                    item.setText(j, (String)cellValues[rowIndex][j].getValue());
                    ++j;
                }
            }
        };
        if (FUNKY_COUNTER) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    cellFormulas[0][1].setValue((Object)("" + counter++));
                    shell.getDisplay().timerExec(1000, (Runnable)this);
                }
            });
        }
        final TableCursor cursor = new TableCursor(table, 0);
        final ControlEditor editor = new ControlEditor((Composite)cursor);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                table.setSelection(new TableItem[]{cursor.getRow()});
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                final Text text = new Text((Composite)cursor, 0);
                TableItem row = cursor.getRow();
                int rowIndex = table.indexOf(row);
                int columnIndex = cursor.getColumn();
                text.setText((String)cellFormulas[rowIndex][columnIndex].getValue());
                text.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.character == '\r') {
                            TableItem row = cursor.getRow();
                            int rowIndex = table.indexOf(row);
                            int columnIndex = cursor.getColumn();
                            cellFormulas[rowIndex][columnIndex].setValue((Object)text.getText());
                            text.dispose();
                        }
                        if (e.character == '\u001b') {
                            text.dispose();
                        }
                    }
                });
                editor.setEditor((Control)text);
                text.setFocus();
            }
        });
        cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == SWT.MOD1 || e.keyCode == SWT.MOD2 || (e.stateMask & SWT.MOD1) != 0 || (e.stateMask & SWT.MOD2) != 0) {
                    cursor.setVisible(false);
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == SWT.MOD1 && (e.stateMask & SWT.MOD2) != 0) {
                    return;
                }
                if (e.keyCode == SWT.MOD2 && (e.stateMask & SWT.MOD1) != 0) {
                    return;
                }
                if (e.keyCode != SWT.MOD1 && (e.stateMask & SWT.MOD1) != 0) {
                    return;
                }
                if (e.keyCode != SWT.MOD2 && (e.stateMask & SWT.MOD2) != 0) {
                    return;
                }
                TableItem[] selection = table.getSelection();
                TableItem row = selection.length == 0 ? table.getItem(table.getTopIndex()) : selection[0];
                table.showItem(row);
                cursor.setSelection(row, 0);
                cursor.setVisible(true);
                cursor.setFocus();
            }
        });
        GridLayoutFactory.fillDefaults().generateLayout((Composite)shell);
        shell.setSize(400, 300);
        shell.open();
        return shell;
    }

    private static String cellReference(int rowIndex, int columnIndex) {
        return "" + (char)(65 + columnIndex) + (rowIndex + 1);
    }

    static class ComputedCellValue
    extends ComputedValue<String> {
        private final IObservableValue<String> cellFormula;
        private boolean calculating;

        ComputedCellValue(IObservableValue<String> cellFormula) {
            this.cellFormula = cellFormula;
        }

        protected String calculate() {
            if (this.calculating) {
                return "#cycle";
            }
            try {
                this.calculating = true;
                String string = this.evaluate((String)this.cellFormula.getValue());
                return string;
            }
            finally {
                this.calculating = false;
            }
        }

        private String evaluate(String value) {
            if (DEBUG_LEVEL >= 2) {
                System.out.println("evaluating " + String.valueOf((Object)this) + " ...");
            }
            if (value == null) {
                return "";
            }
            try {
                if (!value.startsWith("=")) {
                    return value;
                }
                String addition = value.substring(1);
                int indexOfPlus = addition.indexOf(43);
                String operand1 = addition.substring(0, indexOfPlus);
                double value1 = this.eval(operand1);
                String operand2 = addition.substring(indexOfPlus + 1);
                double value2 = this.eval(operand2);
                return NumberFormat.getNumberInstance().format(value1 + value2);
            }
            catch (Exception ex) {
                return ex.getMessage();
            }
        }

        private double eval(String s) throws ParseException {
            if (s.length() == 0) {
                return 0.0;
            }
            char character = s.charAt(0);
            if (Character.isLetter(character)) {
                character = Character.toLowerCase(character);
                int columnIndex = character - 97;
                int rowIndex = 0;
                rowIndex = NumberFormat.getNumberInstance().parse(s.substring(1)).intValue() - 1;
                String value = (String)cellValues[rowIndex][columnIndex].getValue();
                return value.length() == 0 ? 0.0 : NumberFormat.getNumberInstance().parse(value).doubleValue();
            }
            return NumberFormat.getNumberInstance().parse(s).doubleValue();
        }
    }
}

