/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class Snippet007ColorLabelProvider {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = Snippet007ColorLabelProvider.createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private static Shell createShell() {
        ArrayList<Person> persons = new ArrayList<Person>();
        persons.add(new Person("Fiona Apple", Person.Gender.FEMALE));
        persons.add(new Person("Elliot Smith", Person.Gender.MALE));
        persons.add(new Person("Diana Krall", Person.Gender.FEMALE));
        persons.add(new Person("David Gilmour", Person.Gender.MALE));
        Shell shell = new Shell();
        shell.setText("Gender Bender");
        shell.setLayout((Layout)new GridLayout());
        Table table = new Table((Composite)shell, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText("No");
        column.setWidth(20);
        column = new TableColumn(table, 0);
        column.setText("Name");
        column.setWidth(100);
        final TableViewer viewer = new TableViewer(table);
        IObservableList observableList = Observables.staticObservableList(persons);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        viewer.setContentProvider((IContentProvider)contentProvider);
        IObservableMap[] attributes = new IObservableMap[]{BeanProperties.value(Person.class, (String)"name").observeDetail(contentProvider.getKnownElements()), BeanProperties.value(Person.class, (String)"gender").observeDetail(contentProvider.getKnownElements())};
        viewer.setLabelProvider((IBaseLabelProvider)new ColorLabelProvider(attributes, shell.getDisplay(), persons));
        viewer.setInput((Object)observableList);
        table.getColumn(0).pack();
        Button button = new Button((Composite)shell, 8);
        button.setText("Toggle Gender");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                IStructuredSelection selection = viewer.getStructuredSelection();
                if (selection != null && !selection.isEmpty()) {
                    Person person;
                    person.setGender((person = (Person)selection.getFirstElement()).getGender() == Person.Gender.MALE ? Person.Gender.FEMALE : Person.Gender.MALE);
                }
            }
        });
        shell.setSize(300, 400);
        shell.open();
        return shell;
    }

    static class ColorLabelProvider
    extends ObservableMapLabelProvider
    implements ITableColorProvider {
        private final Color maleColor;
        private final Color femaleColor;
        private final List<Person> persons;

        ColorLabelProvider(IObservableMap<?, ?>[] attributes, Display display, List<Person> persons) {
            super(attributes);
            this.persons = persons;
            this.maleColor = new Color((Device)display, 255, 192, 203);
            this.femaleColor = display.getSystemColor(9);
        }

        public String getColumnText(Object element, int index) {
            if (index == 0) {
                return Integer.toString(this.persons.indexOf(element) + 1);
            }
            return ((Person)element).getName();
        }

        public Color getBackground(Object element, int index) {
            return null;
        }

        public Color getForeground(Object element, int index) {
            if (index == 0) {
                return null;
            }
            return ((Person)element).getGender() == Person.Gender.MALE ? this.maleColor : this.femaleColor;
        }
    }

    static class Person {
        private final String name;
        private Gender gender;
        private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

        Person(String name, Gender gender) {
            this.name = name;
            this.gender = gender;
        }

        public String getName() {
            return this.name;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public Gender getGender() {
            return this.gender;
        }

        void setGender(Gender gender) {
            this.gender = gender;
            this.changeSupport.firePropertyChange("gender", (Object)this.gender, (Object)this.gender);
        }

        static enum Gender {
            MALE,
            FEMALE;

        }
    }
}

