/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet008ComputedValue {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = Snippet008ComputedValue.createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private static Shell createShell() {
        Shell shell = new Shell();
        shell.setLayout((Layout)new FillLayout());
        Composite ui = new Composite((Composite)shell, 0);
        final WritableValue firstNameValue = new WritableValue();
        final WritableValue lastNameValue = new WritableValue();
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(ui);
        new Label(ui, 0).setText("First Name:");
        new Label(ui, 0).setText("Last Name");
        GridDataFactory dataFactory = GridDataFactory.swtDefaults().align(4, 4).grab(true, false);
        Text firstName = new Text(ui, 2048);
        dataFactory.applyTo((Control)firstName);
        Text lastName = new Text(ui, 2048);
        dataFactory.applyTo((Control)lastName);
        dataFactory = GridDataFactory.swtDefaults().span(2, 1).grab(true, false).align(4, 1);
        Label label = new Label(ui, 0);
        label.setText("Formatted Name:");
        dataFactory.applyTo((Control)label);
        Text formattedName = new Text(ui, 2048);
        formattedName.setEditable(false);
        dataFactory.applyTo((Control)formattedName);
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)firstName), (IObservableValue)firstNameValue);
        bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)lastName), (IObservableValue)lastNameValue);
        ComputedValue<String> name = new ComputedValue<String>(){

            protected String calculate() {
                String lastName = (String)lastNameValue.getValue();
                String firstName = (String)firstNameValue.getValue();
                String lastNameOrDefault = lastName == null || lastName.isEmpty() ? "[Last Name]" : lastName;
                String firstNameOrDefault = firstName == null || firstName.isEmpty() ? "[First Name]" : firstName;
                return lastNameOrDefault + ", " + firstNameOrDefault;
            }
        };
        bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)0).observe((Widget)formattedName), (IObservableValue)name, UpdateValueStrategy.never(), null);
        shell.pack();
        shell.open();
        return shell;
    }
}

