/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet011ValidateMultipleBindingsSnippet {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = Snippet011ValidateMultipleBindingsSnippet.createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.dispose();
        });
        display.dispose();
    }

    private static Shell createShell() {
        Shell shell = new Shell();
        View view = new View((Composite)shell);
        Model model = new Model();
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)view.text1), model.value1, new UpdateValueStrategy().setAfterConvertValidator((IValidator)new CrossFieldValidator((IObservableValue<String>)model.value2)), null);
        bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)view.text2), model.value2, new UpdateValueStrategy().setAfterConvertValidator((IValidator)new CrossFieldValidator((IObservableValue<String>)model.value1)), null);
        model.value1.addValueChangeListener(event -> System.out.println("Value 1: " + (String)model.value1.getValue()));
        model.value2.addValueChangeListener(event -> System.out.println("Value 2: " + (String)model.value2.getValue()));
        shell.pack();
        shell.open();
        return shell;
    }

    private static final class CrossFieldValidator
    implements IValidator<String> {
        private final IObservableValue<String> other;

        private CrossFieldValidator(IObservableValue<String> other) {
            this.other = other;
        }

        public IStatus validate(String value) {
            if (!value.equals(this.other.getValue())) {
                System.out.println("Validation fine");
                return ValidationStatus.ok();
            }
            System.out.println("Validation error: values cannot be the same");
            return ValidationStatus.error((String)"values cannot be the same");
        }
    }

    static class Model {
        WritableValue<String> value1 = new WritableValue();
        WritableValue<String> value2 = new WritableValue();

        Model() {
        }
    }

    static class View {
        Text text1;
        Text text2;

        View(Composite composite) {
            composite.setLayout((Layout)new GridLayout(2, true));
            this.text1 = new Text(composite, 2048);
            this.text2 = new Text(composite, 2048);
        }
    }
}

