/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class Snippet013TableViewerEditing {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new View(new ViewModel()).createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
    }

    public static abstract class AbstractModelObject {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private static class InlineEditingSupport
    extends ObservableValueEditingSupport<Person, String, String> {
        private final CellEditor cellEditor;

        public InlineEditingSupport(ColumnViewer viewer, DataBindingContext bindingContext) {
            super(viewer, bindingContext);
            this.cellEditor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected IObservableValue<String> doCreateCellEditorObservable(CellEditor cellEditor) {
            return WidgetProperties.text((int)24).observe((Widget)cellEditor.getControl());
        }

        protected IObservableValue<String> doCreateElementObservable(Person element, ViewerCell cell) {
            return BeanProperties.value(Person.class, (String)"name", String.class).observe((Object)element);
        }
    }

    static class Person
    extends AbstractModelObject {
        String name = "John Smith";

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange("name", oldValue, name);
        }
    }

    static class View {
        private final ViewModel viewModel;
        private Table committers;
        private Label selectedCommitter;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            shell.setLayout((Layout)new FillLayout(512));
            this.committers = new Table((Composite)shell, 67584);
            this.committers.setLinesVisible(true);
            this.selectedCommitter = new Label((Composite)shell, 0);
            DataBindingContext bindingContext = new DataBindingContext();
            this.bindGUI(bindingContext);
            shell.setSize(400, 600);
            shell.open();
            return shell;
        }

        protected void bindGUI(DataBindingContext bindingContext) {
            TableViewer peopleViewer = new TableViewer(this.committers);
            TableViewerColumn column = new TableViewerColumn(peopleViewer, 0);
            column.setEditingSupport((EditingSupport)new InlineEditingSupport((ColumnViewer)peopleViewer, bindingContext));
            column.getColumn().setWidth(100);
            ViewerSupport.bind((StructuredViewer)peopleViewer, (IObservableList)new WritableList(this.viewModel.getPeople(), Person.class), (IValueProperty)BeanProperties.value(Person.class, (String)"name"));
            IViewerObservableValue selection = ViewerProperties.singleSelection(Person.class).observe((Viewer)peopleViewer);
            bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.selectedCommitter), BeanProperties.value(Person.class, (String)"name", String.class).observeDetail((IObservableValue)selection));
        }
    }

    static class ViewModel {
        private final List<Person> people = new LinkedList<Person>();

        ViewModel() {
            this.people.add(new Person("Steve Northover"));
            this.people.add(new Person("Grant Gayed"));
            this.people.add(new Person("Veronika Irvine"));
            this.people.add(new Person("Mike Wilson"));
            this.people.add(new Person("Christophe Cornu"));
            this.people.add(new Person("Lynne Kues"));
            this.people.add(new Person("Silenio Quarti"));
            this.people.add(new Person("Boris Bokowski"));
            this.people.add(new Person("Matthew Hall"));
            this.people.add(new Person("Thomas Schindl"));
            this.people.add(new Person("Lars Vogel"));
            this.people.add(new Person("Simon Scholz"));
            this.people.add(new Person("Stefan Xenos"));
            this.people.add(new Person("Jens Lidestr\u00f6m"));
        }

        public List<Person> getPeople() {
            return this.people;
        }
    }
}

