/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet015DelayTextModifyEvents {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = Snippet015DelayTextModifyEvents.createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private static Shell createShell() {
        Shell shell = new Shell();
        shell.setLayout((Layout)new GridLayout(3, false));
        Label field1 = new Label((Composite)shell, 0);
        field1.setText("Field 1 ");
        Text text1 = new Text((Composite)shell, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(200, -1).applyTo((Control)text1);
        new Label((Composite)shell, 0).setText("200 ms delay");
        Label field2 = new Label((Composite)shell, 0);
        field2.setText("Field 2 ");
        Text text2 = new Text((Composite)shell, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(200, -1).applyTo((Control)text2);
        new Label((Composite)shell, 0).setText("2000 ms delay");
        ISWTObservableValue delayed1 = WidgetProperties.text((int)24).observeDelayed(200, (Widget)text1);
        ISWTObservableValue delayed2 = WidgetProperties.text((int)24).observeDelayed(2000, (Widget)text2);
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
        Font shellFont = shell.getFont();
        Font italicFont = (Font)resourceManager.create((DeviceResourceDescriptor)FontDescriptor.createFrom((Font)shellFont).setStyle(2));
        IObservableValue stale1 = Observables.observeStale((IObservable)delayed1);
        IObservableValue stale2 = Observables.observeStale((IObservable)delayed2);
        Label info = new Label((Composite)shell, 64);
        info.setText("Pending changes are applied immediately if the observed control loses focus, or enter is pressed.");
        GridDataFactory.fillDefaults().span(3, 1).hint(300, -1).applyTo((Control)info);
        DataBindingContext bindingContext = new DataBindingContext();
        IValueProperty fontProperty = Properties.convertedValue(stale -> stale != false ? italicFont : shellFont);
        bindingContext.bindValue((IObservableValue)WidgetProperties.font().observe((Widget)field2), fontProperty.observeDetail(stale1));
        bindingContext.bindValue((IObservableValue)WidgetProperties.font().observe((Widget)field1), fontProperty.observeDetail(stale2));
        bindingContext.bindValue((IObservableValue)delayed1, (IObservableValue)delayed2);
        text2.addTraverseListener(e -> {
            if (e.detail == 4) {
                bindingContext.updateTargets();
            }
        });
        text1.addTraverseListener(arg_0 -> Snippet015DelayTextModifyEvents.lambda$3((IObservableValue)delayed1, arg_0));
        shell.pack();
        shell.open();
        return shell;
    }

    private static /* synthetic */ void lambda$3(IObservableValue iObservableValue, TraverseEvent e) {
        if (e.detail == 4) {
            iObservableValue.getValue();
        }
    }
}

