/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet018CheckboxTableViewerCheckedSelection {
    public static void main(String[] args) {
        Display display = Display.getDefault();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new View(Snippet018CheckboxTableViewerCheckedSelection.createSampleModel()).createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private static ViewModel createSampleModel() {
        ViewModel viewModel = new ViewModel();
        Person stan = Snippet018CheckboxTableViewerCheckedSelection.createPerson("Stan");
        Person kyle = Snippet018CheckboxTableViewerCheckedSelection.createPerson("Kyle");
        Person eric = Snippet018CheckboxTableViewerCheckedSelection.createPerson("Eric");
        Person kenny = Snippet018CheckboxTableViewerCheckedSelection.createPerson("Kenny");
        Person wendy = Snippet018CheckboxTableViewerCheckedSelection.createPerson("Wendy");
        Person butters = Snippet018CheckboxTableViewerCheckedSelection.createPerson("Butters");
        stan.setFriends(kyle, eric, kenny, wendy);
        kyle.setFriends(stan, eric, kenny);
        eric.setFriends(eric);
        kenny.setFriends(stan, kyle, eric);
        wendy.setFriends(stan);
        butters.setFriends(new Person[0]);
        viewModel.setPeople(Arrays.asList(stan, kyle, eric, kenny, wendy, butters));
        return viewModel;
    }

    private static Person createPerson(String name) {
        Person person = new Person();
        person.setName(name);
        return person;
    }

    public static abstract class AbstractModelObject {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    static class Person
    extends AbstractModelObject {
        private String name;
        private Set<Person> friends = new HashSet<Person>();

        Person() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.firePropertyChange("name", this.name, this.name);
        }

        public Set<Person> getFriends() {
            return new HashSet<Person>(this.friends);
        }

        public void setFriends(Person ... friends) {
            this.setFriends(new HashSet<Person>(Arrays.asList(friends)));
        }

        public void setFriends(Set<Person> friends) {
            this.friends = new HashSet<Person>(friends);
            this.firePropertyChange("friends", this.friends, this.friends);
        }

        public String toString() {
            return this.name;
        }
    }

    static class View {
        private final ViewModel viewModel;
        private Shell shell;
        private Button addPersonButton;
        private Button removePersonButton;
        private TableViewer peopleViewer;
        private Text personName;
        private CheckboxTableViewer friendsViewer;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            this.shell = new Shell();
            this.createUI(this.shell);
            this.bindUI();
            this.shell.setSize(this.shell.computeSize(400, -1));
            this.shell.open();
            return this.shell;
        }

        private void createUI(Shell shell) {
            shell.setText("Binding checked elements in CheckboxTableViewer");
            shell.setLayout((Layout)new GridLayout(2, false));
            new Label((Composite)shell, 0).setText("People");
            Composite buttons = new Composite((Composite)shell, 0);
            GridDataFactory.swtDefaults().align(131072, 0x1000000).applyTo((Control)buttons);
            GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(buttons);
            this.addPersonButton = new Button(buttons, 8);
            this.addPersonButton.setText("Add");
            GridDataFactory.fillDefaults().applyTo((Control)this.addPersonButton);
            this.removePersonButton = new Button(buttons, 8);
            this.removePersonButton.setText("Remove");
            GridDataFactory.fillDefaults().applyTo((Control)this.removePersonButton);
            Composite peopleComposite = new Composite((Composite)shell, 0);
            GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)peopleComposite);
            TableColumnLayout peopleColumnLayout = new TableColumnLayout();
            peopleComposite.setLayout((Layout)peopleColumnLayout);
            this.peopleViewer = new TableViewer(peopleComposite, 67588);
            Table peopleTable = this.peopleViewer.getTable();
            peopleTable.setHeaderVisible(true);
            peopleTable.setLinesVisible(true);
            TableColumn nameColumn = new TableColumn(peopleTable, 0);
            nameColumn.setText("Name");
            peopleColumnLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(1));
            TableColumn friendsColumn = new TableColumn(peopleTable, 0);
            friendsColumn.setText("Friends");
            peopleColumnLayout.setColumnData((Widget)friendsColumn, (ColumnLayoutData)new ColumnWeightData(3));
            new Label((Composite)shell, 0).setText("Name");
            this.personName = new Text((Composite)shell, 2048);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.personName);
            new Label((Composite)shell, 0).setText("Friends");
            Composite friendsComposite = new Composite((Composite)shell, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)friendsComposite);
            TableColumnLayout friendsColumnLayout = new TableColumnLayout();
            friendsComposite.setLayout((Layout)friendsColumnLayout);
            this.friendsViewer = CheckboxTableViewer.newCheckList((Composite)friendsComposite, (int)67588);
            Table friendsTable = this.friendsViewer.getTable();
            friendsTable.setHeaderVisible(true);
            friendsTable.setLinesVisible(true);
            TableColumn friendNameColumn = new TableColumn(friendsTable, 0);
            friendNameColumn.setText("Name");
            friendsColumnLayout.setColumnData((Widget)friendNameColumn, (ColumnLayoutData)new ColumnWeightData(1));
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.friendsViewer.getTable());
        }

        private void bindUI() {
            DataBindingContext bindingContext = new DataBindingContext();
            IObservableList people = BeanProperties.list(ViewModel.class, (String)"people", Person.class).observe((Object)this.viewModel);
            this.addPersonButton.addListener(13, event -> {
                InputDialog dlg = new InputDialog(this.shell, "Add Person", "Enter name:", "<Name>", newText -> {
                    if (newText == null || newText.length() == 0) {
                        return "Name cannot be empty";
                    }
                    return null;
                });
                if (dlg.open() == 0) {
                    Person person = new Person();
                    person.setName(dlg.getValue());
                    people.add((Object)person);
                    this.peopleViewer.setSelection((ISelection)new StructuredSelection((Object)person));
                }
            });
            this.removePersonButton.addListener(13, event -> {
                IStructuredSelection selected = this.peopleViewer.getStructuredSelection();
                if (selected.isEmpty()) {
                    return;
                }
                Person person = (Person)selected.getFirstElement();
                if (MessageDialog.openConfirm((Shell)this.shell, (String)"Remove person", (String)("Remove " + person.getName() + "?"))) {
                    people.remove((Object)person);
                }
            });
            ViewerSupport.bind((StructuredViewer)this.peopleViewer, (IObservableList)people, (IValueProperty[])BeanProperties.values(Person.class, (String[])new String[]{"name", "friends"}));
            IViewerObservableValue selectedPerson = ViewerProperties.singleSelection(Person.class).observe((Viewer)this.peopleViewer);
            IObservableValue personSelected = ComputedValue.create(() -> View.lambda$3((IObservableValue)selectedPerson));
            bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.removePersonButton), personSelected);
            bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.friendsViewer.getTable()), personSelected);
            bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.personName), BeanProperties.value(Person.class, (String)"name", String.class).observeDetail((IObservableValue)selectedPerson));
            ViewerSupport.bind((StructuredViewer)this.friendsViewer, (IObservableList)people, (IValueProperty)BeanProperties.value(Person.class, (String)"name"));
            bindingContext.bindSet((IObservableSet)ViewerProperties.checkedElements(Person.class).observe((Viewer)this.friendsViewer), BeanProperties.set(Person.class, (String)"friends", Person.class).observeDetail((IObservableValue)selectedPerson));
        }

        private static /* synthetic */ Boolean lambda$3(IObservableValue iObservableValue) {
            return iObservableValue.getValue() != null;
        }
    }

    static class ViewModel
    extends AbstractModelObject {
        private List<Person> people = new ArrayList<Person>();

        ViewModel() {
        }

        public List<Person> getPeople() {
            return new ArrayList<Person>(this.people);
        }

        public void setPeople(List<Person> people) {
            this.people = new ArrayList<Person>(people);
            this.firePropertyChange("people", this.people, this.people);
        }
    }
}

