/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class Snippet019TreeViewerWithListFactory {
    private Button pasteButton;
    private Button copyButton;
    private Button addChildBeanButton;
    private Button removeBeanButton;
    private TreeViewer beanViewer;
    private Tree tree;
    private Text beanText;
    private DataBindingContext m_bindingContext;
    private final Bean input = Snippet019TreeViewerWithListFactory.createBean("input");
    private IObservableValue<Bean> clipboard;

    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new Snippet019TreeViewerWithListFactory().createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private Shell createShell() {
        Shell shell = new Shell();
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        shell.setLayout((Layout)gridLayout_1);
        shell.setSize(535, 397);
        shell.setText("SWT Application");
        Composite group = new Composite((Composite)shell, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginBottom = 0;
        rowLayout.pack = false;
        group.setLayout((Layout)rowLayout);
        group.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        Button addRootButton = new Button(group, 0);
        addRootButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<Bean> list = Snippet019TreeViewerWithListFactory.this.input.getList();
                Bean root = Snippet019TreeViewerWithListFactory.createBean("root");
                list.add(root);
                Snippet019TreeViewerWithListFactory.this.input.setList(list);
                Snippet019TreeViewerWithListFactory.this.beanViewer.setSelection((ISelection)new StructuredSelection((Object)root));
                Snippet019TreeViewerWithListFactory.this.beanText.selectAll();
                Snippet019TreeViewerWithListFactory.this.beanText.setFocus();
            }
        });
        addRootButton.setText("Add Root");
        this.addChildBeanButton = new Button(group, 0);
        this.addChildBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Bean parent = Snippet019TreeViewerWithListFactory.this.getSelectedBean();
                ArrayList<Bean> list = new ArrayList<Bean>(parent.getList());
                Bean child = Snippet019TreeViewerWithListFactory.createBean("child");
                list.add(child);
                parent.setList(list);
                Snippet019TreeViewerWithListFactory.this.beanViewer.setSelection((ISelection)new StructuredSelection((Object)child));
                Snippet019TreeViewerWithListFactory.this.beanText.selectAll();
                Snippet019TreeViewerWithListFactory.this.beanText.setFocus();
            }
        });
        this.addChildBeanButton.setText("Add Child");
        this.removeBeanButton = new Button(group, 0);
        this.removeBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                Bean parent;
                TreeItem selectedItem = Snippet019TreeViewerWithListFactory.this.beanViewer.getTree().getSelection()[0];
                TreeItem parentItem = selectedItem.getParentItem();
                if (parentItem == null) {
                    parent = Snippet019TreeViewerWithListFactory.this.input;
                    index = Snippet019TreeViewerWithListFactory.this.beanViewer.getTree().indexOf(selectedItem);
                } else {
                    parent = (Bean)parentItem.getData();
                    index = parentItem.indexOf(selectedItem);
                }
                ArrayList<Bean> list = new ArrayList<Bean>(parent.getList());
                list.remove(index);
                parent.setList(list);
            }
        });
        this.removeBeanButton.setText("Remove");
        this.copyButton = new Button(group, 0);
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Snippet019TreeViewerWithListFactory.this.clipboard.setValue((Object)Snippet019TreeViewerWithListFactory.this.getSelectedBean());
            }
        });
        this.copyButton.setText("Copy");
        this.pasteButton = new Button(group, 0);
        this.pasteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Bean copy = (Bean)Snippet019TreeViewerWithListFactory.this.clipboard.getValue();
                if (copy == null) {
                    return;
                }
                Bean parent = Snippet019TreeViewerWithListFactory.this.getSelectedBean();
                if (parent == null) {
                    parent = Snippet019TreeViewerWithListFactory.this.input;
                }
                ArrayList<Bean> list = new ArrayList<Bean>(parent.getList());
                list.add(copy);
                parent.setList(list);
                Snippet019TreeViewerWithListFactory.this.beanViewer.setSelection((ISelection)new StructuredSelection((Object)copy));
                Snippet019TreeViewerWithListFactory.this.beanText.selectAll();
                Snippet019TreeViewerWithListFactory.this.beanText.setFocus();
            }
        });
        this.pasteButton.setText("Paste");
        Button refreshButton = new Button(group, 0);
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Snippet019TreeViewerWithListFactory.this.beanViewer.refresh();
            }
        });
        refreshButton.setText("Refresh");
        this.beanViewer = new TreeViewer((Composite)shell, 67584);
        this.beanViewer.setUseHashlookup(true);
        this.tree = this.beanViewer.getTree();
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label itemNameLabel = new Label((Composite)shell, 0);
        itemNameLabel.setText("Item Name");
        this.beanText = new Text((Composite)shell, 2048);
        GridData gd_beanValue = new GridData(4, 0x1000000, true, false);
        this.beanText.setLayoutData((Object)gd_beanValue);
        this.m_bindingContext = this.initDataBindings();
        this.initExtraBindings(this.m_bindingContext);
        shell.open();
        return shell;
    }

    private static Bean createBean(String name) {
        return new Bean(name);
    }

    protected DataBindingContext initDataBindings() {
        IViewerObservableValue treeViewerSelectionObserveSelection = ViewerProperties.singleSelection(Bean.class).observe((Viewer)this.beanViewer);
        ISWTObservableValue textTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.beanText);
        IObservableValue treeViewerValueObserveDetailValue = BeanProperties.value(Bean.class, (String)"text", String.class).observeDetail((IObservableValue)treeViewerSelectionObserveSelection);
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)textTextObserveWidget, treeViewerValueObserveDetailValue);
        return bindingContext;
    }

    private Bean getSelectedBean() {
        ITreeSelection selection = this.beanViewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (Bean)selection.getFirstElement();
    }

    private void initExtraBindings(DataBindingContext bindingContext) {
        IViewerObservableValue beanViewerSelection = ViewerProperties.singleSelection(Bean.class).observe((Viewer)this.beanViewer);
        IObservableValue beanSelected = ComputedValue.create(() -> Snippet019TreeViewerWithListFactory.lambda$1((IObservableValue)beanViewerSelection));
        bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.addChildBeanButton), beanSelected);
        bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.removeBeanButton), beanSelected);
        this.clipboard = new WritableValue();
        bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.copyButton), beanSelected);
        bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.pasteButton), ComputedValue.create(() -> this.clipboard.getValue() != null));
        ViewerSupport.bind((AbstractTreeViewer)this.beanViewer, (Object)this.input, (IListProperty)BeanProperties.list((String)"list", Bean.class), (IValueProperty)BeanProperties.value(Bean.class, (String)"text"));
    }

    private static /* synthetic */ Boolean lambda$1(IObservableValue iObservableValue) {
        return iObservableValue.getValue() != null;
    }

    static class Bean {
        PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
        private String text;
        private List<Bean> list;

        public Bean(String text) {
            this.text = text;
            this.list = new ArrayList<Bean>();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String value) {
            this.text = value;
            this.changeSupport.firePropertyChange("text", this.text, this.text);
        }

        public List<Bean> getList() {
            if (this.list == null) {
                return null;
            }
            return new ArrayList<Bean>(this.list);
        }

        public void setList(List<Bean> list) {
            if (list != null) {
                list = new ArrayList<Bean>(list);
            }
            this.list = list;
            this.changeSupport.firePropertyChange("list", this.list, this.list);
        }

        public boolean hasListeners(String propertyName) {
            return this.changeSupport.hasListeners(propertyName);
        }
    }
}

