/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Snippet024SelectObservableValue {
    public static void main(String[] args) {
        Display display = Display.getDefault();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = Snippet024SelectObservableValue.createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private static Shell createShell() {
        Shell shell = new Shell();
        shell.setSize(400, 300);
        shell.setLayout((Layout)new GridLayout(2, true));
        shell.setText("Snippet024SelectObservableValue");
        ListViewer listViewer = new ListViewer((Composite)shell, 2048);
        listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        listViewer.getList().setLayoutData((Object)new GridData(4, 4, true, true));
        Group group = new Group((Composite)shell, 0);
        group.setText("Radio Group");
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout());
        Color[] colors = Color.values();
        listViewer.setInput((Object)colors);
        IViewerObservableValue listViewerSelection = ViewerProperties.singleSelection(Color.class).observe((Viewer)listViewer);
        SelectObservableValue radioGroup = new SelectObservableValue();
        Color[] colorArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            Color color = colorArray[n2];
            Button button = new Button((Composite)group, 16);
            button.setText(color.toString());
            radioGroup.addOption((Object)color, (IObservableValue)WidgetProperties.buttonSelection().observe((Widget)button));
            ++n2;
        }
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)radioGroup, (IObservableValue)listViewerSelection);
        shell.open();
        return shell;
    }

    public static class Color {
        public static final Color RED = new Color("Red");
        public static final Color ORANGE = new Color("Orange");
        public static final Color YELLOW = new Color("Yellow");
        public static final Color GREEN = new Color("Green");
        public static final Color BLUE = new Color("Blue");
        public static final Color INDIGO = new Color("Indigo");
        public static final Color VIOLET = new Color("Violet");
        private final String name;

        private Color(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Color[] values() {
            return new Color[]{RED, ORANGE, YELLOW, GREEN, BLUE, INDIGO, VIOLET};
        }
    }
}

