/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet025TableViewerWithPropertyDerivedColumns {
    private static Person UNKNOWN = new Person("unknown", null, null);

    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new View(new ViewModel()).createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    public static abstract class AbstractModelObject {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    static class Person
    extends AbstractModelObject {
        String name = "Donald Duck";
        Person mother;
        Person father;

        public Person(String name, Person mother, Person father) {
            this.name = name;
            this.mother = mother;
            this.father = father;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.firePropertyChange("name", this.name, this.name);
        }

        public Person getMother() {
            return this.mother;
        }

        public void setMother(Person mother) {
            this.mother = mother;
            this.firePropertyChange("mother", this.mother, this.mother);
        }

        public Person getFather() {
            return this.father;
        }

        public void setFather(Person father) {
            this.father = father;
            this.firePropertyChange("father", this.father, this.father);
        }
    }

    static class View {
        private final ViewModel viewModel;
        private Table duckFamily;
        private Text nameText;
        private Combo motherCombo;
        private Combo fatherCombo;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            this.duckFamily = new Table((Composite)shell, 67584);
            this.duckFamily.setHeaderVisible(true);
            GridDataFactory.defaultsFor((Control)this.duckFamily).span(2, 1).applyTo((Control)this.duckFamily);
            this.createColumn("Name");
            this.createColumn("Mother");
            this.createColumn("Father");
            this.createColumn("Maternal Grandmother");
            this.createColumn("Maternal Grandfather");
            this.createColumn("Paternal Grandmother");
            this.createColumn("Paternal Grandfather");
            this.duckFamily.setLinesVisible(true);
            new Label((Composite)shell, 0).setText("Name:");
            this.nameText = new Text((Composite)shell, 2048);
            GridDataFactory.defaultsFor((Control)this.nameText).grab(true, false).applyTo((Control)this.nameText);
            new Label((Composite)shell, 0).setText("Mother:");
            this.motherCombo = new Combo((Composite)shell, 8);
            new Label((Composite)shell, 0).setText("Father:");
            this.fatherCombo = new Combo((Composite)shell, 8);
            DataBindingContext bindingContext = new DataBindingContext();
            this.bindGUI(bindingContext);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)shell);
            shell.setSize(800, 300);
            shell.open();
            return shell;
        }

        private void createColumn(String string) {
            TableColumn column = new TableColumn(this.duckFamily, 0);
            column.setText(string);
            column.pack();
            if (column.getWidth() < 100) {
                column.setWidth(100);
            }
        }

        protected void bindGUI(DataBindingContext bindingContext) {
            TableViewer peopleViewer = new TableViewer(this.duckFamily);
            peopleViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element != UNKNOWN;
                }
            });
            ViewerSupport.bind((StructuredViewer)peopleViewer, this.viewModel.getPeople(), (IValueProperty[])BeanProperties.values(Person.class, (String[])new String[]{"name", "mother.name", "father.name", "mother.mother.name", "mother.father.name", "father.mother.name", "father.father.name"}));
            IViewerObservableValue masterSelection = ViewerProperties.singleSelection(Person.class).observe((Viewer)peopleViewer);
            bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.nameText), BeanProperties.value(Person.class, (String)"name").observeDetail((IObservableValue)masterSelection));
            ComboViewer mothercomboViewer = new ComboViewer(this.motherCombo);
            ViewerSupport.bind((StructuredViewer)mothercomboViewer, this.viewModel.getPeople(), (IValueProperty)BeanProperties.value(Person.class, (String)"name"));
            bindingContext.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)mothercomboViewer), BeanProperties.value(Person.class, (String)"mother").observeDetail((IObservableValue)masterSelection));
            ComboViewer fatherComboViewer = new ComboViewer(this.fatherCombo);
            ViewerSupport.bind((StructuredViewer)fatherComboViewer, this.viewModel.getPeople(), (IValueProperty)BeanProperties.value(Person.class, (String)"name"));
            bindingContext.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)fatherComboViewer), BeanProperties.value(Person.class, (String)"father").observeDetail((IObservableValue)masterSelection));
        }
    }

    static class ViewModel {
        private final IObservableList<Person> people = new WritableList();

        ViewModel() {
            Person fergus = new Person("Fergus McDuck", UNKNOWN, UNKNOWN);
            Person downy = new Person("Downy O'Drake", UNKNOWN, UNKNOWN);
            Person scrooge = new Person("Scrooge McDuck", downy, fergus);
            Person hortense = new Person("Hortense McDuck", downy, fergus);
            Person quackmore = new Person("Quackmore Duck", UNKNOWN, UNKNOWN);
            Person della = new Person("Della Duck", hortense, quackmore);
            Person donald = new Person("Donald Duck", hortense, quackmore);
            this.people.add((Object)UNKNOWN);
            this.people.add((Object)downy);
            this.people.add((Object)fergus);
            this.people.add((Object)scrooge);
            this.people.add((Object)quackmore);
            this.people.add((Object)hortense);
            this.people.add((Object)della);
            this.people.add((Object)donald);
        }

        public IObservableList<Person> getPeople() {
            return this.people;
        }
    }
}

