/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.core.databinding.property.set.DelegatingSetProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.set.SimpleSetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class Snippet026AnonymousBeanProperties {
    private ComboViewer statusViewer;
    private Combo combo;
    private Text nameText;
    private TreeViewer contactViewer;
    private ApplicationModel model;
    private Tree tree;
    private static final String[] STATUSES = new String[]{"Online", "Idle", "Busy", "Offline"};

    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new Snippet026AnonymousBeanProperties().createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private ApplicationModel createDefaultModel() {
        ContactGroup swtGroup = new ContactGroup("SWT");
        swtGroup.addContact(new Contact("Steve Northover", "Busy"));
        swtGroup.addContact(new Contact("Grant Gayed", "Online"));
        swtGroup.addContact(new Contact("Veronika Irvine", "Offline"));
        swtGroup.addContact(new Contact("Mike Wilson", "Online"));
        swtGroup.addContact(new Contact("Christophe Cornu", "Idle"));
        swtGroup.addContact(new Contact("Lynne Kues", "Online"));
        swtGroup.addContact(new Contact("Silenio Quarti", "Idle"));
        ContactGroup jdbGroup = new ContactGroup("JFace Data Binding");
        jdbGroup.addContact(new Contact("Boris Bokowski", "Online"));
        jdbGroup.addContact(new Contact("Matthew Hall", "Idle"));
        TreeSet<ContactGroup> groups = new TreeSet<ContactGroup>();
        groups.add(swtGroup);
        groups.add(jdbGroup);
        ApplicationModel model = new ApplicationModel();
        model.setGroups(groups);
        return model;
    }

    protected Shell createShell() {
        this.model = this.createDefaultModel();
        Shell shell = new Shell();
        shell.setSize(379, 393);
        shell.setText("Snippet026AnonymousBeanProperties");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        shell.setLayout((Layout)gridLayout);
        this.contactViewer = new TreeViewer((Composite)shell, 2048);
        this.tree = this.contactViewer.getTree();
        this.tree.setHeaderVisible(true);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        TreeColumn nameColumn = new TreeColumn(this.tree, 0);
        nameColumn.setWidth(163);
        nameColumn.setText("Name");
        TreeColumn newColumnTreeColumn = new TreeColumn(this.tree, 0);
        newColumnTreeColumn.setWidth(100);
        newColumnTreeColumn.setText("Status");
        Label nameLabel = new Label((Composite)shell, 0);
        nameLabel.setText("Name");
        this.nameText = new Text((Composite)shell, 2048);
        GridData gd_nameText = new GridData(4, 0x1000000, true, false);
        this.nameText.setLayoutData((Object)gd_nameText);
        Label statusLabel = new Label((Composite)shell, 0);
        statusLabel.setLayoutData((Object)new GridData());
        statusLabel.setText("Status");
        this.statusViewer = new ComboViewer((Composite)shell, 8);
        this.combo = this.statusViewer.getCombo();
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.bindUI();
        shell.open();
        return shell;
    }

    private void bindUI() {
        DelegatingSetProperty<Object, Object> treeChildrenProperty = new DelegatingSetProperty<Object, Object>(){
            ISetProperty<ApplicationModel, ContactGroup> modelGroups = BeanProperties.set(ApplicationModel.class, (String)"groups", ContactGroup.class);
            ISetProperty<ContactGroup, Contact> groupContacts = BeanProperties.set(ContactGroup.class, (String)"contacts", Contact.class);

            protected ISetProperty<Object, Object> doGetDelegate(Object source) {
                if (source instanceof ApplicationModel) {
                    return this.modelGroups;
                }
                if (source instanceof ContactGroup) {
                    return this.groupContacts;
                }
                return null;
            }
        };
        ViewerSupport.bind((AbstractTreeViewer)this.contactViewer, (Object)this.model, (ISetProperty)treeChildrenProperty, (IValueProperty[])BeanProperties.values((String[])new String[]{"name", "status"}));
        this.contactViewer.expandAll();
        IViewerObservableValue selection = ViewerProperties.singleSelection().observe((Viewer)this.contactViewer);
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.nameText), BeanProperties.value((String)"name").observeDetail((IObservableValue)selection));
        this.statusViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.statusViewer.setInput((Object)STATUSES);
        bindingContext.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.statusViewer), BeanProperties.value((String)"status").observeDetail((IObservableValue)selection));
        bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.statusViewer.getControl()), ComputedValue.create(() -> Snippet026AnonymousBeanProperties.lambda$1((IObservableValue)selection)));
    }

    private static /* synthetic */ Boolean lambda$1(IObservableValue iObservableValue) {
        return iObservableValue.getValue() instanceof Contact;
    }

    public static abstract class AbstractModelObject {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public static class ApplicationModel
    extends AbstractModelObject {
        private Set<ContactGroup> groups = new TreeSet<ContactGroup>();

        public Set<ContactGroup> getGroups() {
            return new TreeSet<ContactGroup>(this.groups);
        }

        public void setGroups(Set<ContactGroup> groups) {
            Set<ContactGroup> oldValue = this.getGroups();
            this.groups = new TreeSet<ContactGroup>(groups);
            Set<ContactGroup> newValue = this.getGroups();
            this.firePropertyChange("groups", oldValue, newValue);
        }
    }

    public static class Contact
    extends AbstractModelObject
    implements Comparable<Contact> {
        private String name;
        private String status;

        public Contact(String name, String status) {
            this.name = name;
            this.status = status;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.firePropertyChange("name", this.name, this.name);
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
            this.firePropertyChange("status", this.status, this.status);
        }

        @Override
        public int compareTo(Contact that) {
            int result = this.name.compareTo(that.name);
            if (result == 0) {
                result = this.status.compareTo(that.status);
            }
            return result;
        }
    }

    public static class ContactGroup
    extends AbstractModelObject
    implements Comparable<ContactGroup> {
        private String name;
        private final Set<Contact> contacts = new TreeSet<Contact>();

        ContactGroup(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.firePropertyChange("name", this.name, this.name);
        }

        public Set<Contact> getContacts() {
            return new TreeSet<Contact>(this.contacts);
        }

        public void addContact(Contact contact) {
            Set<Contact> oldValue = this.getContacts();
            this.contacts.add(contact);
            Set<Contact> newValue = this.getContacts();
            this.firePropertyChange("contacts", oldValue, newValue);
        }

        public void removeContact(Contact contact) {
            Set<Contact> oldValue = this.getContacts();
            this.contacts.remove(contact);
            Set<Contact> newValue = this.getContacts();
            this.firePropertyChange("contacts", oldValue, newValue);
        }

        @Override
        public int compareTo(ContactGroup that) {
            return this.name.compareTo(that.name);
        }
    }

    public static class ContactGroupContactsProperty
    extends SimpleSetProperty<ContactGroup, Contact> {
        public Object getElementType() {
            return Contact.class;
        }

        protected Set<Contact> doGetSet(ContactGroup source) {
            if (source == null) {
                return Collections.emptySet();
            }
            return source.getContacts();
        }

        protected void doSetSet(ContactGroup source, Set<Contact> set, SetDiff<Contact> diff) {
            this.doUpdateSet(source, diff);
        }

        protected void doUpdateSet(ContactGroup group, SetDiff<Contact> diff) {
            for (Contact contact : diff.getRemovals()) {
                group.removeContact(contact);
            }
            for (Contact contact : diff.getAdditions()) {
                group.addContact(contact);
            }
        }

        public INativePropertyListener<ContactGroup> adaptListener(ISimplePropertyListener<ContactGroup, SetDiff<Contact>> listener) {
            return new Listener((IProperty)this, listener);
        }

        private class Listener
        extends NativePropertyListener<ContactGroup, SetDiff<Contact>>
        implements PropertyChangeListener {
            Listener(IProperty property, ISimplePropertyListener<ContactGroup, SetDiff<Contact>> listener) {
                super(property, listener);
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.fireChange((ContactGroup)evt.getSource(), null);
            }

            protected void doAddTo(ContactGroup source) {
                source.addPropertyChangeListener("contacts", this);
            }

            protected void doRemoveFrom(ContactGroup source) {
                source.removePropertyChangeListener("contacts", this);
            }
        }
    }
}

