/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.time.LocalDateTime;
import java.time.LocalTime;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.LocalDateTimeObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet030DateAndTimeObservableValue {
    private Text modelText;
    private DateTime date;
    private DateTime calendar;
    private DateTime time;
    private Button syncTime;

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new Snippet030DateAndTimeObservableValue().createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private Shell createShell() {
        Shell shell = new Shell();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        shell.setLayout((Layout)layout);
        shell.setText("Snippet030DateAndTimeObservableValue.java");
        new Label((Composite)shell, 0).setText("Model date + time");
        this.modelText = new Text((Composite)shell, 2048);
        this.modelText.setEditable(false);
        this.modelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new Label((Composite)shell, 0).setText("Target date (SWT.DATE)");
        this.date = new DateTime((Composite)shell, 2080);
        this.date.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        new Label((Composite)shell, 0).setText("Target date (SWT.CALENDAR)");
        this.calendar = new DateTime((Composite)shell, 1024);
        this.calendar.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        new Label((Composite)shell, 0).setText("Target time");
        this.time = new DateTime((Composite)shell, 2176);
        this.syncTime = new Button((Composite)shell, 32);
        this.syncTime.setLayoutData((Object)new GridData());
        this.syncTime.setText("Sync with system time");
        this.bindUI();
        shell.pack();
        shell.open();
        return shell;
    }

    private void bindUI() {
        DataBindingContext bindingContext = new DataBindingContext();
        WritableValue model = WritableValue.withValueType(LocalDateTime.class);
        model.setValue((Object)LocalDateTime.now());
        bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.modelText), (IObservableValue)model);
        ISWTObservableValue timeSelection = WidgetProperties.localTimeSelection().observe((Widget)this.time);
        bindingContext.bindValue((IObservableValue)new LocalDateTimeObservableValue((IObservableValue)WidgetProperties.localDateSelection().observe((Widget)this.date), (IObservableValue)timeSelection), (IObservableValue)model);
        bindingContext.bindValue((IObservableValue)new LocalDateTimeObservableValue((IObservableValue)WidgetProperties.localDateSelection().observe((Widget)this.calendar), (IObservableValue)timeSelection), (IObservableValue)model);
        this.syncTime.addListener(13, arg_0 -> this.lambda$1((IObservableValue)timeSelection, arg_0));
    }

    private /* synthetic */ void lambda$1(final IObservableValue iObservableValue, Event event) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!Snippet030DateAndTimeObservableValue.this.syncTime.isDisposed() && Snippet030DateAndTimeObservableValue.this.syncTime.getSelection()) {
                    iObservableValue.setValue((Object)LocalTime.now());
                    Display.getCurrent().timerExec(100, (Runnable)this);
                }
            }
        };
        this.time.setEnabled(!this.syncTime.getSelection());
        if (this.syncTime.getSelection()) {
            runnable.run();
        }
    }
}

