/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.util.JFaceProperties;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet031JFaceObservable {
    public static final String NAME_PROPERTY = "name_property";

    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new View(new ViewModel()).createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        System.out.println("person.getName() = " + new ViewModel().getPerson().getName());
    }

    public static class Person
    extends EventManager {
        String name = "HelloWorld";

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.fireChange(new PropertyChangeEvent((Object)this, Snippet031JFaceObservable.NAME_PROPERTY, (Object)this.name, (Object)this.name));
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
            this.addListenerObject(listener);
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
            this.removeListenerObject(listener);
        }

        private void fireChange(PropertyChangeEvent event) {
            Object[] list;
            Object[] objectArray = list = this.getListeners();
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                ((IPropertyChangeListener)element).propertyChange(event);
                ++n2;
            }
        }
    }

    static class View {
        private final ViewModel viewModel;
        private Text name;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            shell.setLayout((Layout)new RowLayout(512));
            this.name = new Text((Composite)shell, 2048);
            DataBindingContext bindingContext = new DataBindingContext();
            Person person = this.viewModel.getPerson();
            IValueProperty nameProperty = JFaceProperties.value(Person.class, (String)"name", (String)Snippet031JFaceObservable.NAME_PROPERTY);
            bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.name), nameProperty.observe((Object)person));
            Label label = new Label((Composite)shell, 0);
            bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)label), nameProperty.observe((Object)person));
            shell.pack();
            shell.open();
            return shell;
        }
    }

    static class ViewModel {
        private final Person person = new Person();

        ViewModel() {
        }

        public Person getPerson() {
            return this.person;
        }
    }
}

