/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Snippet033CrossValidationControlDecoration {
    private DateTime startDate;
    private DateTime endDate;

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new Snippet033CrossValidationControlDecoration().createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    protected Shell createShell() {
        Shell shell = new Shell();
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        shell.setLayout((Layout)layout);
        shell.setText("Snippet033CrossValidationControlDecoration.java");
        Label label = new Label((Composite)shell, 0);
        label.setLayoutData((Object)new GridData());
        label.setText("Start date");
        this.startDate = new DateTime((Composite)shell, 1024);
        GridData gd_startDate = new GridData();
        gd_startDate.horizontalIndent = 10;
        this.startDate.setLayoutData((Object)gd_startDate);
        Label startDateLabel = new Label((Composite)shell, 0);
        startDateLabel.setLayoutData((Object)new GridData());
        startDateLabel.setText("End date");
        this.endDate = new DateTime((Composite)shell, 1024);
        GridData gd_endDate = new GridData();
        gd_endDate.horizontalIndent = 10;
        this.endDate.setLayoutData((Object)gd_endDate);
        this.bindUI();
        shell.open();
        shell.pack();
        return shell;
    }

    private void bindUI() {
        ISWTObservableValue startDateObservable = WidgetProperties.localDateSelection().observe((Widget)this.startDate);
        ISWTObservableValue endDateObservable = WidgetProperties.localDateSelection().observe((Widget)this.endDate);
        ControlDecorationSupport.create((ValidationStatusProvider)new DateRangeValidator((IObservableValue<LocalDate>)startDateObservable, (IObservableValue<LocalDate>)endDateObservable, "Start date must be on or before end date"), (int)0x1004000);
        ControlDecorationUpdater decorationUpdater = new ControlDecorationUpdater(){

            protected String getDescriptionText(IStatus status) {
                return "ERROR: " + super.getDescriptionText(status);
            }

            protected Image getImage(IStatus status) {
                return status.isOK() ? null : Display.getCurrent().getSystemImage(1);
            }
        };
        ControlDecorationSupport.create((ValidationStatusProvider)new DateRangeValidator((IObservableValue<LocalDate>)Observables.constantObservableValue((Object)LocalDate.now()), (IObservableValue<LocalDate>)startDateObservable, "Choose a starting date later than today"), (int)16512, null, (ControlDecorationUpdater)decorationUpdater);
    }

    private static class DateRangeValidator
    extends MultiValidator {
        private final IObservableValue<LocalDate> start;
        private final IObservableValue<LocalDate> end;
        private final String errorMessage;

        public DateRangeValidator(IObservableValue<LocalDate> start, IObservableValue<LocalDate> end, String errorMessage) {
            this.start = start;
            this.end = end;
            this.errorMessage = errorMessage;
        }

        protected IStatus validate() {
            if (((LocalDate)this.start.getValue()).compareTo((ChronoLocalDate)this.end.getValue()) > 0) {
                return ValidationStatus.error((String)this.errorMessage);
            }
            return ValidationStatus.ok();
        }
    }
}

