/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.EnumConverters;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet034ComboViewerAndEnum {
    public static void main(String[] args) {
        Display display = new Display();
        Person model = new Person("Pat", Gender.UNKNOWN);
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new View(model).createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        System.out.println("person.getName() = " + model.getName());
        System.out.println("person.getGender() = " + String.valueOf((Object)model.getGender()));
    }

    static enum Gender {
        MALE("Male"),
        FEMALE("Female"),
        UNKNOWN("Unknown"),
        OTHER("Other");

        private final String displayName;

        private Gender(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }

    static class Person {
        private String name;
        private Gender gender;
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public Person(String name, Gender gender) {
            this.name = name;
            this.gender = gender;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newName) {
            String old = this.name;
            this.name = newName;
            this.propertyChangeSupport.firePropertyChange("name", old, this.name);
        }

        public Gender getGender() {
            return this.gender;
        }

        public void setGender(Gender newGender) {
            Gender old = this.gender;
            this.gender = newGender;
            this.propertyChangeSupport.firePropertyChange("gender", (Object)old, (Object)this.gender);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    static class View {
        private final Person viewModel;
        private Text name;
        private ComboViewer gender;
        private Label genderText;

        public View(Person viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            RowLayout layout = new RowLayout(512);
            layout.fill = true;
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            shell.setLayout((Layout)layout);
            this.name = new Text((Composite)shell, 2048);
            this.gender = new ComboViewer((Composite)shell, 8);
            this.genderText = new Label((Composite)shell, 0);
            this.gender.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.gender.setInput((Object)Gender.values());
            DataBindingContext bindingContext = new DataBindingContext();
            bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.name), PojoProperties.value(Person.class, (String)"name").observe((Object)this.viewModel));
            bindingContext.bindValue((IObservableValue)ViewerProperties.singleSelection(Gender.class).observe((Viewer)this.gender), PojoProperties.value(Person.class, (String)"gender").observe((Object)this.viewModel));
            bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.genderText), BeanProperties.value(Person.class, (String)"gender", Gender.class).observe((Object)this.viewModel), null, UpdateValueStrategy.create((IConverter)EnumConverters.toString(Gender.class)));
            shell.pack();
            shell.open();
            return shell;
        }
    }
}

