/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffect;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet038SideEffectConditionalBinding {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new View(new Person()).createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    static class Person {
        private final WritableValue<String> firstName = new WritableValue((Object)"Simon", String.class);
        private final WritableValue<String> lastName = new WritableValue((Object)"Scholz", String.class);

        Person() {
        }

        public String getFirstName() {
            return (String)this.firstName.getValue();
        }

        public void setFirstName(String firstName) {
            this.firstName.setValue((Object)firstName);
        }

        public String getLastName() {
            return (String)this.lastName.getValue();
        }

        public void setLastName(String lastName) {
            this.lastName.setValue((Object)lastName);
        }
    }

    static class View {
        private final Person person;
        private Text personNameText;
        private Button showDescriptionButton;
        private Button changeNameButton;

        public View(Person person) {
            this.person = person;
        }

        public Shell createShell() {
            Shell shell = new Shell();
            GridLayoutFactory.swtDefaults().applyTo((Composite)shell);
            GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().grab(true, false);
            this.personNameText = new Text((Composite)shell, 8);
            gridDataFactory.applyTo((Control)this.personNameText);
            this.showDescriptionButton = new Button((Composite)shell, 32);
            this.showDescriptionButton.setText("Show full name");
            gridDataFactory.applyTo((Control)this.showDescriptionButton);
            this.changeNameButton = new Button((Composite)shell, 8);
            this.changeNameButton.setText("Change Last Name");
            gridDataFactory.applyTo((Control)this.changeNameButton);
            this.changeNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    person.setLastName("Xenos");
                }
            });
            this.bindData();
            shell.pack();
            shell.open();
            return shell;
        }

        private void bindData() {
            ISWTObservableValue showDescription = WidgetProperties.buttonSelection().observe((Widget)this.showDescriptionButton);
            ISideEffect personNameSideEffect = ISideEffect.create(() -> this.lambda$0((IObservableValue)showDescription));
            this.personNameText.addDisposeListener(e -> personNameSideEffect.dispose());
        }

        private /* synthetic */ void lambda$0(IObservableValue iObservableValue) {
            String name = (Boolean)iObservableValue.getValue() != false ? this.person.getFirstName() + " " + this.person.getLastName() : this.person.getFirstName();
            this.personNameText.setText(name);
        }
    }
}

