/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffectFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetSideEffects;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet039SideEffectMigration {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            ObservableBeanPerson observableBeanPerson = new ObservableBeanPerson();
            Shell observableShell = new ObservableView(observableBeanPerson).createShell();
            TrackedPerson trackedPerson = new TrackedPerson();
            Shell trackedShell = new TrackedView(trackedPerson).createShell();
            while (!observableShell.isDisposed() && !trackedShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
    }

    static class ObservableBeanPerson {
        public static final String PROPERTY_FIRST_NAME = "firstName";
        public static final String PROPERTY_LAST_NAME = "lastName";
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
        private String firstName = "Simon";
        private String lastName = "Scholz";

        ObservableBeanPerson() {
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_FIRST_NAME, this.firstName, this.firstName);
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_LAST_NAME, this.lastName, this.lastName);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    static class ObservableView {
        private final ObservableBeanPerson person;
        private Text personFirstNameText;
        private Text personLastNameText;

        public ObservableView(ObservableBeanPerson person) {
            this.person = person;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            shell.setText("DatabindingContext Sample");
            new Label((Composite)shell, 0).setText("First Name:");
            this.personFirstNameText = new Text((Composite)shell, 2048);
            new Label((Composite)shell, 0).setText("Last Name:");
            this.personLastNameText = new Text((Composite)shell, 2048);
            this.bindData();
            GridLayoutFactory.fillDefaults().numColumns(2).generateLayout((Composite)shell);
            shell.pack();
            shell.open();
            return shell;
        }

        private void bindData() {
            DataBindingContext bindingContext = new DataBindingContext();
            IObservableValue personFirstNameObservable = BeanProperties.value((String)"firstName", String.class).observe((Object)this.person);
            ISWTObservableValue personFirstNameTextObservable = WidgetProperties.text((int)24).observe((Widget)this.personFirstNameText);
            bindingContext.bindValue((IObservableValue)personFirstNameTextObservable, personFirstNameObservable, new UpdateValueStrategy().setAfterConvertValidator(obj -> {
                if (obj == null || obj.isEmpty()) {
                    return ValidationStatus.error((String)"First Name may not be empty");
                }
                return Status.OK_STATUS;
            }), null);
            IObservableValue personLastNameObservable = BeanProperties.value((String)"lastName", String.class).observe((Object)this.person);
            ISWTObservableValue personLastNameTextObservable = WidgetProperties.text((int)24).observe((Widget)this.personLastNameText);
            bindingContext.bindValue((IObservableValue)personLastNameTextObservable, personLastNameObservable, new UpdateValueStrategy().setAfterConvertValidator(obj -> {
                if (obj == null || obj.isEmpty()) {
                    return ValidationStatus.error((String)"Last Name may not be empty");
                }
                return Status.OK_STATUS;
            }), null);
            IObservableList validationStatusProviders = bindingContext.getValidationStatusProviders();
            for (ValidationStatusProvider statusProvider : validationStatusProviders) {
                ControlDecorationSupport.create((ValidationStatusProvider)statusProvider, (int)16512);
            }
            this.personFirstNameText.addDisposeListener(e -> bindingContext.dispose());
        }
    }

    static class TrackedPerson {
        private final WritableValue<String> firstName = new WritableValue((Object)"Simon", String.class);
        private final WritableValue<String> lastName = new WritableValue((Object)"Scholz", String.class);

        TrackedPerson() {
        }

        public String getFirstName() {
            return (String)this.firstName.getValue();
        }

        public void setFirstName(String firstName) {
            this.firstName.setValue((Object)firstName);
        }

        public String getLastName() {
            return (String)this.lastName.getValue();
        }

        public void setLastName(String lastName) {
            this.lastName.setValue((Object)lastName);
        }
    }

    static class TrackedView {
        private final TrackedPerson person;
        private Text personFirstNameText;
        private Text personLastNameText;

        public TrackedView(TrackedPerson person) {
            this.person = person;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            shell.setText("ISideEffect Sample");
            new Label((Composite)shell, 0).setText("First Name:");
            this.personFirstNameText = new Text((Composite)shell, 2048);
            new Label((Composite)shell, 0).setText("Last Name:");
            this.personLastNameText = new Text((Composite)shell, 2048);
            this.bindData();
            GridLayoutFactory.fillDefaults().numColumns(2).generateLayout((Composite)shell);
            shell.pack();
            shell.open();
            return shell;
        }

        private void bindData() {
            ISWTObservableValue personFirstNameTextObservable = WidgetProperties.text((int)24).observe((Widget)this.personFirstNameText);
            ISWTObservableValue personLastNameTextObservable = WidgetProperties.text((int)24).observe((Widget)this.personLastNameText);
            ISideEffectFactory sideEffectFactory = WidgetSideEffects.createFactory((Widget)this.personFirstNameText);
            sideEffectFactory.create(this.person::getFirstName, arg_0 -> ((Text)this.personFirstNameText).setText(arg_0));
            WritableValue firstNameValidation = new WritableValue();
            sideEffectFactory.create(() -> this.lambda$2((IObservableValue)personFirstNameTextObservable, firstNameValidation));
            ControlDecorationSupport.create((IObservableValue)firstNameValidation, (int)16512, (IObservable[])new IObservable[]{personFirstNameTextObservable});
            sideEffectFactory.create(this.person::getLastName, arg_0 -> ((Text)this.personLastNameText).setText(arg_0));
            WritableValue lastNameValidation = new WritableValue();
            sideEffectFactory.create(() -> this.lambda$5((IObservableValue)personLastNameTextObservable, lastNameValidation));
            ControlDecorationSupport.create((IObservableValue)lastNameValidation, (int)16512, (IObservable[])new IObservable[]{personLastNameTextObservable});
        }

        private /* synthetic */ void lambda$2(IObservableValue iObservableValue, WritableValue writableValue) {
            String firstName = (String)iObservableValue.getValue();
            if (firstName != null && firstName.isEmpty()) {
                writableValue.setValue((Object)ValidationStatus.error((String)"First Name may not be empty"));
                return;
            }
            this.person.setFirstName(firstName);
            writableValue.setValue((Object)Status.OK_STATUS);
        }

        private /* synthetic */ void lambda$5(IObservableValue iObservableValue, WritableValue writableValue) {
            String lastName = (String)iObservableValue.getValue();
            if (lastName != null && lastName.isEmpty()) {
                writableValue.setValue((Object)ValidationStatus.error((String)"Last Name may not be empty"));
                return;
            }
            this.person.setLastName(lastName);
            writableValue.setValue((Object)Status.OK_STATUS);
        }
    }
}

