/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.util.Objects;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.bind.Bind;
import org.eclipse.core.databinding.bind.steps.ValueOneWaySteps;
import org.eclipse.core.databinding.bind.steps.ValueTwoWaySteps;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet043BindApi {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = Snippet043BindApi.createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private static Shell createShell() {
        Shell shell = new Shell();
        shell.setText("Data Binding Snippet 004");
        shell.setLayout((Layout)new GridLayout(2, false));
        LabelFactory.newLabel((int)0).text("Enter '5' to be valid:").create((Widget)shell);
        Text text = (Text)((TextFactory)TextFactory.newText((int)2048).layoutData((Object)GridDataFactory.fillDefaults().create())).create((Widget)shell);
        LabelFactory.newLabel((int)0).text("Error:").create((Widget)shell);
        Label errorLabel = (Label)((LabelFactory)((LabelFactory)LabelFactory.newLabel((int)0).foreground(Display.getCurrent().getSystemColor(3))).layoutData((Object)GridDataFactory.fillDefaults().hint(200, -1).create())).create((Widget)shell);
        WritableValue value = new WritableValue((Object)3, Integer.class);
        ButtonFactory.newButton((int)0).text("Set zero!").onSelect(e -> value.setValue((Object)0)).create((Widget)shell);
        ButtonFactory.newButton((int)0).text("Set five!").onSelect(e -> value.setValue((Object)5)).create((Widget)shell);
        DataBindingContext bindingContext = new DataBindingContext();
        IValidator fiveValidator = v -> v == 5 ? ValidationStatus.ok() : ValidationStatus.error((String)("Value was '" + String.valueOf(v) + "', not '5'"));
        ((ValueTwoWaySteps.ValueTwoWayBindConfigStep)((ValueTwoWaySteps.ValueTwoWayConvertToStep)Bind.twoWay().from((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text)).validateTwoWay(v -> v.matches("\\s*\\d+\\s*") ? Status.OK_STATUS : ValidationStatus.error((String)("Not a number: '" + v + "'")))).convertTo(IConverter.create(s -> s.isEmpty() ? 0 : Integer.decode(s))).convertFrom(IConverter.create(i -> Objects.toString(i, ""))).to((IObservableValue)value).validateAfterConvert(fiveValidator)).bind(bindingContext);
        ((ValueOneWaySteps.ValueOneWayBindWriteConfigStep)((ValueOneWaySteps.ValueOneWayConvertStep)Bind.oneWay().from((IObservableValue)value).validateAfterGet(fiveValidator)).defaultConvert().to(Observables.constantObservableValue(null)).convertOnly()).bind(bindingContext);
        Bind.oneWay().from((IObservableValue)new AggregateValidationStatus((IObservableCollection)bindingContext.getBindings(), 2)).defaultConvert().to((IObservableValue)WidgetProperties.text().observe((Widget)errorLabel)).bind(bindingContext);
        shell.pack();
        shell.open();
        return shell;
    }
}

