/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.awt.AWTException;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;

public class AwtScreenshot {
    private static final int TIMEOUT_SECONDS = 15;

    public static void main(String[] args) {
        try {
            System.setProperty("java.awt.headless", "false");
            Robot robot = new Robot();
            Rectangle rect = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
            BufferedImage image = robot.createScreenCapture(rect);
            File file = new File(args[0]);
            ImageIO.write((RenderedImage)image, "png", file);
            System.out.println("AWT screenshot saved to: " + file.getAbsolutePath());
        }
        catch (AWTException | HeadlessException | IOException e) {
            e.printStackTrace();
            System.exit(3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dumpAwtScreenshot(String screenshotFile) {
        try {
            URL location = AwtScreenshot.class.getProtectionDomain().getCodeSource().getLocation();
            Object cp = location.toURI().getPath();
            if (new File((String)cp).isDirectory() && !((String)cp).endsWith(File.separatorChar + "bin" + File.separatorChar) && new File((String)cp + "bin" + File.separatorChar).isDirectory()) {
                cp = (String)cp + "bin" + File.separatorChar;
            }
            String javaHome = System.getProperty("java.home");
            String javaExe = javaHome + File.separatorChar + "bin" + File.separatorChar + "java";
            if (File.separatorChar == '\\') {
                javaExe = javaExe + ".exe";
            }
            String[] args = new String[]{javaExe, "-cp", cp, AwtScreenshot.class.getName(), screenshotFile};
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            if ("Mac OS X".equals(System.getProperty("os.name"))) {
                processBuilder.environment().put("AWT_TOOLKIT", "CToolkit");
            }
            Process process = processBuilder.start();
            Throwable throwable = null;
            Object var9_11 = null;
            try {
                InputStream errorStream = process.getErrorStream();
                try {
                    block24: {
                        try (InputStream inputStream = process.getInputStream();){
                            ByteArrayOutputStream errorOut = new ByteArrayOutputStream();
                            new StreamForwarder(errorStream, new PrintStream(errorOut)).start();
                            new StreamForwarder(inputStream, System.out).start();
                            try {
                                process.waitFor(15L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException ie) {
                                ie.printStackTrace();
                            }
                            if (!process.isAlive()) {
                                int exitCode = process.exitValue();
                                if (exitCode != 0) {
                                    throw new RuntimeException("AwtScreenshot VM finished with exit code " + exitCode + ":\n" + errorOut.toString());
                                }
                                if (errorOut.size() > 0) {
                                    System.out.println(errorOut.toString());
                                }
                                break block24;
                            }
                            process.destroy();
                            throw new RuntimeException("Killed AwtScreenshot VM after 15 seconds:\n" + errorOut.toString());
                        }
                    }
                    if (errorStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (errorStream == null) throw throwable;
                    errorStream.close();
                    throw throwable;
                }
                errorStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static class StreamForwarder
    extends Thread {
        private InputStream fProcessOutput;
        private PrintStream fStream;

        public StreamForwarder(InputStream processOutput, PrintStream stream) {
            this.fProcessOutput = processOutput;
            this.fStream = stream;
        }

        @Override
        public void run() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.fProcessOutput));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        this.fStream.println(line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

