/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

class ClassLoaderTools {
    ClassLoaderTools() {
    }

    public static ClassLoader getPluginClassLoader(Bundle bundle, final ClassLoader fallback) {
        return new ClassLoader(((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader()){

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                Enumeration<URL> supr = super.getResources(name);
                return supr != null && supr.hasMoreElements() ? supr : fallback.getResources(name);
            }

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                try {
                    return super.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    return fallback.loadClass(name);
                }
            }
        };
    }

    static Bundle getTestBundle(String pluginName, String className) {
        if (pluginName != null) {
            Bundle bundle = Platform.getBundle((String)pluginName);
            if (bundle != null) {
                return bundle;
            }
        } else if (className != null) {
            int index = className.lastIndexOf(46);
            while (index != -1) {
                String symbolicName = className.substring(0, index);
                Bundle bundle = Platform.getBundle((String)symbolicName);
                if (bundle != null) {
                    return bundle;
                }
                index = className.lastIndexOf(46, index - 1);
            }
        }
        throw new IllegalArgumentException("Bundle \"" + pluginName + "\" not found. Possible causes include missing dependencies, too restrictive version ranges, or a non-matching required execution environment.");
    }

    static ClassLoader getJUnit5Classloader(List<Bundle> platformEngineBundles) {
        return new MultiBundleClassLoader(platformEngineBundles);
    }

    private static class MultiBundleClassLoader
    extends ClassLoader {
        private final List<Bundle> bundleList;

        public MultiBundleClassLoader(List<Bundle> platformEngineBundles) {
            this.bundleList = platformEngineBundles;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            for (Bundle bundle : this.bundleList) {
                try {
                    Class c = bundle.loadClass(name);
                    if (c == null) continue;
                    return c;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        protected URL findResource(String name) {
            for (Bundle bundle : this.bundleList) {
                URL url = bundle.getResource(name);
                if (url == null) continue;
                return url;
            }
            return null;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            ArrayList<URL> resources = new ArrayList<URL>();
            for (Bundle bundle : this.bundleList) {
                Enumeration bundleResources = bundle.getResources(name);
                while (bundleResources != null && bundleResources.hasMoreElements()) {
                    resources.add((URL)bundleResources.nextElement());
                }
            }
            return Collections.enumeration(resources);
        }
    }
}

