/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.File;
import java.util.function.Supplier;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.test.AwtScreenshot;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public final class Screenshots {
    @Deprecated
    public static TestWatcher onFailure() {
        return Screenshots.onFailure(null);
    }

    public static ScreenshotOnFailure onFailure(Supplier<Widget> shell) {
        return new ScreenshotOnFailure(shell);
    }

    public static String takeScreenshot(Class<?> testClass, String name) {
        File resultsDir = Screenshots.getResultsDirectory();
        String filename = new File(resultsDir.getAbsolutePath(), testClass.getName() + "." + name + ".png").getAbsolutePath();
        AwtScreenshot.dumpAwtScreenshot(filename);
        return filename;
    }

    public static File getResultsDirectory() {
        File resultsDir = Screenshots.getJunitReportOutput();
        if (resultsDir == null) {
            File eclipseDir = new File("").getAbsoluteFile();
            resultsDir = Screenshots.isRunByGerritHudsonJob() ? new File(eclipseDir, "/../").getAbsoluteFile() : new File(System.getProperty("java.io.tmpdir"));
        }
        resultsDir.mkdirs();
        return resultsDir;
    }

    private static File getJunitReportOutput() {
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length - 1) {
            if ("-junitReportOutput".equals(args[i])) {
                return new File(args[i + 1]).getAbsoluteFile();
            }
            ++i;
        }
        return null;
    }

    public static boolean isRunByGerritHudsonJob() {
        return System.getProperty("user.dir").matches(".*/(?:eclipse|rt\\.equinox)\\.[^/]+-Gerrit/.*");
    }

    public static class ScreenshotOnFailure
    extends TestWatcher {
        private final Supplier<Widget> shell;

        public ScreenshotOnFailure(Supplier<Widget> shell) {
            this.shell = shell;
        }

        protected void failed(Throwable e, Description description) {
            String screenshot = Screenshots.takeScreenshot(description.getTestClass(), description.getMethodName());
            e.addSuppressed(new Throwable("Screenshot written to " + screenshot));
            super.failed(e, description);
        }

        protected void finished(Description description) {
            this.dispose();
            super.finished(description);
        }

        public void dispose() {
            if (this.shell == null) {
                return;
            }
            Widget widget = this.shell.get();
            if (widget != null && !widget.isDisposed()) {
                widget.dispose();
            }
        }
    }
}

