/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.test.Screenshots;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class TracingSuite
extends Suite {
    private TracingOptions fTracingOptions;

    private static String format(Date time, Description description) {
        String now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US).format(time);
        String message = "[" + now + "] " + description.getClassName() + "." + description.getMethodName() + "()";
        return message;
    }

    public TracingSuite(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        super(klass, builder);
        this.fTracingOptions = klass.getAnnotation(TracingOptions.class);
        if (this.fTracingOptions == null) {
            @TracingOptions
            class DefaultTracingOptionsProvider {
                DefaultTracingOptionsProvider() {
                }
            }
            this.fTracingOptions = DefaultTracingOptionsProvider.class.getAnnotation(TracingOptions.class);
        }
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        super.runChild(runner, (RunNotifier)new TracingRunNotifier(notifier));
    }

    private class DumpTask
    extends TimerTask {
        private volatile int fScreenshotCount;
        private Description fDescription;

        public DumpTask(Description description) {
            this.fDescription = description;
        }

        @Override
        public void run() {
            this.dumpStackTraces(System.out);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Thread main = this.dumpStackTraces(System.err);
            if (this.fScreenshotCount < TracingSuite.this.fTracingOptions.maxScreenshotCount()) {
                String screenshotFile = Screenshots.takeScreenshot(TracingSuite.class, Integer.toString(this.fScreenshotCount++));
                System.err.println("Timeout screenshot saved to " + screenshotFile);
            }
            if (main != null && TracingSuite.this.fTracingOptions.throwExceptionInMainThread()) {
                IllegalStateException toThrow = new IllegalStateException("main thread killed by " + TracingSuite.class.getSimpleName() + " timeout");
                toThrow.initCause(new RuntimeException(toThrow.getMessage()));
                toThrow.setStackTrace(main.getStackTrace());
                try {
                    Method stop0 = Thread.class.getDeclaredMethod("stop0", Object.class);
                    stop0.setAccessible(true);
                    stop0.invoke((Object)main, toThrow);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InaccessibleObjectException | InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            }
        }

        private Thread dumpStackTraces(PrintStream stream) {
            ThreadInfo[] allThreads;
            long seconds = TracingSuite.this.fTracingOptions.stackDumpTimeoutSeconds();
            String message = TracingSuite.format(new Date(), this.fDescription) + " ran for more than " + seconds + " seconds";
            stream.println(message);
            stream.format("totalMemory:           %11d\n", Runtime.getRuntime().totalMemory());
            stream.format("freeMemory (before GC):%11d\n", Runtime.getRuntime().freeMemory());
            System.gc();
            stream.format("freeMemory (after GC): %11d\n", Runtime.getRuntime().freeMemory());
            ThreadMXBean threadStuff = ManagementFactory.getThreadMXBean();
            ThreadInfo[] threadInfoArray = allThreads = threadStuff.dumpAllThreads(true, true, 200);
            int n = allThreads.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadInfo threadInfo = threadInfoArray[n2];
                stream.print(threadInfo);
                ++n2;
            }
            for (Thread t : Thread.getAllStackTraces().keySet()) {
                String name = t.getName();
                if (!"main".equals(name)) continue;
                return t;
            }
            return null;
        }
    }

    static class ThreadDump
    extends Exception {
        private static final long serialVersionUID = 1L;

        ThreadDump(String message) {
            super(message);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface TracingOptions {
        public boolean logTestStart() default true;

        public long stackDumpTimeoutSeconds() default 600L;

        public boolean throwExceptionInMainThread() default true;

        public int maxScreenshotCount() default 5;
    }

    private class TracingRunNotifier
    extends RunNotifier {
        private RunNotifier fNotifier;
        private Timer fTimer = new Timer(true);
        private ConcurrentHashMap<Description, TimerTask> fRunningTests = new ConcurrentHashMap();

        public TracingRunNotifier(RunNotifier notifier) {
            this.fNotifier = notifier;
        }

        public void addListener(RunListener listener) {
            this.fNotifier.addListener(listener);
        }

        public void removeListener(RunListener listener) {
            this.fNotifier.removeListener(listener);
        }

        public void fireTestRunStarted(Description description) {
            this.fNotifier.fireTestRunStarted(description);
        }

        public void fireTestRunFinished(Result result) {
            this.fNotifier.fireTestRunFinished(result);
        }

        public void fireTestStarted(Description description) throws StoppedByUserException {
            long seconds;
            Date start = new Date();
            if (TracingSuite.this.fTracingOptions.logTestStart()) {
                String message = TracingSuite.format(start, description);
                System.out.println(message);
            }
            if ((seconds = TracingSuite.this.fTracingOptions.stackDumpTimeoutSeconds()) != 0L) {
                DumpTask task = new DumpTask(description);
                this.fRunningTests.put(description, task);
                this.fTimer.schedule((TimerTask)task, seconds * 1000L);
            }
            this.fNotifier.fireTestStarted(description);
        }

        public void fireTestFailure(Failure failure) {
            if (TracingSuite.this.fTracingOptions.logTestStart() && failure.getException() != null) {
                Date start = new Date();
                String message = TracingSuite.format(start, failure.getDescription());
                System.out.println(message + " failed:");
                failure.getException().printStackTrace(System.out);
            }
            this.fNotifier.fireTestFailure(failure);
        }

        public void fireTestAssumptionFailed(Failure failure) {
            this.fNotifier.fireTestAssumptionFailed(failure);
        }

        public void fireTestIgnored(Description description) {
            this.fNotifier.fireTestIgnored(description);
        }

        public void fireTestFinished(Description description) {
            TimerTask task = this.fRunningTests.remove(description);
            if (task != null) {
                task.cancel();
            }
            this.fNotifier.fireTestFinished(description);
        }

        public void pleaseStop() {
            this.fNotifier.pleaseStop();
        }

        public void addFirstListener(RunListener listener) {
            this.fNotifier.addFirstListener(listener);
        }
    }
}

