/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.saveparticipant;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.saveparticipant.SaveManagerTest;
import org.eclipse.core.tests.resources.saveparticipant1.SaveParticipant1Plugin;
import org.eclipse.core.tests.resources.saveparticipant2.SaveParticipant2Plugin;
import org.eclipse.core.tests.resources.saveparticipant3.SaveParticipant3Plugin;
import org.junit.jupiter.api.Assertions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class SaveManager1Test {
    public void testCreateMyProject() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.create(null);
        project.open(null);
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertTrue((boolean)project.isOpen());
        project.close(null);
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertFalse((boolean)project.isOpen());
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        project.open(null);
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertTrue((boolean)project.isOpen());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, (String[])SaveManagerTest.defineHierarchy("MyProject"));
        ResourceTestUtil.createInWorkspace((IResource[])resources);
        ResourceTestUtil.assertExistsInFileSystem((IResource[])resources);
        ResourceTestUtil.assertExistsInWorkspace((IResource[])resources);
        project.close(null);
        project.open(null);
        ResourceTestUtil.assertExistsInFileSystem((IResource[])resources);
        ResourceTestUtil.assertExistsInWorkspace((IResource[])resources);
    }

    public void testCreateProject2() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        project.create(null);
        project.open(null);
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertTrue((boolean)project.isOpen());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, (String[])SaveManagerTest.defineHierarchy("Project2"));
        ResourceTestUtil.createInWorkspace((IResource[])resources);
        ResourceTestUtil.assertExistsInFileSystem((IResource[])resources);
        ResourceTestUtil.assertExistsInWorkspace((IResource[])resources);
        IProjectDescription description = project.getDescription();
        ICommand command = description.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.simplebuilder");
        description.setBuildSpec(new ICommand[]{command});
        project.setDescription(description, null);
        project.build(6, null);
        project.close(null);
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertFalse((boolean)project.isOpen());
    }

    public void testAddSaveParticipant() throws Exception {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.tests.resources.saveparticipant1");
        Assertions.assertNotNull((Object)bundle);
        bundle.start();
        SaveParticipant1Plugin plugin1 = SaveParticipant1Plugin.getInstance();
        plugin1.resetDeltaVerifier();
        IStatus status = plugin1.registerAsSaveParticipant();
        Assertions.assertTrue((boolean)status.isOK(), (String)("Registering save participant failed with message: " + status.getMessage()));
        plugin1.setExpectedSaveKind(1);
        bundle = Platform.getBundle((String)"org.eclipse.core.tests.resources.saveparticipant2");
        Assertions.assertNotNull((Object)bundle);
        bundle.start();
        SaveParticipant2Plugin plugin2 = SaveParticipant2Plugin.getInstance();
        plugin2.getDeltaVerifier().reset();
        status = plugin2.registerAsSaveParticipant();
        Assertions.assertTrue((boolean)status.isOK(), (String)("Registering save participant failed with message: " + status.getMessage()));
        plugin1.setExpectedSaveKind(1);
        bundle = Platform.getBundle((String)"org.eclipse.core.tests.resources.saveparticipant3");
        Assertions.assertNotNull((Object)bundle);
        bundle.start();
        SaveParticipant3Plugin plugin3 = SaveParticipant3Plugin.getInstance();
        status = plugin3.registerAsSaveParticipant();
        Assertions.assertTrue((boolean)status.isOK(), (String)("Registering save participant failed with message: " + status.getMessage()));
    }

    public void testBuilder() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        Assertions.assertTrue((boolean)project.isAccessible());
        ResourceTestUtil.setAutoBuilding((boolean)true);
        IProjectDescription description = project.getDescription();
        ICommand command = description.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.deltaverifierbuilder");
        description.setBuildSpec(new ICommand[]{command});
        project.setDescription(description, null);
        project.build(6, ResourceTestUtil.createTestMonitor());
        project.close(null);
        project.open(null);
        IFile added = project.getFile("added file");
        ResourceTestUtil.waitForBuild();
        DeltaVerifierBuilder verifier = DeltaVerifierBuilder.getInstance();
        verifier.reset();
        verifier.addExpectedChange((IResource)added, (IResource)project, 1, 0);
        added.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        ResourceTestUtil.waitForBuild();
        Assertions.assertTrue((boolean)verifier.wasAutoBuild());
        Assertions.assertTrue((boolean)verifier.isDeltaValid());
        added.delete(true, false, null);
    }

    public void testPostSave() throws BundleException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.tests.resources.saveparticipant1");
        Assertions.assertNotNull((Object)bundle);
        bundle.start();
        SaveParticipant1Plugin plugin = SaveParticipant1Plugin.getInstance();
        IStatus status = plugin.getSaveLifecycleLog();
        Assertions.assertTrue((boolean)status.isOK(), (String)("Getting lifecycle log failed with message: " + status.getMessage()));
    }
}

