/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.saveparticipant;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.regression.SimpleBuilder;
import org.eclipse.core.tests.resources.saveparticipant.SaveManagerTest;
import org.eclipse.core.tests.resources.saveparticipant1.SaveParticipant1Plugin;
import org.eclipse.core.tests.resources.saveparticipant3.SaveParticipant3Plugin;
import org.junit.jupiter.api.Assertions;
import org.osgi.framework.Bundle;

public class SaveManager2Test
extends SaveManagerTest {
    public void testBuilder() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        Assertions.assertTrue((boolean)project.isAccessible());
        IFile added = project.getFile("added file");
        ResourceTestUtil.waitForBuild();
        DeltaVerifierBuilder verifier = DeltaVerifierBuilder.getInstance();
        verifier.reset();
        verifier.addExpectedChange((IResource)added, (IResource)project, 1, 0);
        added.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        ResourceTestUtil.waitForBuild();
        Assertions.assertTrue((boolean)verifier.wasAutoBuild());
        Assertions.assertTrue((boolean)verifier.isDeltaValid());
        added.delete(true, false, null);
    }

    public void testSaveParticipant() throws Exception {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.tests.resources.saveparticipant1");
        Assertions.assertNotNull((Object)bundle);
        bundle.start();
        SaveParticipant1Plugin plugin1 = SaveParticipant1Plugin.getInstance();
        plugin1.resetDeltaVerifier();
        IFile added1 = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)"MyProject").append("addedFile"));
        plugin1.addExpectedChange((IResource)added1, 1, 0);
        IStatus status = plugin1.registerAsSaveParticipant();
        Assertions.assertTrue((boolean)status.isOK(), (String)("Registering save participant failed with message: " + status.getMessage()));
        bundle = Platform.getBundle((String)"org.eclipse.core.tests.resources.saveparticipant3");
        Assertions.assertNotNull((Object)bundle);
        bundle.start();
        SaveParticipant3Plugin plugin3 = SaveParticipant3Plugin.getInstance();
        status = plugin3.registerAsSaveParticipant();
        Assertions.assertTrue((boolean)status.isOK(), (String)("Registering save participant failed with message: " + status.getMessage()));
    }

    public void testVerifyProject2() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertFalse((boolean)project.isOpen());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, (String[])SaveManager2Test.defineHierarchy("Project2"));
        ResourceTestUtil.assertExistsInFileSystem((IResource[])resources);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource[])resources);
        project.open(null);
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertTrue((boolean)project.isOpen());
        ResourceTestUtil.assertExistsInFileSystem((IResource[])resources);
        ResourceTestUtil.assertExistsInWorkspace((IResource[])resources);
        this.touch(project);
        ResourceTestUtil.waitForBuild();
        SimpleBuilder builder = SimpleBuilder.getInstance();
        Assertions.assertTrue((boolean)builder.wasAutoBuild());
        IFile file = project.getFile("addedFile");
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
    }

    public void testVerifyRestoredWorkspace() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertTrue((boolean)project.isOpen());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, (String[])SaveManager2Test.defineHierarchy("MyProject"));
        ResourceTestUtil.assertExistsInFileSystem((IResource[])resources);
        ResourceTestUtil.assertExistsInWorkspace((IResource[])resources);
        IFile file = project.getFile("addedFile");
        file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
    }
}

