/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.saveparticipant;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.saveparticipant.SaveManagerTest;
import org.eclipse.core.tests.resources.saveparticipant1.SaveParticipant1Plugin;
import org.eclipse.core.tests.resources.saveparticipant2.SaveParticipant2Plugin;
import org.eclipse.core.tests.resources.saveparticipant3.SaveParticipant3Plugin;
import org.junit.jupiter.api.Assertions;
import org.osgi.framework.Bundle;

public class SaveManager3Test
extends SaveManagerTest {
    public void testBuilder() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        Assertions.assertTrue((boolean)project.isAccessible());
        this.setAutoBuilding(false);
        this.touch(project);
        project.build(10, null);
        this.setAutoBuilding(true);
        ResourceTestUtil.waitForBuild();
        DeltaVerifierBuilder verifier = DeltaVerifierBuilder.getInstance();
        Assertions.assertTrue((boolean)verifier.wasIncrementalBuild());
        IFile added = project.getFile("added file");
        verifier.addExpectedChange((IResource)added, (IResource)project, 1, 0);
        added.create(ResourceTestUtil.createRandomContentsStream(), true, null);
        ResourceTestUtil.waitForBuild();
        Assertions.assertTrue((boolean)verifier.wasAutoBuild());
        Assertions.assertTrue((boolean)verifier.isDeltaValid());
        added.delete(true, false, null);
    }

    public void testSaveParticipant() throws Exception {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.tests.resources.saveparticipant1");
        Assertions.assertNotNull((Object)bundle);
        bundle.start();
        SaveParticipant1Plugin plugin1 = SaveParticipant1Plugin.getInstance();
        plugin1.resetDeltaVerifier();
        IStatus status = plugin1.registerAsSaveParticipant();
        Assertions.assertTrue((boolean)status.isOK(), (String)("Registering save participant failed with message: " + status.getMessage()));
        bundle = Platform.getBundle((String)"org.eclipse.core.tests.resources.saveparticipant2");
        Assertions.assertNotNull((Object)bundle);
        bundle.start();
        SaveParticipant2Plugin plugin2 = SaveParticipant2Plugin.getInstance();
        plugin2.resetDeltaVerifier();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("addedFile");
        plugin2.addExpectedChange((IResource)file, 1, 0);
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        plugin2.addExpectedChange((IResource)project, 4, 16384);
        file = project.getFile("addedFile");
        plugin2.addExpectedChange((IResource)file, (IResource)project, 1, 0);
        IFile prjFile = project.getFile(".project");
        plugin2.addExpectedChange((IResource)prjFile, 1, 0);
        plugin2.addExpectedChange((IResource)project.getFolder(".settings"), 1, 0);
        plugin2.addExpectedChange((IResource)project.getFolder(".settings").getFile("org.eclipse.core.resources.prefs"), 1, 0);
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, (String[])SaveManager3Test.defineHierarchy("Project2"));
        plugin2.addExpectedChange(resources, 1, 0);
        status = plugin2.registerAsSaveParticipant();
        Assertions.assertTrue((boolean)status.isOK(), (String)("Status is not okay with message: " + status.getMessage()));
        bundle = Platform.getBundle((String)"org.eclipse.core.tests.resources.saveparticipant3");
        Assertions.assertNotNull((Object)bundle);
        bundle.start();
        SaveParticipant3Plugin plugin3 = SaveParticipant3Plugin.getInstance();
        status = plugin3.registerAsSaveParticipant();
        Assertions.assertTrue((boolean)status.isOK(), (String)("Registering save participant failed with message: " + status.getMessage()));
    }
}

