/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.saveparticipant;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.resources.saveparticipant.SaveManager1Test;
import org.eclipse.core.tests.resources.saveparticipant.SaveManager2Test;
import org.eclipse.core.tests.resources.saveparticipant.SaveManager3Test;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class SaveManagerTest {
    public static final String PI_RESOURCES_SAVEPARTICIPANT_TESTS = "org.eclipse.core.tests.resources.saveparticipant";
    @RegisterExtension
    static SessionTestExtension sessionTestExtension = SessionTestExtension.forPlugin((String)"org.eclipse.core.tests.resources.saveparticipant").withCustomization(SessionTestExtension.createCustomWorkspace()).create();
    static final String PROJECT_1 = "MyProject";
    static final String PROJECT_2 = "Project2";
    static final String PI_SAVE_PARTICIPANT_1 = "org.eclipse.core.tests.resources.saveparticipant1";
    static final String PI_SAVE_PARTICIPANT_2 = "org.eclipse.core.tests.resources.saveparticipant2";
    static final String PI_SAVE_PARTICIPANT_3 = "org.eclipse.core.tests.resources.saveparticipant3";

    static String[] defineHierarchy(String project) {
        if (project.equals(PROJECT_1)) {
            return SaveManagerTest.defineHierarchy1();
        }
        if (project.equals(PROJECT_2)) {
            return SaveManagerTest.defineHierarchy2();
        }
        return new String[0];
    }

    private static String[] defineHierarchy1() {
        return new String[]{"/folder110/", "/folder110/folder120/", "/folder110/folder120/folder130/", "/folder110/folder120/folder130/folder140/", "/folder110/folder120/folder130/folder140/folder150/", "/folder110/folder120/folder130/folder140/folder150/file160", "/folder110/folder120/folder130/folder140/file150", "/folder110/folder121/", "/folder110/folder121/folder131/", "/folder110/folder120/folder130/folder141/"};
    }

    private static String[] defineHierarchy2() {
        return new String[]{"/file110", "/folder110/", "/folder110/file120", "/folder111/", "/folder111/folder120/", "/folder111/file121"};
    }

    private void saveWorkspace() throws CoreException {
        ResourcesPlugin.getWorkspace().save(true, null);
    }

    protected void setAutoBuilding(boolean value) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.isAutoBuilding() == value) {
            return;
        }
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setAutoBuilding(value);
        workspace.setDescription(desc);
    }

    @Test
    @Order(value=1)
    public void test1() throws Exception {
        SaveManager1Test test = new SaveManager1Test();
        this.saveWorkspace();
        test.testCreateMyProject();
        test.testCreateProject2();
        test.testAddSaveParticipant();
        test.testBuilder();
        this.saveWorkspace();
        test.testPostSave();
    }

    @Test
    @Order(value=2)
    public void test2() throws Exception {
        SaveManager2Test test = new SaveManager2Test();
        test.testVerifyRestoredWorkspace();
        test.testBuilder();
        test.testSaveParticipant();
        test.testVerifyProject2();
        this.saveWorkspace();
    }

    @Test
    @Order(value=3)
    public void test3() throws Exception {
        SaveManager3Test test = new SaveManager3Test();
        test.testSaveParticipant();
        test.testBuilder();
    }

    protected void touch(IProject project) throws CoreException {
        project.accept(resource -> {
            if (resource.getType() == 1) {
                resource.touch(null);
                return false;
            }
            return true;
        });
    }
}

