/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.core.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.tests.SearchTestUtil;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LineConversionTest {
    private IFile fFile;
    private static final String LINE_TWO = "This is the second line\n";
    private static final String LINE_ONE = "This is the first line\n";
    private static final String LINE_THREE = "This is the third line";

    @Before
    public void setUp() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Test");
        project.create(null);
        project.open(null);
        this.fFile = project.getFile("/test.txt");
        this.fFile.create((InputStream)new ByteArrayInputStream(this.getFileContents().getBytes()), true, null);
    }

    @After
    public void tearDown() throws Exception {
        SearchPlugin.getActivePage().closeAllEditors(false);
        this.fFile.getProject().delete(true, true, null);
    }

    private String getFileContents() {
        return "This is the first line\nThis is the second line\nThis is the third line";
    }

    @Test
    public void testConvertToCharacter() throws Exception {
        SearchTestUtil.openTextEditor(SearchPlugin.getActivePage(), this.fFile);
        ITextFileBuffer fb = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
        IDocument doc = fb.getDocument();
        Position p1 = new Position(2, 1);
        Position p2 = PositionTracker.convertToCharacterPosition((Position)p1, (IDocument)doc);
        Assert.assertEquals((Object)p1, (Object)PositionTracker.convertToLinePosition((Position)p2, (IDocument)doc));
        p1 = new Position(0, 1);
        p2 = PositionTracker.convertToCharacterPosition((Position)p1, (IDocument)doc);
        Assert.assertEquals((Object)LINE_ONE, (Object)doc.get(p2.getOffset(), p2.getLength()));
        Assert.assertEquals((Object)p1, (Object)PositionTracker.convertToLinePosition((Position)p2, (IDocument)doc));
        p1 = new Position(1, 1);
        p2 = PositionTracker.convertToCharacterPosition((Position)p1, (IDocument)doc);
        Assert.assertEquals((Object)LINE_TWO, (Object)doc.get(p2.getOffset(), p2.getLength()));
        Assert.assertEquals((Object)p1, (Object)PositionTracker.convertToLinePosition((Position)p2, (IDocument)doc));
        p1 = new Position(0, 0);
        p2 = PositionTracker.convertToCharacterPosition((Position)p1, (IDocument)doc);
        Assert.assertEquals((Object)"", (Object)doc.get(p2.getOffset(), p2.getLength()));
        Assert.assertEquals((Object)p1, (Object)PositionTracker.convertToLinePosition((Position)p2, (IDocument)doc));
    }

    @Test
    public void testBogusLines() throws Exception {
        SearchTestUtil.openTextEditor(SearchPlugin.getActivePage(), this.fFile);
        ITextFileBuffer fb = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
        IDocument doc = fb.getDocument();
        Position p1 = new Position(2, 67);
        Assert.assertThrows(BadLocationException.class, () -> {
            Position position2 = PositionTracker.convertToCharacterPosition((Position)p1, (IDocument)doc);
        });
    }

    public void atestLineOffsets() throws Exception {
        SearchTestUtil.openTextEditor(SearchPlugin.getActivePage(), this.fFile);
        ITextFileBuffer fb = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
        IDocument doc = fb.getDocument();
        int offset = doc.getLineOffset(3);
        int line = doc.getLineOfOffset(offset);
        Assert.assertEquals((long)3L, (long)line);
    }
}

