/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.core.tests;

import org.eclipse.search.core.tests.NullQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.junit.Assert;
import org.junit.Test;

public class TestSearchResult {
    @Test
    public void testAddMatch() {
        NullQuery query = new NullQuery();
        AbstractTextSearchResult result = (AbstractTextSearchResult)query.getSearchResult();
        String object = "object";
        Match match1 = new Match((Object)object, 0, 0);
        result.addMatch(match1);
        Assert.assertEquals((long)1L, (long)result.getMatchCount());
        Match match2 = new Match((Object)object, 0, 0);
        result.addMatch(match2);
        Assert.assertEquals((long)2L, (long)result.getMatchCount());
        result.addMatch(match1);
        Assert.assertEquals((long)2L, (long)result.getMatchCount());
    }

    @Test
    public void testAddMatchDifferentStart() {
        NullQuery query = new NullQuery();
        AbstractTextSearchResult result = (AbstractTextSearchResult)query.getSearchResult();
        String object = "object";
        Match match1 = new Match((Object)object, 2, 0);
        result.addMatch(match1);
        Assert.assertEquals((long)1L, (long)result.getMatchCount());
        Match match2 = new Match((Object)object, 1, 1);
        result.addMatch(match2);
        Match match3 = new Match((Object)object, 0, 2);
        result.addMatch(match3);
        Match[] matches = result.getMatches((Object)object);
        Assert.assertSame((String)"matches[0]", (Object)matches[0], (Object)match3);
        Assert.assertSame((String)"matches[1]", (Object)matches[1], (Object)match2);
        Assert.assertSame((String)"matches[2]", (Object)matches[2], (Object)match1);
    }

    @Test
    public void testAddMatchDifferentStartInOrder() {
        NullQuery query = new NullQuery();
        AbstractTextSearchResult result = (AbstractTextSearchResult)query.getSearchResult();
        String object = "object";
        Match match1 = new Match((Object)object, 0, 0);
        result.addMatch(match1);
        Assert.assertEquals((long)1L, (long)result.getMatchCount());
        Match match2 = new Match((Object)object, 1, 1);
        result.addMatch(match2);
        Match match3 = new Match((Object)object, 2, 2);
        result.addMatch(match3);
        Match[] matches = result.getMatches((Object)object);
        Assert.assertSame((String)"matches[0]", (Object)matches[0], (Object)match1);
        Assert.assertSame((String)"matches[1]", (Object)matches[1], (Object)match2);
        Assert.assertSame((String)"matches[2]", (Object)matches[2], (Object)match3);
    }

    @Test
    public void testAddMatchDifferentLength() {
        NullQuery query = new NullQuery();
        AbstractTextSearchResult result = (AbstractTextSearchResult)query.getSearchResult();
        String object = "object";
        Match match1 = new Match((Object)object, 1, 1);
        result.addMatch(match1);
        Assert.assertEquals((long)1L, (long)result.getMatchCount());
        Match match2 = new Match((Object)object, 1, 0);
        result.addMatch(match2);
        Match[] matches = result.getMatches((Object)object);
        Assert.assertSame((String)"matches[0]", (Object)matches[0], (Object)match2);
        Assert.assertSame((String)"matches[1]", (Object)matches[1], (Object)match1);
    }

    @Test
    public void testAddMatches() {
        NullQuery query = new NullQuery();
        AbstractTextSearchResult result = (AbstractTextSearchResult)query.getSearchResult();
        String object = "object";
        Match match1 = new Match((Object)object, 0, 0);
        Match match2 = new Match((Object)object, 0, 0);
        result.addMatches(new Match[]{match1, match2});
        Assert.assertEquals((long)2L, (long)result.getMatchCount());
        result.addMatch(match1);
        Assert.assertEquals((long)2L, (long)result.getMatchCount());
    }

    @Test
    public void testRemoveMatch() {
        NullQuery query = new NullQuery();
        AbstractTextSearchResult result = (AbstractTextSearchResult)query.getSearchResult();
        String object = "object";
        Match match1 = new Match((Object)object, 0, 0);
        result.addMatch(match1);
        Match match2 = new Match((Object)object, 0, 0);
        result.addMatch(match2);
        Assert.assertEquals((long)2L, (long)result.getMatchCount());
        result.removeMatch(match1);
        Assert.assertEquals((long)1L, (long)result.getMatchCount());
        result.removeMatch(match1);
        Assert.assertEquals((long)1L, (long)result.getMatchCount());
    }

    @Test
    public void testRemoveMatches() {
        NullQuery query = new NullQuery();
        AbstractTextSearchResult result = (AbstractTextSearchResult)query.getSearchResult();
        String object = "object";
        Match match1 = new Match((Object)object, 0, 0);
        Match match2 = new Match((Object)object, 0, 0);
        result.addMatches(new Match[]{match1, match2});
        Assert.assertEquals((long)2L, (long)result.getMatchCount());
        result.removeMatches(new Match[]{match1, match2});
        Assert.assertEquals((long)0L, (long)result.getMatchCount());
    }

    @Test
    public void testMatchEvent() {
        boolean[] wasAdded = new boolean[1];
        boolean[] wasRemoved = new boolean[1];
        NullQuery query = new NullQuery();
        AbstractTextSearchResult result = (AbstractTextSearchResult)query.getSearchResult();
        result.addListener(e -> {
            if (e instanceof MatchEvent) {
                MatchEvent evt = (MatchEvent)e;
                if (evt.getKind() == 1) {
                    blArray[0] = true;
                } else {
                    blArray2[0] = true;
                }
            }
        });
        String object = "object";
        Match match1 = new Match((Object)object, 0, 0);
        result.addMatch(match1);
        Assert.assertTrue((boolean)wasAdded[0]);
        wasAdded[0] = false;
        result.addMatch(match1);
        Assert.assertFalse((boolean)wasAdded[0]);
        Match match2 = new Match((Object)object, 0, 0);
        result.addMatch(match2);
        Assert.assertTrue((boolean)wasAdded[0]);
        wasAdded[0] = false;
        result.removeMatch(match2);
        Assert.assertTrue((boolean)wasRemoved[0]);
        wasRemoved[0] = false;
        result.removeMatch(match2);
        Assert.assertFalse((boolean)wasRemoved[0]);
    }

    @Test
    public void testBatchedMatchEvent() {
        boolean[] wasAdded = new boolean[1];
        boolean[] wasRemoved = new boolean[1];
        NullQuery query = new NullQuery();
        AbstractTextSearchResult result = (AbstractTextSearchResult)query.getSearchResult();
        result.addListener(e -> {
            if (e instanceof MatchEvent) {
                MatchEvent evt = (MatchEvent)e;
                if (evt.getKind() == 1) {
                    blArray[0] = true;
                } else {
                    blArray2[0] = true;
                }
            }
        });
        String object = "object";
        Match match1 = new Match((Object)object, 0, 0);
        result.addMatches(new Match[]{match1});
        Assert.assertTrue((boolean)wasAdded[0]);
        wasAdded[0] = false;
        result.addMatches(new Match[]{match1});
        Assert.assertFalse((boolean)wasAdded[0]);
        Match match2 = new Match((Object)object, 0, 0);
        result.addMatches(new Match[]{match2});
        Assert.assertTrue((boolean)wasAdded[0]);
        wasAdded[0] = false;
        result.removeMatches(new Match[]{match2});
        Assert.assertTrue((boolean)wasRemoved[0]);
        wasRemoved[0] = false;
        result.removeMatches(new Match[]{match2});
        Assert.assertFalse((boolean)wasRemoved[0]);
    }
}

