/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class FileTool {
    private static final int MAX_RETRY = 5;
    private static byte[] buffer = new byte[8192];

    public static void unzip(ZipFile zipFile, File dstDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String entryName = entry.getName();
            if (!new File(dstDir, entryName).toPath().normalize().startsWith(dstDir.toPath().normalize())) {
                throw new RuntimeException("Bad zip entry: " + entryName);
            }
            File file = new File(dstDir, FileTool.changeSeparator(entryName, '/', File.separatorChar));
            file.getParentFile().mkdirs();
            Throwable throwable = null;
            Object var7_8 = null;
            try {
                InputStream src = zipFile.getInputStream(entry);
                try {
                    try (FileOutputStream dst = new FileOutputStream(file);){
                        FileTool.transferData(src, dst);
                    }
                    if (src == null) continue;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (src != null) {
                        src.close();
                    }
                    throw throwable;
                }
                src.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    public static String changeSeparator(String path, char oldSeparator, char newSeparator) {
        return path.replace(oldSeparator, newSeparator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transferData(File source, File destination) throws IOException {
        destination.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream is = new FileInputStream(source);
            try {
                try (FileOutputStream os = new FileOutputStream(destination);){
                    FileTool.transferData(is, os);
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void transferData(InputStream source, OutputStream destination) throws IOException {
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = source.read(buffer, 0, buffer.length);
            if (bytesRead == -1) continue;
            destination.write(buffer, 0, bytesRead);
        }
    }

    public static void copy(File src, File dst) throws IOException {
        if (src.isDirectory()) {
            String[] srcChildren = src.list();
            if (srcChildren == null) {
                throw new IOException("Content from directory '" + src.getAbsolutePath() + "' can not be listed.");
            }
            String[] stringArray = srcChildren;
            int n = srcChildren.length;
            int n2 = 0;
            while (n2 < n) {
                String srcChild2 = stringArray[n2];
                File srcChild = new File(src, srcChild2);
                File dstChild = new File(dst, srcChild2);
                FileTool.copy(srcChild, dstChild);
                ++n2;
            }
        } else {
            FileTool.transferData(src, dst);
        }
    }

    public static File getFileInPlugin(Plugin plugin, IPath path) {
        try {
            URL installURL = plugin.getBundle().getEntry(path.toString());
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static File getFileInBundle(Bundle bundle, IPath path) {
        try {
            URL installURL = bundle.getEntry(path.toString());
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static File createTempFileInPlugin(Plugin plugin, IPath path) {
        IPath stateLocation = plugin.getStateLocation();
        stateLocation = stateLocation.append(path);
        return stateLocation.toFile();
    }

    public static void delete(File file) {
        if (file.exists()) {
            int i = 0;
            while (i < 5) {
                if (file.delete()) {
                    i = 5;
                } else {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }
}

