/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.search.tests.FileTool;
import org.osgi.framework.FrameworkUtil;

public class ResourceHelper {
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private static final int MAX_RETRY = 10;

    public static IProject createProject(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            project.create(NULL_MONITOR);
        } else {
            project.refreshLocal(2, null);
        }
        if (!project.isOpen()) {
            project.open(NULL_MONITOR);
        }
        return project;
    }

    public static void deleteProject(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            ResourceHelper.delete((IResource)project);
        }
    }

    public static void delete(IResource resource) throws CoreException {
        IWorkspaceRunnable runnable = monitor -> {
            int i = 0;
            while (i < 10) {
                try {
                    resource.delete(true, null);
                    i = 10;
                }
                catch (CoreException e) {
                    if (i == 9) {
                        ILog.get().log(e.getStatus());
                        throw e;
                    }
                    System.gc();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    public static IFolder createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                ResourceHelper.createFolder((IFolder)parent);
            }
            folder.create(true, true, NULL_MONITOR);
        }
        return folder;
    }

    public static IFile createFile(IFolder folder, String name, String contents, String encoding) throws CoreException, IOException {
        IFile file = folder.getFile(name);
        if (contents == null) {
            contents = "";
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes(encoding));){
            file.create((InputStream)inputStream, true, NULL_MONITOR);
            file.setCharset(encoding, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return file;
    }

    public static IFile createFile(IFolder folder, String name, String contents) throws CoreException, IOException {
        return ResourceHelper.createFile(folder, name, contents, "ISO-8859-1");
    }

    public static IFile createLinkedFile(IContainer container, IPath linkPath, File linkedFileTarget) throws CoreException {
        IFile iFile = container.getFile(linkPath);
        iFile.createLink(IPath.fromOSString((String)linkedFileTarget.getAbsolutePath()), 16, NULL_MONITOR);
        return iFile;
    }

    public static IFile createLinkedFile(IContainer container, IPath linkPath, Plugin plugin, IPath linkedFileTargetPath) throws CoreException {
        File file = FileTool.getFileInPlugin(plugin, linkedFileTargetPath);
        IFile iFile = container.getFile(linkPath);
        iFile.createLink(IPath.fromOSString((String)file.getAbsolutePath()), 16, NULL_MONITOR);
        return iFile;
    }

    public static IFolder createLinkedFolder(IContainer container, IPath linkPath, File linkedFolderTarget) throws CoreException {
        IFolder folder = container.getFolder(linkPath);
        folder.createLink(IPath.fromOSString((String)linkedFolderTarget.getAbsolutePath()), 16, NULL_MONITOR);
        return folder;
    }

    public static IFolder createLinkedFolder(IContainer container, IPath linkPath, Plugin plugin, IPath linkedFolderTargetPath) throws CoreException {
        File file = FileTool.getFileInPlugin(plugin, linkedFolderTargetPath);
        IFolder iFolder = container.getFolder(linkPath);
        iFolder.createLink(IPath.fromOSString((String)file.getAbsolutePath()), 16, NULL_MONITOR);
        return iFolder;
    }

    public static IProject createLinkedProject(String projectName, Plugin plugin, IPath linkPath) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        IProjectDescription desc = workspace.newProjectDescription(projectName);
        File file = FileTool.getFileInPlugin(plugin, linkPath);
        IPath projectLocation = IPath.fromOSString((String)file.getAbsolutePath());
        if (Platform.getLocation().equals((Object)projectLocation)) {
            projectLocation = null;
        }
        desc.setLocation(projectLocation);
        project.create(desc, NULL_MONITOR);
        if (!project.isOpen()) {
            project.open(NULL_MONITOR);
        }
        return project;
    }

    public static IProject createJUnitSourceProject(String projectName) throws CoreException, ZipException, IOException {
        IProject project = ResourceHelper.createProject(projectName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zip = new ZipFile(FileTool.getFileInBundle(FrameworkUtil.getBundle(ResourceHelper.class), IPath.fromOSString((String)"testresources/junit37-noUI-src.zip")));){
            FileTool.unzip(zip, project.getLocation().toFile());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        project.refreshLocal(2, null);
        return project;
    }
}

