/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests.filesearch;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.tests.SearchTestUtil;
import org.eclipse.search.tests.filesearch.JUnitSourceSetup;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.search2.internal.ui.text.EditorAnnotationManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationTypeLookup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class AnnotationManagerTest {
    private FileSearchQuery fQuery1;
    private FileSearchQuery fQuery2;
    private final AnnotationTypeLookup fAnnotationTypeLookup = EditorsUI.getAnnotationTypeLookup();
    @ClassRule
    public static JUnitSourceSetup fgJUnitSource = new JUnitSourceSetup();

    @Before
    public void setUp() {
        SearchTestUtil.ensureWelcomePageClosed();
        EditorAnnotationManager.debugSetHighlighterType((int)2);
        String[] fileNamePattern = new String[]{"*.java"};
        FileTextSearchScope scope = FileTextSearchScope.newWorkspaceScope((String[])fileNamePattern, (boolean)false);
        this.fQuery1 = new FileSearchQuery("Test", false, true, scope);
        this.fQuery2 = new FileSearchQuery("Test", false, true, scope);
    }

    @After
    public void tearDown() {
        InternalSearchUI.getInstance().removeAllQueries();
        this.fQuery1 = null;
        this.fQuery2 = null;
        EditorAnnotationManager.debugSetHighlighterType((int)0);
    }

    @Test
    public void testAddAnnotation() throws Exception {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fQuery1.getSearchResult();
        Object[] files = result.getElements();
        try {
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object f = objectArray[n2];
                IFile file = (IFile)f;
                ITextEditor editor = (ITextEditor)SearchTestUtil.openTextEditor(SearchPlugin.getActivePage(), file);
                IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
                annotationModel.getAnnotationIterator();
                HashSet<Position> positions = new HashSet<Position>();
                Iterator iter = annotationModel.getAnnotationIterator();
                while (iter.hasNext()) {
                    Annotation annotation = (Annotation)iter.next();
                    if (!annotation.getType().equals(this.fAnnotationTypeLookup.getAnnotationType("org.eclipse.search.searchmarker", 0))) continue;
                    positions.add(annotationModel.getPosition(annotation));
                }
                Match[] matches = result.getMatches((Object)file);
                int j = 0;
                while (j < matches.length) {
                    Position position = new Position(matches[j].getOffset(), matches[j].getLength());
                    Assert.assertTrue((String)("position not found at: " + j), (boolean)positions.remove(position));
                    ++j;
                }
                Assert.assertEquals((long)0L, (long)positions.size());
                ++n2;
            }
        }
        finally {
            SearchPlugin.getActivePage().closeAllEditors(false);
        }
    }

    @Test
    public void testBogusAnnotation() throws Exception {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        FileSearchResult result = (FileSearchResult)this.fQuery1.getSearchResult();
        IFile file = (IFile)result.getElements()[0];
        SearchTestUtil.openTextEditor(PlatformUI.getWorkbench().getWorkbenchWindows()[0].getPages()[0], file);
        result.addMatch((Match)new FileMatch(file));
    }

    @Test
    public void testRemoveQuery() throws Exception {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fQuery1.getSearchResult();
        Object[] files = result.getElements();
        InternalSearchUI.getInstance().removeQuery((ISearchQuery)this.fQuery1);
        try {
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object f = objectArray[n2];
                IFile file = (IFile)f;
                ITextEditor editor = (ITextEditor)SearchTestUtil.openTextEditor(SearchPlugin.getActivePage(), file);
                IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
                int annotationCount = 0;
                Iterator annotations = annotationModel.getAnnotationIterator();
                while (annotations.hasNext()) {
                    Annotation annotation = (Annotation)annotations.next();
                    if (!annotation.getType().equals(this.fAnnotationTypeLookup.getAnnotationType("org.eclipse.search.searchmarker", 0))) continue;
                    ++annotationCount;
                }
                Assert.assertEquals((long)0L, (long)annotationCount);
                ++n2;
            }
        }
        finally {
            SearchPlugin.getActivePage().closeAllEditors(false);
        }
    }

    @Test
    public void testReplaceQuery() throws Exception {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fQuery1.getSearchResult();
        Object[] files = result.getElements();
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery2);
        try {
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object f = objectArray[n2];
                IFile file = (IFile)f;
                ITextEditor editor = (ITextEditor)SearchTestUtil.openTextEditor(SearchPlugin.getActivePage(), file);
                IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                Iterator annotations = annotationModel.getAnnotationIterator();
                while (annotations.hasNext()) {
                    Annotation annotation = (Annotation)annotations.next();
                    if (!annotation.getType().equals(this.fAnnotationTypeLookup.getAnnotationType("org.eclipse.search.searchmarker", 0))) continue;
                    Position p = annotationModel.getPosition(annotation);
                    String text = document.get(p.getOffset(), p.getLength());
                    Assert.assertTrue((boolean)text.equalsIgnoreCase(this.fQuery2.getSearchString()));
                }
                ++n2;
            }
        }
        finally {
            SearchPlugin.getActivePage().closeAllEditors(false);
        }
    }

    @Test
    public void testSwitchQuery() throws Exception {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fQuery1.getSearchResult();
        Object[] files = result.getElements();
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery2);
        SearchView activateSearchResultView = (SearchView)NewSearchUI.activateSearchResultView();
        activateSearchResultView.showSearchResult((ISearchResult)result);
        try {
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object f = objectArray[n2];
                IFile file = (IFile)f;
                ITextEditor editor = (ITextEditor)SearchTestUtil.openTextEditor(SearchPlugin.getActivePage(), file);
                IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                Iterator annotations = annotationModel.getAnnotationIterator();
                while (annotations.hasNext()) {
                    Annotation annotation = (Annotation)annotations.next();
                    if (!annotation.getType().equals(this.fAnnotationTypeLookup.getAnnotationType("org.eclipse.search.searchmarker", 0))) continue;
                    Position p = annotationModel.getPosition(annotation);
                    String text = document.get(p.getOffset(), p.getLength());
                    Assert.assertTrue((boolean)text.equalsIgnoreCase(this.fQuery1.getSearchString()));
                }
                ++n2;
            }
        }
        finally {
            SearchPlugin.getActivePage().closeAllEditors(false);
        }
    }
}

