/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests.filesearch;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.tests.SearchTestUtil;
import org.eclipse.search.tests.filesearch.JUnitSourceSetup;
import org.eclipse.search.tests.filesearch.LineBasedFileSearch;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.text.EditorAnnotationManager;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationTypeLookup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class LineAnnotationManagerTest {
    private LineBasedFileSearch fLineQuery;
    private final AnnotationTypeLookup fAnnotationTypeLookup = EditorsUI.getAnnotationTypeLookup();
    @ClassRule
    public static JUnitSourceSetup fgJUnitSource = new JUnitSourceSetup();

    @Before
    public void setUp() throws Exception {
        EditorAnnotationManager.debugSetHighlighterType((int)2);
        String[] fileNamePatterns = new String[]{"*.java"};
        FileTextSearchScope scope = FileTextSearchScope.newWorkspaceScope((String[])fileNamePatterns, (boolean)false);
        this.fLineQuery = new LineBasedFileSearch(scope, false, true, "Test");
    }

    @After
    public void tearDown() throws Exception {
        InternalSearchUI.getInstance().removeAllQueries();
        this.fLineQuery = null;
        EditorAnnotationManager.debugSetHighlighterType((int)0);
    }

    @Test
    public void testLineBasedQuery() throws Exception {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fLineQuery);
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fLineQuery.getSearchResult();
        Object[] files = result.getElements();
        try {
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object f = objectArray[n2];
                IFile file = (IFile)f;
                ITextEditor editor = (ITextEditor)SearchTestUtil.openTextEditor(SearchPlugin.getActivePage(), file);
                IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
                annotationModel.getAnnotationIterator();
                ArrayList<Position> positions = new ArrayList<Position>();
                Iterator iter = annotationModel.getAnnotationIterator();
                while (iter.hasNext()) {
                    Annotation annotation = (Annotation)iter.next();
                    if (!annotation.getType().equals(this.fAnnotationTypeLookup.getAnnotationType("org.eclipse.search.searchmarker", 0))) continue;
                    positions.add(annotationModel.getPosition(annotation));
                }
                Match[] matchArray = result.getMatches((Object)file);
                int n3 = matchArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Match match = matchArray[n4];
                    Position matchPosition = new Position(match.getOffset(), match.getLength());
                    MatcherAssert.assertThat((String)"no annotation found for match", positions, (Matcher)Matchers.hasItem((Object)matchPosition));
                    positions.remove(matchPosition);
                    ++n4;
                }
                MatcherAssert.assertThat((String)"annotations exist without matches", positions, (Matcher)Matchers.empty());
                ++n2;
            }
        }
        finally {
            SearchPlugin.getActivePage().closeAllEditors(false);
        }
    }
}

