/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests.filesearch;

import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;

public class LineBasedFileSearch
extends FileSearchQuery {
    private final FileTextSearchScope fScope;

    public LineBasedFileSearch(FileTextSearchScope scope, boolean isRegEx, boolean isCaseSensitive, String searchString) {
        super(searchString, isRegEx, isCaseSensitive, scope);
        this.fScope = scope;
    }

    public IStatus run(IProgressMonitor monitor) {
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        LineBasedTextSearchResultCollector collector = new LineBasedTextSearchResultCollector(textResult);
        Pattern searchPattern = this.getSearchPattern();
        return TextSearchEngine.create().search((TextSearchScope)this.fScope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    private static class LineBasedTextSearchResultCollector
    extends TextSearchRequestor {
        private final AbstractTextSearchResult fResult;
        private IFile fLastFile;
        private IDocument fLastDocument;
        private final Object fLock = new Object();

        private LineBasedTextSearchResultCollector(AbstractTextSearchResult result) {
            this.fResult = result;
            this.fLastFile = null;
            this.fLastDocument = null;
        }

        public boolean canRunInParallel() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
            IFile file = matchRequestor.getFile();
            try {
                IDocument doc = this.getDocument(file);
                if (doc == null) {
                    throw new IllegalArgumentException("No document for file: " + file.getName());
                }
                int startLine = doc.getLineOfOffset(matchRequestor.getMatchOffset());
                int endLine = doc.getLineOfOffset(matchRequestor.getMatchOffset() + matchRequestor.getMatchLength());
                Object object = this.fLock;
                synchronized (object) {
                    LineElement element = new LineElement((IResource)matchRequestor.getFile(), startLine, 0, "");
                    this.fResult.addMatch((Match)new FileMatch(file, startLine, endLine - startLine + 1, element));
                }
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, SearchPlugin.getID(), 4, "bad location", (Throwable)e));
            }
            return true;
        }

        private synchronized IDocument getDocument(IFile file) throws CoreException {
            if (file.equals((Object)this.fLastFile)) {
                return this.fLastDocument;
            }
            if (this.fLastFile != null) {
                FileBuffers.getTextFileBufferManager().disconnect(this.fLastFile.getFullPath(), LocationKind.IFILE, null);
            }
            this.fLastFile = file;
            FileBuffers.getTextFileBufferManager().connect(file.getFullPath(), LocationKind.IFILE, null);
            this.fLastDocument = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE).getDocument();
            return this.fLastDocument;
        }

        public void endReporting() {
            if (this.fLastFile != null) {
                try {
                    FileBuffers.getTextFileBufferManager().disconnect(this.fLastFile.getFullPath(), LocationKind.IFILE, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }
}

