/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests.filesearch;

import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.tests.SearchTestUtil;
import org.eclipse.search.tests.filesearch.JUnitSourceSetup;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

public class SearchResultPageTest {
    FileSearchQuery fQuery1;
    @ClassRule
    public static JUnitSourceSetup fgJUnitSource = new JUnitSourceSetup();

    @Before
    public void setUp() throws Exception {
        SearchTestUtil.ensureWelcomePageClosed();
        String[] fileNamePatterns = new String[]{"*.java"};
        FileTextSearchScope scope = FileTextSearchScope.newWorkspaceScope((String[])fileNamePatterns, (boolean)false);
        this.fQuery1 = new FileSearchQuery("Test", false, true, scope);
    }

    @Test
    @Ignore
    public void testBasicDisplay() throws Exception {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        ISearchResultViewPart view = NewSearchUI.getSearchResultView();
        FileSearchPage page = (FileSearchPage)view.getActivePage();
        page.setLayout(2);
        this.checkViewerDisplay(page);
        page.setLayout(1);
        this.checkViewerDisplay(page);
    }

    private void checkViewerDisplay(FileSearchPage page) {
        Object[] elements;
        StructuredViewer viewer = page.getViewer();
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fQuery1.getSearchResult();
        if (viewer instanceof AbstractTreeViewer) {
            ((AbstractTreeViewer)viewer).expandAll();
        }
        Object[] objectArray = elements = result.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.checkElementDisplay(viewer, result, element);
            ++n2;
        }
    }

    @Test
    @Ignore
    public void testRemoveTreeMatches() throws Exception {
        Object[] elements;
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        ISearchResultViewPart view = NewSearchUI.getSearchResultView();
        FileSearchPage page = (FileSearchPage)view.getActivePage();
        page.setLayout(2);
        AbstractTreeViewer viewer = (AbstractTreeViewer)page.getViewer();
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fQuery1.getSearchResult();
        viewer.expandAll();
        Object[] objectArray = elements = result.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            Match[] matches = result.getMatches(element);
            viewer.reveal(element);
            Match[] matchArray = matches;
            int n3 = matches.length;
            int n4 = 0;
            while (n4 < n3) {
                Match matche = matchArray[n4];
                this.checkElementDisplay((StructuredViewer)viewer, result, element);
                result.removeMatch(matche);
                this.consumeEvents(page);
                ++n4;
            }
            ++n2;
        }
    }

    private void consumeEvents(FileSearchPage page) {
        IJobManager manager = Job.getJobManager();
        while (manager.find((Object)page).length > 0) {
            Display.getDefault().readAndDispatch();
        }
    }

    private void consumeEvents() {
        while (Display.getDefault().readAndDispatch()) {
        }
    }

    private void checkElementDisplay(StructuredViewer viewer, AbstractTextSearchResult result, Object element) {
        Widget widget = viewer.testFindItem(element);
        Assert.assertTrue((boolean)(widget instanceof Item));
        Item item = (Item)widget;
        int itemCount = result.getMatchCount(element);
        Assert.assertTrue((itemCount > 0 ? 1 : 0) != 0);
        if (itemCount > 1) {
            Assert.assertTrue((boolean)item.getText().contains(String.valueOf(itemCount)));
        }
    }

    @Test
    public void testTableNavigation() {
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        ISearchResultViewPart view = NewSearchUI.getSearchResultView();
        FileSearchPage page = (FileSearchPage)view.getActivePage();
        page.setLayout(1);
        Table table = ((TableViewer)page.getViewer()).getTable();
        this.consumeEvents();
        table.setSelection(0);
        table.showSelection();
        this.consumeEvents();
        page.gotoPreviousMatch();
        this.consumeEvents();
        Assert.assertEquals((long)1L, (long)table.getSelectionCount());
        Assert.assertEquals((long)(table.getItemCount() - 1), (long)table.getSelectionIndex());
        page.gotoNextMatch();
        this.consumeEvents();
        Assert.assertEquals((long)1L, (long)table.getSelectionCount());
        Assert.assertEquals((long)0L, (long)table.getSelectionIndex());
    }
}

