/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.tests.filesearch;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.tests.filesearch.JUnitSourceSetup;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class SortingTest {
    FileSearchQuery fQuery1;
    @ClassRule
    public static JUnitSourceSetup fgJUnitSource = new JUnitSourceSetup();

    @Before
    public void setUp() throws Exception {
        String[] fileNamePatterns = new String[]{"*.java"};
        FileTextSearchScope scope = FileTextSearchScope.newWorkspaceScope((String[])fileNamePatterns, (boolean)false);
        this.fQuery1 = new FileSearchQuery("Test", false, true, scope);
    }

    @Test
    public void testSorted() throws Exception {
        Match[] matches;
        Object[] elements;
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInForeground(null, (ISearchQuery)this.fQuery1);
        AbstractTextSearchResult result = (AbstractTextSearchResult)this.fQuery1.getSearchResult();
        int originalMatchCount = result.getMatchCount();
        ArrayList allMatches = new ArrayList(originalMatchCount);
        Object[] objectArray = elements = result.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            matches = result.getMatches(element);
            Collections.addAll(allMatches, matches);
            ++n2;
        }
        result.removeAll();
        Assert.assertEquals((String)"removed all matches", (long)0L, (long)result.getMatchCount());
        int i = allMatches.size() - 1;
        while (i >= 0) {
            result.addMatch((Match)allMatches.get(i));
            --i;
        }
        Assert.assertEquals((String)"Test that all matches have been added again", (long)result.getMatchCount(), (long)originalMatchCount);
        objectArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            matches = result.getMatches(element);
            Assert.assertTrue((String)"has matches", (matches.length > 0 ? 1 : 0) != 0);
            int j = 1;
            while (j < matches.length) {
                Assert.assertTrue((String)"order problem", (boolean)this.isLessOrEqual(matches[j - 1], matches[j]));
                ++j;
            }
            ++n2;
        }
    }

    private boolean isLessOrEqual(Match match, Match match2) {
        int diff = match2.getOffset() - match.getOffset();
        if (diff > 0) {
            return true;
        }
        if (diff < 0) {
            return false;
        }
        diff = match2.getLength() - match.getLength();
        return diff >= 0;
    }
}

