/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.tests.verifier;

import java.util.Date;
import org.eclipse.equinox.internal.p2.tests.verifier.EclipseAdaptorMsg;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;

public class MessageHelper {
    public static String getResolutionFailureMessage(VersionConstraint unsatisfied) {
        if (unsatisfied.isResolved()) {
            throw new IllegalArgumentException();
        }
        if (unsatisfied instanceof ImportPackageSpecification) {
            if ("optional".equals(((ImportPackageSpecification)unsatisfied).getDirective("resolution"))) {
                return NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_MISSING_OPTIONAL_IMPORTED_PACKAGE, (Object)MessageHelper.toString(unsatisfied));
            }
            if ("dynamic".equals(((ImportPackageSpecification)unsatisfied).getDirective("resolution"))) {
                return NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_MISSING_DYNAMIC_IMPORTED_PACKAGE, (Object)MessageHelper.toString(unsatisfied));
            }
            return NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_MISSING_IMPORTED_PACKAGE, (Object)MessageHelper.toString(unsatisfied));
        }
        if (unsatisfied instanceof BundleSpecification) {
            if (((BundleSpecification)unsatisfied).isOptional()) {
                return NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_MISSING_OPTIONAL_REQUIRED_BUNDLE, (Object)MessageHelper.toString(unsatisfied));
            }
            return NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_MISSING_REQUIRED_BUNDLE, (Object)MessageHelper.toString(unsatisfied));
        }
        if (unsatisfied instanceof HostSpecification) {
            return NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_MISSING_HOST, (Object)MessageHelper.toString(unsatisfied));
        }
        if (unsatisfied instanceof NativeCodeSpecification) {
            return NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_MISSING_NATIVECODE, (Object)unsatisfied.toString());
        }
        if (unsatisfied instanceof GenericSpecification) {
            return NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_MISSING_REQUIRED_CAPABILITY, (Object)unsatisfied.toString());
        }
        return NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_MISSING_REQUIREMENT, (Object)unsatisfied.toString());
    }

    public static void debug(String message) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(new Date(System.currentTimeMillis()));
        buffer.append(" - [");
        buffer.append(Thread.currentThread().getName());
        buffer.append("] ");
        buffer.append(message);
        System.out.println(buffer.toString());
    }

    private static String toString(VersionConstraint constraint) {
        VersionRange versionRange = constraint.getVersionRange();
        if (versionRange == null) {
            return constraint.getName();
        }
        return constraint.getName() + "_" + String.valueOf(versionRange);
    }
}

