/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.tests;

import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.advanced.StructuredTextEnvironment;
import org.eclipse.equinox.bidi.advanced.StructuredTextExpertFactory;
import org.eclipse.equinox.bidi.internal.tests.StructuredTextTestBase;
import org.junit.Assert;
import org.junit.Test;

public class StructuredTextExtensionsTest
extends StructuredTextTestBase {
    private static final String PROPERTY = "property";
    private static final String SYSTEM_USER = "system";
    private StructuredTextEnvironment env = StructuredTextEnvironment.DEFAULT;
    private final StructuredTextEnvironment envArabic = new StructuredTextEnvironment("ar", false, 0);
    private final StructuredTextEnvironment envHebrew = new StructuredTextEnvironment("he", false, 0);
    private IStructuredTextExpert expert;

    private void doTest1(String label, String data, String result) {
        String full = this.expert.leanToFullText(StructuredTextExtensionsTest.toUT16(data));
        Assert.assertEquals((String)(label + " data = " + data), (Object)result, (Object)StructuredTextExtensionsTest.toPseudo(full));
    }

    private void doTest2(String label, String data, String result) {
        String full = this.expert.leanToFullText(data);
        Assert.assertEquals((String)(label + " data = " + data), (Object)result, (Object)StructuredTextExtensionsTest.toPseudo(full));
    }

    private void doTest3(String label, String data, String result) {
        String full = this.expert.leanToFullText(StructuredTextExtensionsTest.toUT16(data));
        Assert.assertEquals((String)(label + " data = " + data), (Object)result, (Object)StructuredTextExtensionsTest.toPseudo(full));
    }

    @Test
    public void testDefaultExtensions() {
        this.expert = StructuredTextExpertFactory.getExpert((String)"comma", (StructuredTextEnvironment)this.env);
        this.doTest1("Comma #1", "ab,cd, AB, CD, EFG", "ab,cd, AB@, CD@, EFG");
        this.expert = StructuredTextExpertFactory.getExpert((String)"email", (StructuredTextEnvironment)this.env);
        this.doTest1("Email #1", "abc.DEF:GHI", "abc.DEF@:GHI");
        this.doTest1("Email #2", "DEF.GHI \"A.B\":JK ", "DEF@.GHI @\"A.B\"@:JK ");
        this.doTest1("Email #3", "DEF,GHI (A,B);JK ", "DEF@,GHI @(A,B)@;JK ");
        this.doTest1("Email #4", "DEF.GHI (A.B :JK ", "DEF@.GHI @(A.B :JK ");
        this.env = this.envArabic;
        this.expert = StructuredTextExpertFactory.getExpert((String)"email", (StructuredTextEnvironment)this.env);
        this.doTest1("Email #5", "#EF.GHI \"A.B\":JK ", "<&#EF.GHI \"A.B\":JK &^");
        this.doTest1("Email #6", "#EF,GHI (A,B);JK ", "<&#EF,GHI (A,B);JK &^");
        this.doTest1("Email #7", "#EF.GHI (A.B :JK ", "<&#EF.GHI (A.B :JK &^");
        String data = StructuredTextExtensionsTest.toUT16("peter.pan") + "@" + StructuredTextExtensionsTest.toUT16("#EF.GHI");
        this.doTest2("Email #8", data, "<&peter&.pan@#EF.GHI&^");
        this.env = this.envHebrew;
        this.expert = StructuredTextExpertFactory.getExpert((String)"email", (StructuredTextEnvironment)this.env);
        data = StructuredTextExtensionsTest.toUT16("peter.pan") + "@" + StructuredTextExtensionsTest.toUT16("DEF.GHI");
        this.doTest2("Email #9", data, "peter.pan@DEF@.GHI");
        this.expert = StructuredTextExpertFactory.getExpert((String)"file", (StructuredTextEnvironment)this.env);
        this.doTest1("File #1", "c:\\A\\B\\FILE.EXT", "c:\\A@\\B@\\FILE@.EXT");
        this.expert = StructuredTextExpertFactory.getStatefulExpert((String)"java", (StructuredTextEnvironment)this.env);
        this.doTest1("Java #1", "A = B + C;", "A@ = B@ + C;");
        this.doTest1("Java #2", "A   = B + C;", "A@   = B@ + C;");
        this.doTest1("Java #3", "A = \"B+C\"+D;", "A@ = \"B+C\"@+D;");
        this.doTest1("Java #4", "A = \"B+C+D;", "A@ = \"B+C+D;");
        this.doTest1("Java #5", "A = \"B\\\"C\"+D;", "A@ = \"B\\\"C\"@+D;");
        this.doTest1("Java #6", "A = /*B+C*/ D;", "A@ = /*B+C@*/ D;");
        this.doTest1("Java #7", "A = /*B+C* D;", "A@ = /*B+C* D;");
        this.doTest1("Java #8", "X+Y+Z */ B;  ", "X+Y+Z @*/ B;  ");
        this.doTest1("Java #9", "A = //B+C* D;", "A@ = //B+C* D;");
        this.doTest1("Java #10", "A = //B+C`|D+E;", "A@ = //B+C`|D@+E;");
        this.expert = StructuredTextExpertFactory.getStatefulExpert((String)"regex", (StructuredTextEnvironment)this.env);
        data = StructuredTextExtensionsTest.toUT16("ABC(?") + "#" + StructuredTextExtensionsTest.toUT16("DEF)GHI");
        this.doTest2("Regex #0.0", data, "A@B@C@(?#DEF)@G@H@I");
        data = StructuredTextExtensionsTest.toUT16("ABC(?") + "#" + StructuredTextExtensionsTest.toUT16("DEF");
        this.doTest2("Regex #0.1", data, "A@B@C@(?#DEF");
        this.doTest1("Regex #0.2", "GHI)JKL", "GHI)@J@K@L");
        data = StructuredTextExtensionsTest.toUT16("ABC(?") + "<" + StructuredTextExtensionsTest.toUT16("DEF") + ">" + StructuredTextExtensionsTest.toUT16("GHI");
        this.doTest2("Regex #1", data, "A@B@C@(?<DEF>@G@H@I");
        this.doTest1("Regex #2.0", "ABC(?'DEF'GHI", "A@B@C@(?'DEF'@G@H@I");
        this.doTest1("Regex #2.1", "ABC(?'DEFGHI", "A@B@C@(?'DEFGHI");
        data = StructuredTextExtensionsTest.toUT16("ABC(?(") + "<" + StructuredTextExtensionsTest.toUT16("DEF") + ">" + StructuredTextExtensionsTest.toUT16(")GHI");
        this.doTest2("Regex #3", data, "A@B@C@(?(<DEF>)@G@H@I");
        this.doTest1("Regex #4", "ABC(?('DEF')GHI", "A@B@C@(?('DEF')@G@H@I");
        this.doTest1("Regex #5", "ABC(?(DEF)GHI", "A@B@C@(?(DEF)@G@H@I");
        data = StructuredTextExtensionsTest.toUT16("ABC(?") + "&" + StructuredTextExtensionsTest.toUT16("DEF)GHI");
        this.doTest2("Regex #6", data, "A@B@C@(?&DEF)@G@H@I");
        data = StructuredTextExtensionsTest.toUT16("ABC(?") + "P<" + StructuredTextExtensionsTest.toUT16("DEF") + ">" + StructuredTextExtensionsTest.toUT16("GHI");
        this.doTest2("Regex #7", data, "A@B@C(?p<DEF>@G@H@I");
        data = StructuredTextExtensionsTest.toUT16("ABC\\k") + "<" + StructuredTextExtensionsTest.toUT16("DEF") + ">" + StructuredTextExtensionsTest.toUT16("GHI");
        this.doTest2("Regex #8", data, "A@B@C\\k<DEF>@G@H@I");
        this.doTest1("Regex #9", "ABC\\k'DEF'GHI", "A@B@C\\k'DEF'@G@H@I");
        this.doTest1("Regex #10", "ABC\\k{DEF}GHI", "A@B@C\\k{DEF}@G@H@I");
        data = StructuredTextExtensionsTest.toUT16("ABC(?") + "P=" + StructuredTextExtensionsTest.toUT16("DEF)GHI");
        this.doTest2("Regex #11", data, "A@B@C(?p=DEF)@G@H@I");
        this.doTest1("Regex #12", "ABC\\g{DEF}GHI", "A@B@C\\g{DEF}@G@H@I");
        data = StructuredTextExtensionsTest.toUT16("ABC\\g") + "<" + StructuredTextExtensionsTest.toUT16("DEF") + ">" + StructuredTextExtensionsTest.toUT16("GHI");
        this.doTest2("Regex #13", data, "A@B@C\\g<DEF>@G@H@I");
        this.doTest1("Regex #14", "ABC\\g'DEF'GHI", "A@B@C\\g'DEF'@G@H@I");
        data = StructuredTextExtensionsTest.toUT16("ABC(?(") + "R&" + StructuredTextExtensionsTest.toUT16("DEF)GHI");
        this.doTest2("Regex #15", data, "A@B@C(?(r&DEF)@G@H@I");
        data = StructuredTextExtensionsTest.toUT16("ABC") + "\\Q" + StructuredTextExtensionsTest.toUT16("DEF") + "\\E" + StructuredTextExtensionsTest.toUT16("GHI");
        this.doTest2("Regex #16.0", data, "A@B@C\\qDEF\\eG@H@I");
        data = StructuredTextExtensionsTest.toUT16("ABC") + "\\Q" + StructuredTextExtensionsTest.toUT16("DEF");
        this.doTest2("Regex #16.1", data, "A@B@C\\qDEF");
        data = StructuredTextExtensionsTest.toUT16("GHI") + "\\E" + StructuredTextExtensionsTest.toUT16("JKL");
        this.doTest2("Regex #16.2", data, "GHI\\eJ@K@L");
        this.doTest1("Regex #17.0", "abc[d-h]ijk", "abc[d-h]ijk");
        this.doTest1("Regex #17.1", "aBc[d-H]iJk", "aBc[d-H]iJk");
        this.doTest1("Regex #17.2", "aB*[!-H]iJ2", "aB*[!-@H]iJ@2");
        this.doTest1("Regex #17.3", "aB*[1-2]J3", "aB*[@1-2]J@3");
        this.doTest1("Regex #17.4", "aB*[5-6]J3", "aB*[@5-@6]@J@3");
        this.doTest1("Regex #17.5", "a*[5-6]J3", "a*[5-@6]@J@3");
        this.doTest1("Regex #17.6", "aB*123", "aB*@123");
        this.doTest1("Regex #17.7", "aB*567", "aB*@567");
        this.env = this.envArabic;
        this.expert = StructuredTextExpertFactory.getExpert((String)"regex", (StructuredTextEnvironment)this.env);
        data = StructuredTextExtensionsTest.toUT16("#BC(?") + "#" + StructuredTextExtensionsTest.toUT16("DEF)GHI");
        this.doTest2("Regex #0.0", data, "<&#BC(?#DEF)GHI&^");
        data = StructuredTextExtensionsTest.toUT16("#BC(?") + "#" + StructuredTextExtensionsTest.toUT16("DEF");
        this.doTest2("Regex #0.1", data, "<&#BC(?#DEF&^");
        this.doTest1("Regex #0.2", "#HI)JKL", "<&#HI)JKL&^");
        data = StructuredTextExtensionsTest.toUT16("#BC(?") + "<" + StructuredTextExtensionsTest.toUT16("DEF") + ">" + StructuredTextExtensionsTest.toUT16("GHI");
        this.doTest2("Regex #1", data, "<&#BC(?<DEF>GHI&^");
        this.doTest1("Regex #2.0", "#BC(?'DEF'GHI", "<&#BC(?'DEF'GHI&^");
        this.doTest1("Regex #2.1", "#BC(?'DEFGHI", "<&#BC(?'DEFGHI&^");
        data = StructuredTextExtensionsTest.toUT16("#BC(?(") + "<" + StructuredTextExtensionsTest.toUT16("DEF") + ">" + StructuredTextExtensionsTest.toUT16(")GHI");
        this.doTest2("Regex #3", data, "<&#BC(?(<DEF>)GHI&^");
        this.doTest1("Regex #4", "#BC(?('DEF')GHI", "<&#BC(?('DEF')GHI&^");
        this.doTest1("Regex #5", "#BC(?(DEF)GHI", "<&#BC(?(DEF)GHI&^");
        data = StructuredTextExtensionsTest.toUT16("#BC(?") + "&" + StructuredTextExtensionsTest.toUT16("DEF)GHI");
        this.doTest2("Regex #6", data, "<&#BC(?&DEF)GHI&^");
        data = StructuredTextExtensionsTest.toUT16("#BC(?") + "P<" + StructuredTextExtensionsTest.toUT16("DEF") + ">" + StructuredTextExtensionsTest.toUT16("GHI");
        this.doTest2("Regex #7", data, "<&#BC(?p<DEF>GHI&^");
        data = StructuredTextExtensionsTest.toUT16("#BC\\k") + "<" + StructuredTextExtensionsTest.toUT16("DEF") + ">" + StructuredTextExtensionsTest.toUT16("GHI");
        this.doTest2("Regex #8", data, "<&#BC\\k<DEF>GHI&^");
        this.doTest1("Regex #9", "#BC\\k'DEF'GHI", "<&#BC\\k'DEF'GHI&^");
        this.doTest1("Regex #10", "#BC\\k{DEF}GHI", "<&#BC\\k{DEF}GHI&^");
        data = StructuredTextExtensionsTest.toUT16("#BC(?") + "P=" + StructuredTextExtensionsTest.toUT16("DEF)GHI");
        this.doTest2("Regex #11", data, "<&#BC(?p=DEF)GHI&^");
        this.doTest1("Regex #12", "#BC\\g{DEF}GHI", "<&#BC\\g{DEF}GHI&^");
        data = StructuredTextExtensionsTest.toUT16("#BC\\g") + "<" + StructuredTextExtensionsTest.toUT16("DEF") + ">" + StructuredTextExtensionsTest.toUT16("GHI");
        this.doTest2("Regex #13", data, "<&#BC\\g<DEF>GHI&^");
        this.doTest1("Regex #14", "#BC\\g'DEF'GHI", "<&#BC\\g'DEF'GHI&^");
        data = StructuredTextExtensionsTest.toUT16("#BC(?(") + "R&" + StructuredTextExtensionsTest.toUT16("DEF)GHI");
        this.doTest2("Regex #15", data, "<&#BC(?(r&DEF)GHI&^");
        data = StructuredTextExtensionsTest.toUT16("#BC") + "\\Q" + StructuredTextExtensionsTest.toUT16("DEF") + "\\E" + StructuredTextExtensionsTest.toUT16("GHI");
        this.doTest2("Regex #16.0", data, "<&#BC\\qDEF\\eGHI&^");
        data = StructuredTextExtensionsTest.toUT16("#BC") + "\\Q" + StructuredTextExtensionsTest.toUT16("DEF");
        this.doTest2("Regex #16.1", data, "<&#BC\\qDEF&^");
        data = StructuredTextExtensionsTest.toUT16("#HI") + "\\E" + StructuredTextExtensionsTest.toUT16("JKL");
        this.doTest2("Regex #16.2", data, "<&#HI\\eJKL&^");
        this.env = this.envHebrew;
        this.expert = StructuredTextExpertFactory.getStatefulExpert((String)"sql", (StructuredTextEnvironment)this.env);
        this.doTest1("SQL #0", "abc GHI", "abc GHI");
        this.doTest1("SQL #1", "abc DEF   GHI", "abc DEF@   GHI");
        this.doTest1("SQL #2", "ABC, DEF,   GHI", "ABC@, DEF@,   GHI");
        this.doTest1("SQL #3", "ABC'DEF GHI' JKL,MN", "ABC@'DEF GHI'@ JKL@,MN");
        this.doTest1("SQL #4.0", "ABC'DEF GHI JKL", "ABC@'DEF GHI JKL");
        this.doTest1("SQL #4.1", "MNO PQ' RS,TUV", "MNO PQ'@ RS@,TUV");
        this.doTest1("SQL #5", "ABC\"DEF GHI\" JKL,MN", "ABC@\"DEF GHI\"@ JKL@,MN");
        this.doTest1("SQL #6", "ABC\"DEF GHI JKL", "ABC@\"DEF GHI JKL");
        this.doTest1("SQL #7", "ABC/*DEF GHI*/ JKL,MN", "ABC@/*DEF GHI@*/ JKL@,MN");
        this.doTest1("SQL #8.0", "ABC/*DEF GHI JKL", "ABC@/*DEF GHI JKL");
        this.doTest1("SQL #8.1", "MNO PQ*/RS,TUV", "MNO PQ@*/RS@,TUV");
        this.doTest1("SQL #9", "ABC--DEF GHI JKL", "ABC@--DEF GHI JKL");
        this.doTest1("SQL #10", "ABC--DEF--GHI,JKL", "ABC@--DEF--GHI,JKL");
        this.doTest1("SQL #11", "ABC'DEF '' G I' JKL,MN", "ABC@'DEF '' G I'@ JKL@,MN");
        this.doTest1("SQL #12", "ABC\"DEF \"\" G I\" JKL,MN", "ABC@\"DEF \"\" G I\"@ JKL@,MN");
        this.doTest1("SQL #13", "ABC--DEF GHI`|JKL MN", "ABC@--DEF GHI`|JKL@ MN");
        this.expert = StructuredTextExpertFactory.getExpert((String)"underscore", (StructuredTextEnvironment)this.env);
        this.doTest1("Underscore #1", "A_B_C_d_e_F_G", "A@_B@_C_d_e_F@_G");
        this.expert = StructuredTextExpertFactory.getExpert((String)"url", (StructuredTextEnvironment)this.env);
        this.doTest1("URL #1", "WWW.DOMAIN.COM/DIR1/DIR2/dir3/DIR4", "WWW@.DOMAIN@.COM@/DIR1@/DIR2/dir3/DIR4");
        this.expert = StructuredTextExpertFactory.getExpert((String)"xpath", (StructuredTextEnvironment)this.env);
        this.doTest1("Xpath #1", "abc(DEF)GHI", "abc(DEF@)GHI");
        this.doTest1("Xpath #2", "DEF.GHI \"A.B\":JK ", "DEF@.GHI@ \"A.B\"@:JK ");
        this.doTest1("Xpath #3", "DEF!GHI 'A!B'=JK ", "DEF@!GHI@ 'A!B'@=JK ");
        this.doTest1("Xpath #4", "DEF.GHI 'A.B :JK ", "DEF@.GHI@ 'A.B :JK ");
        this.expert = StructuredTextExpertFactory.getExpert((String)"email", (StructuredTextEnvironment)this.env);
        this.doTest3("DelimsEsc #1", "abc.DEF.GHI", "abc.DEF@.GHI");
        this.doTest3("DelimsEsc #2", "DEF.GHI (A:B);JK ", "DEF@.GHI @(A:B)@;JK ");
        this.doTest3("DelimsEsc #3", "DEF.GHI (A:B);JK ", "DEF@.GHI @(A:B)@;JK ");
        this.doTest3("DelimsEsc #4", "DEF.GHI (A:B\\):C) ;JK ", "DEF@.GHI @(A:B\\):C) @;JK ");
        this.doTest3("DelimsEsc #5", "DEF.GHI (A\\\\\\):C) ;JK ", "DEF@.GHI @(A\\\\\\):C) @;JK ");
        this.doTest3("DelimsEsc #6", "DEF.GHI (A\\\\):C ;JK ", "DEF@.GHI @(A\\\\)@:C @;JK ");
        this.doTest3("DelimsEsc #7", "DEF.GHI (A\\):C ;JK ", "DEF@.GHI @(A\\):C ;JK ");
    }

    @Test
    public void testTestExtensions() {
        this.expert = StructuredTextExpertFactory.getExpert((String)PROPERTY, (StructuredTextEnvironment)this.env);
        this.doTest1("Property #0", "NAME,VAL1,VAL2", "NAME,VAL1,VAL2");
        this.doTest1("Property #1", "NAME=VAL1,VAL2", "NAME@=VAL1,VAL2");
        this.doTest1("Property #2", "NAME=VAL1,VAL2=VAL3", "NAME@=VAL1,VAL2=VAL3");
        this.expert = StructuredTextExpertFactory.getExpert((String)SYSTEM_USER, (StructuredTextEnvironment)this.env);
        this.doTest1("System #1", "HOST(JACK)", "HOST@(JACK)");
    }
}

