/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.tests;

import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.advanced.StructuredTextEnvironment;
import org.eclipse.equinox.bidi.advanced.StructuredTextExpertFactory;
import org.eclipse.equinox.bidi.internal.tests.StructuredTextTestBase;
import org.junit.Assert;
import org.junit.Test;

public class StructuredTextFullToLeanTest
extends StructuredTextTestBase {
    private static final StructuredTextEnvironment envLTR = new StructuredTextEnvironment(null, false, 0);
    private static final StructuredTextEnvironment envRTL = new StructuredTextEnvironment(null, false, 1);
    private String type;

    private void doTest1(String msg, String data, String leanLTR, String fullLTR, int[] l2fMapLTR, int[] f2lMapLTR, String leanRTL, String fullRTL, int[] l2fMapRTL, int[] f2lMapRTL) {
        String text = StructuredTextFullToLeanTest.toUT16(data);
        IStructuredTextExpert expertLTR = StructuredTextExpertFactory.getExpert((String)this.type, (StructuredTextEnvironment)envLTR);
        String lean = expertLTR.fullToLeanText(text);
        Assert.assertEquals((String)(msg + "LTR lean"), (Object)leanLTR, (Object)StructuredTextFullToLeanTest.toPseudo(lean));
        String full = expertLTR.leanToFullText(lean);
        Assert.assertEquals((String)(msg + "LTR full"), (Object)fullLTR, (Object)StructuredTextFullToLeanTest.toPseudo(full));
        int[] map = expertLTR.leanToFullMap(lean);
        String label = msg + "leanToFullMap() LTR";
        Assert.assertEquals((String)label, (Object)StructuredTextFullToLeanTest.array_display(l2fMapLTR), (Object)StructuredTextFullToLeanTest.array_display(map));
        map = expertLTR.fullToLeanMap(text);
        label = msg + "fullToLeanMap() LTR";
        Assert.assertEquals((String)label, (Object)StructuredTextFullToLeanTest.array_display(f2lMapLTR), (Object)StructuredTextFullToLeanTest.array_display(map));
        IStructuredTextExpert expertRTL = StructuredTextExpertFactory.getExpert((String)this.type, (StructuredTextEnvironment)envRTL);
        lean = expertRTL.fullToLeanText(text);
        Assert.assertEquals((String)(msg + "RTL lean"), (Object)leanRTL, (Object)StructuredTextFullToLeanTest.toPseudo(lean));
        full = expertRTL.leanToFullText(lean);
        Assert.assertEquals((String)(msg + "RTL full"), (Object)fullRTL, (Object)StructuredTextFullToLeanTest.toPseudo(full));
        map = expertRTL.leanToFullMap(lean);
        label = msg + "leanToFullMap() RTL";
        Assert.assertEquals((String)label, (Object)StructuredTextFullToLeanTest.array_display(l2fMapRTL), (Object)StructuredTextFullToLeanTest.array_display(map));
        map = expertRTL.fullToLeanMap(text);
        label = msg + "fullToLeanMap() RTL";
        Assert.assertEquals((String)label, (Object)StructuredTextFullToLeanTest.array_display(f2lMapRTL), (Object)StructuredTextFullToLeanTest.array_display(map));
    }

    private void doTest2(String msg) {
        String data = "update \"AB_CDE\" set \"COL1\"@='01', \"COL2\"@='02' /* GH IJK";
        String text = StructuredTextFullToLeanTest.toUT16(data);
        IStructuredTextExpert expertLTR = StructuredTextExpertFactory.getStatefulExpert((String)this.type, (StructuredTextEnvironment)envLTR);
        expertLTR.clearState();
        String lean = expertLTR.fullToLeanText(text);
        Object state1 = expertLTR.getState();
        String model = "update \"AB_CDE\" set \"COL1\"='01', \"COL2\"='02' /* GH IJK";
        Assert.assertEquals((String)(msg + "LTR lean"), (Object)model, (Object)StructuredTextFullToLeanTest.toPseudo(lean));
        IStructuredTextExpert expertLTR2 = StructuredTextExpertFactory.getStatefulExpert((String)this.type, (StructuredTextEnvironment)envLTR);
        expertLTR2.clearState();
        String full = expertLTR2.leanToFullText(lean);
        Assert.assertEquals((String)(msg + "LTR full"), (Object)data, (Object)StructuredTextFullToLeanTest.toPseudo(full));
        Assert.assertEquals((String)(msg + "state from leanToFullText"), (Object)state1, (Object)expertLTR2.getState());
        data = "THIS IS A COMMENT LINE";
        text = StructuredTextFullToLeanTest.toUT16(data);
        expertLTR.setState(state1);
        lean = expertLTR.fullToLeanText(text);
        Object state2 = expertLTR.getState();
        model = "THIS IS A COMMENT LINE";
        Assert.assertEquals((String)(msg + "LTR lean2"), (Object)model, (Object)StructuredTextFullToLeanTest.toPseudo(lean));
        expertLTR2.setState(state1);
        full = expertLTR2.leanToFullText(lean);
        Assert.assertEquals((String)(msg + "LTR full2"), (Object)data, (Object)StructuredTextFullToLeanTest.toPseudo(full));
        Assert.assertEquals((String)(msg + "state from leanToFullText2"), (Object)state2, (Object)expertLTR2.getState());
        data = "SOME MORE */ where \"COL3\"@=123";
        text = StructuredTextFullToLeanTest.toUT16(data);
        expertLTR.setState(state2);
        lean = expertLTR.fullToLeanText(text);
        Object state3 = expertLTR.getState();
        model = "SOME MORE */ where \"COL3\"=123";
        Assert.assertEquals((String)(msg + "LTR lean3"), (Object)model, (Object)StructuredTextFullToLeanTest.toPseudo(lean));
        expertLTR.setState(state2);
        full = expertLTR.leanToFullText(lean);
        Assert.assertEquals((String)(msg + "LTR full3"), (Object)data, (Object)StructuredTextFullToLeanTest.toPseudo(full));
        Assert.assertEquals((String)(msg + "state from leanToFullText3"), (Object)state3, (Object)expertLTR.getState());
    }

    @Test
    public void testFullToLean() {
        this.type = "comma";
        this.doTest1("testFullToLean #1 - ", "", "", "", new int[0], new int[0], "", "", new int[0], new int[0]);
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        int[] map1 = nArray;
        int[] map2 = new int[]{2, 3, 4, 5, 6};
        this.doTest1("testFullToLean #01 - ", "1.abc", "1.abc", "1.abc", map1, map1, "1.abc", ">@1.abc@^", map2, map1);
        int[] nArray2 = new int[9];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArray2[6] = 6;
        nArray2[7] = 7;
        nArray2[8] = 8;
        map1 = nArray2;
        map2 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
        this.doTest1("testFullToLean #02 - ", "2.abc,def", "2.abc,def", "2.abc,def", map1, map1, "2.abc,def", ">@2.abc,def@^", map2, map1);
        int[] nArray3 = new int[10];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        nArray3[4] = 4;
        nArray3[5] = 5;
        nArray3[6] = 6;
        nArray3[7] = 7;
        nArray3[8] = 8;
        nArray3[9] = 9;
        map1 = nArray3;
        int[] nArray4 = new int[11];
        nArray4[0] = -1;
        nArray4[2] = 1;
        nArray4[3] = 2;
        nArray4[4] = 3;
        nArray4[5] = 4;
        nArray4[6] = 5;
        nArray4[7] = 6;
        nArray4[8] = 7;
        nArray4[9] = 8;
        nArray4[10] = 9;
        map2 = nArray4;
        int[] map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        this.doTest1("testFullToLean #03 - ", "@a.3.bc,def", "a.3.bc,def", "a.3.bc,def", map1, map2, "a.3.bc,def", ">@a.3.bc,def@^", map3, map2);
        int[] nArray5 = new int[10];
        nArray5[1] = 1;
        nArray5[2] = 2;
        nArray5[3] = 3;
        nArray5[4] = 4;
        nArray5[5] = 5;
        nArray5[6] = 6;
        nArray5[7] = 7;
        nArray5[8] = 8;
        nArray5[9] = 9;
        map1 = nArray5;
        int[] nArray6 = new int[12];
        nArray6[0] = -1;
        nArray6[1] = -1;
        nArray6[3] = 1;
        nArray6[4] = 2;
        nArray6[5] = 3;
        nArray6[6] = 4;
        nArray6[7] = 5;
        nArray6[8] = 6;
        nArray6[9] = 7;
        nArray6[10] = 8;
        nArray6[11] = 9;
        map2 = nArray6;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        this.doTest1("testFullToLean #04 - ", "@@a.4.bc,def", "a.4.bc,def", "a.4.bc,def", map1, map2, "a.4.bc,def", ">@a.4.bc,def@^", map3, map2);
        int[] nArray7 = new int[9];
        nArray7[1] = 1;
        nArray7[2] = 2;
        nArray7[3] = 3;
        nArray7[4] = 4;
        nArray7[5] = 5;
        nArray7[6] = 6;
        nArray7[7] = 7;
        nArray7[8] = 8;
        map1 = nArray7;
        int[] nArray8 = new int[10];
        nArray8[0] = -1;
        nArray8[2] = 1;
        nArray8[3] = 2;
        nArray8[4] = 3;
        nArray8[5] = 4;
        nArray8[6] = 5;
        nArray8[7] = 6;
        nArray8[8] = 7;
        nArray8[9] = 8;
        map2 = nArray8;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
        this.doTest1("testFullToLean #05 - ", "@5.abc,def", "5.abc,def", "5.abc,def", map1, map2, "5.abc,def", ">@5.abc,def@^", map3, map2);
        int[] nArray9 = new int[9];
        nArray9[1] = 1;
        nArray9[2] = 2;
        nArray9[3] = 3;
        nArray9[4] = 4;
        nArray9[5] = 5;
        nArray9[6] = 6;
        nArray9[7] = 7;
        nArray9[8] = 8;
        map1 = nArray9;
        int[] nArray10 = new int[11];
        nArray10[0] = -1;
        nArray10[1] = -1;
        nArray10[3] = 1;
        nArray10[4] = 2;
        nArray10[5] = 3;
        nArray10[6] = 4;
        nArray10[7] = 5;
        nArray10[8] = 6;
        nArray10[9] = 7;
        nArray10[10] = 8;
        map2 = nArray10;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
        this.doTest1("testFullToLean #06 - ", "@@6.abc,def", "6.abc,def", "6.abc,def", map1, map2, "6.abc,def", ">@6.abc,def@^", map3, map2);
        int[] nArray11 = new int[9];
        nArray11[1] = 1;
        nArray11[2] = 2;
        nArray11[3] = 3;
        nArray11[4] = 4;
        nArray11[5] = 5;
        nArray11[6] = 6;
        nArray11[7] = 7;
        nArray11[8] = 8;
        map1 = nArray11;
        map2 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
        this.doTest1("testFullToLean #07 - ", "7abc,@def", "7abc,@def", "7abc,@def", map1, map1, "7abc,@def", ">@7abc,@def@^", map2, map1);
        int[] nArray12 = new int[9];
        nArray12[1] = 1;
        nArray12[2] = 2;
        nArray12[3] = 3;
        nArray12[4] = 4;
        nArray12[5] = 5;
        nArray12[6] = 6;
        nArray12[7] = 7;
        nArray12[8] = 8;
        map1 = nArray12;
        int[] nArray13 = new int[10];
        nArray13[1] = 1;
        nArray13[2] = 2;
        nArray13[3] = 3;
        nArray13[4] = 4;
        nArray13[5] = 5;
        nArray13[6] = -1;
        nArray13[7] = 6;
        nArray13[8] = 7;
        nArray13[9] = 8;
        map2 = nArray13;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
        this.doTest1("testFullToLean #08 - ", "8abc,@@def", "8abc,@def", "8abc,@def", map1, map2, "8abc,@def", ">@8abc,@def@^", map3, map2);
        int[] nArray14 = new int[8];
        nArray14[1] = 1;
        nArray14[2] = 2;
        nArray14[3] = 3;
        nArray14[4] = 4;
        nArray14[5] = 5;
        nArray14[6] = 6;
        nArray14[7] = 7;
        map1 = nArray14;
        int[] nArray15 = new int[9];
        nArray15[1] = 1;
        nArray15[2] = 2;
        nArray15[3] = 3;
        nArray15[4] = 4;
        nArray15[5] = 5;
        nArray15[6] = 6;
        nArray15[7] = 7;
        nArray15[8] = -1;
        map2 = nArray15;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9};
        this.doTest1("testFullToLean #09 - ", "9abc,def@", "9abc,def", "9abc,def", map1, map2, "9abc,def", ">@9abc,def@^", map3, map2);
        int[] nArray16 = new int[9];
        nArray16[1] = 1;
        nArray16[2] = 2;
        nArray16[3] = 3;
        nArray16[4] = 4;
        nArray16[5] = 5;
        nArray16[6] = 6;
        nArray16[7] = 7;
        nArray16[8] = 8;
        map1 = nArray16;
        int[] nArray17 = new int[11];
        nArray17[1] = 1;
        nArray17[2] = 2;
        nArray17[3] = 3;
        nArray17[4] = 4;
        nArray17[5] = 5;
        nArray17[6] = 6;
        nArray17[7] = 7;
        nArray17[8] = 8;
        nArray17[9] = -1;
        nArray17[10] = -1;
        map2 = nArray17;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
        this.doTest1("testFullToLean #10 - ", "10abc,def@@", "10abc,def", "10abc,def", map1, map2, "10abc,def", ">@10abc,def@^", map3, map2);
        int[] nArray18 = new int[12];
        nArray18[1] = 1;
        nArray18[2] = 2;
        nArray18[3] = 3;
        nArray18[4] = 4;
        nArray18[5] = 5;
        nArray18[6] = 6;
        nArray18[7] = 7;
        nArray18[8] = 8;
        nArray18[9] = 9;
        nArray18[10] = 10;
        nArray18[11] = 11;
        map1 = nArray18;
        int[] nArray19 = new int[14];
        nArray19[0] = -1;
        nArray19[2] = 1;
        nArray19[3] = 2;
        nArray19[4] = 3;
        nArray19[5] = 4;
        nArray19[6] = 5;
        nArray19[7] = 6;
        nArray19[8] = 7;
        nArray19[9] = 8;
        nArray19[10] = 9;
        nArray19[11] = 10;
        nArray19[12] = 11;
        nArray19[13] = -1;
        map2 = nArray19;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
        this.doTest1("testFullToLean #11 - ", "@a.11.bc,@def@", "a.11.bc,@def", "a.11.bc,@def", map1, map2, "a.11.bc,@def", ">@a.11.bc,@def@^", map3, map2);
        int[] nArray20 = new int[12];
        nArray20[1] = 1;
        nArray20[2] = 2;
        nArray20[3] = 3;
        nArray20[4] = 4;
        nArray20[5] = 5;
        nArray20[6] = 6;
        nArray20[7] = 7;
        nArray20[8] = 8;
        nArray20[9] = 9;
        nArray20[10] = 10;
        nArray20[11] = 11;
        map1 = nArray20;
        int[] nArray21 = new int[17];
        nArray21[0] = -1;
        nArray21[1] = -1;
        nArray21[3] = 1;
        nArray21[4] = 2;
        nArray21[5] = 3;
        nArray21[6] = 4;
        nArray21[7] = 5;
        nArray21[8] = 6;
        nArray21[9] = 7;
        nArray21[10] = 8;
        nArray21[11] = -1;
        nArray21[12] = 9;
        nArray21[13] = 10;
        nArray21[14] = 11;
        nArray21[15] = -1;
        nArray21[16] = -1;
        map2 = nArray21;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
        this.doTest1("testFullToLean #12 - ", "@@a.12.bc,@@def@@", "a.12.bc,@def", "a.12.bc,@def", map1, map2, "a.12.bc,@def", ">@a.12.bc,@def@^", map3, map2);
        int[] nArray22 = new int[5];
        nArray22[1] = 1;
        nArray22[2] = 2;
        nArray22[3] = 3;
        nArray22[4] = 4;
        map1 = nArray22;
        map2 = new int[]{2, 3, 4, 5, 6};
        this.doTest1("testFullToLean #13 - ", "13ABC", "13ABC", "13ABC", map1, map1, "13ABC", ">@13ABC@^", map2, map1);
        int[] nArray23 = new int[8];
        nArray23[1] = 1;
        nArray23[2] = 2;
        nArray23[3] = 3;
        nArray23[4] = 4;
        nArray23[5] = 6;
        nArray23[6] = 7;
        nArray23[7] = 8;
        map1 = nArray23;
        int[] nArray24 = new int[8];
        nArray24[1] = 1;
        nArray24[2] = 2;
        nArray24[3] = 3;
        nArray24[4] = 4;
        nArray24[5] = 5;
        nArray24[6] = 6;
        nArray24[7] = 7;
        map2 = nArray24;
        map3 = new int[]{2, 3, 4, 5, 6, 8, 9, 10};
        this.doTest1("testFullToLean #14 - ", "14ABC,DE", "14ABC,DE", "14ABC@,DE", map1, map2, "14ABC,DE", ">@14ABC@,DE@^", map3, map2);
        int[] nArray25 = new int[8];
        nArray25[1] = 1;
        nArray25[2] = 2;
        nArray25[3] = 3;
        nArray25[4] = 4;
        nArray25[5] = 6;
        nArray25[6] = 7;
        nArray25[7] = 8;
        map1 = nArray25;
        int[] nArray26 = new int[9];
        nArray26[1] = 1;
        nArray26[2] = 2;
        nArray26[3] = 3;
        nArray26[4] = 4;
        nArray26[5] = -1;
        nArray26[6] = 5;
        nArray26[7] = 6;
        nArray26[8] = 7;
        map2 = nArray26;
        map3 = new int[]{2, 3, 4, 5, 6, 8, 9, 10};
        this.doTest1("testFullToLean #15 - ", "15ABC@,DE", "15ABC,DE", "15ABC@,DE", map1, map2, "15ABC,DE", ">@15ABC@,DE@^", map3, map2);
        int[] nArray27 = new int[8];
        nArray27[1] = 1;
        nArray27[2] = 2;
        nArray27[3] = 3;
        nArray27[4] = 4;
        nArray27[5] = 6;
        nArray27[6] = 7;
        nArray27[7] = 8;
        map1 = nArray27;
        int[] nArray28 = new int[10];
        nArray28[1] = 1;
        nArray28[2] = 2;
        nArray28[3] = 3;
        nArray28[4] = 4;
        nArray28[5] = -1;
        nArray28[6] = -1;
        nArray28[7] = 5;
        nArray28[8] = 6;
        nArray28[9] = 7;
        map2 = nArray28;
        map3 = new int[]{2, 3, 4, 5, 6, 8, 9, 10};
        this.doTest1("testFullToLean #16 - ", "16ABC@@,DE", "16ABC,DE", "16ABC@,DE", map1, map2, "16ABC,DE", ">@16ABC@,DE@^", map3, map2);
        int[] nArray29 = new int[9];
        nArray29[1] = 1;
        nArray29[2] = 2;
        nArray29[3] = 3;
        nArray29[4] = 4;
        nArray29[5] = 5;
        nArray29[6] = 6;
        nArray29[7] = 7;
        nArray29[8] = 8;
        map1 = nArray29;
        int[] nArray30 = new int[10];
        nArray30[1] = 1;
        nArray30[2] = 2;
        nArray30[3] = 3;
        nArray30[4] = 4;
        nArray30[5] = 5;
        nArray30[6] = 6;
        nArray30[7] = -1;
        nArray30[8] = 7;
        nArray30[9] = 8;
        map2 = nArray30;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
        this.doTest1("testFullToLean #17 - ", "17ABC,@@DE", "17ABC,@DE", "17ABC,@DE", map1, map2, "17ABC,@DE", ">@17ABC,@DE@^", map3, map2);
        int[] nArray31 = new int[12];
        nArray31[1] = 1;
        nArray31[2] = 2;
        nArray31[3] = 3;
        nArray31[4] = 4;
        nArray31[5] = 6;
        nArray31[6] = 7;
        nArray31[7] = 8;
        nArray31[8] = 10;
        nArray31[9] = 11;
        nArray31[10] = 12;
        nArray31[11] = 13;
        map1 = nArray31;
        int[] nArray32 = new int[12];
        nArray32[1] = 1;
        nArray32[2] = 2;
        nArray32[3] = 3;
        nArray32[4] = 4;
        nArray32[5] = 5;
        nArray32[6] = 6;
        nArray32[7] = 7;
        nArray32[8] = 8;
        nArray32[9] = 9;
        nArray32[10] = 10;
        nArray32[11] = 11;
        map2 = nArray32;
        map3 = new int[]{2, 3, 4, 5, 6, 8, 9, 10, 12, 13, 14, 15};
        this.doTest1("testFullToLean #18 - ", "18ABC,DE,FGH", "18ABC,DE,FGH", "18ABC@,DE@,FGH", map1, map2, "18ABC,DE,FGH", ">@18ABC@,DE@,FGH@^", map3, map2);
        int[] nArray33 = new int[12];
        nArray33[1] = 1;
        nArray33[2] = 2;
        nArray33[3] = 3;
        nArray33[4] = 4;
        nArray33[5] = 6;
        nArray33[6] = 7;
        nArray33[7] = 8;
        nArray33[8] = 10;
        nArray33[9] = 11;
        nArray33[10] = 12;
        nArray33[11] = 13;
        map1 = nArray33;
        int[] nArray34 = new int[14];
        nArray34[1] = 1;
        nArray34[2] = 2;
        nArray34[3] = 3;
        nArray34[4] = 4;
        nArray34[5] = -1;
        nArray34[6] = 5;
        nArray34[7] = 6;
        nArray34[8] = 7;
        nArray34[9] = -1;
        nArray34[10] = 8;
        nArray34[11] = 9;
        nArray34[12] = 10;
        nArray34[13] = 11;
        map2 = nArray34;
        map3 = new int[]{2, 3, 4, 5, 6, 8, 9, 10, 12, 13, 14, 15};
        this.doTest1("testFullToLean #19 - ", "19ABC@,DE@,FGH", "19ABC,DE,FGH", "19ABC@,DE@,FGH", map1, map2, "19ABC,DE,FGH", ">@19ABC@,DE@,FGH@^", map3, map2);
        int[] nArray35 = new int[14];
        nArray35[1] = 1;
        nArray35[2] = 2;
        nArray35[3] = 3;
        nArray35[4] = 4;
        nArray35[5] = 5;
        nArray35[6] = 6;
        nArray35[7] = 7;
        nArray35[8] = 8;
        nArray35[9] = 9;
        nArray35[10] = 10;
        nArray35[11] = 11;
        nArray35[12] = 12;
        nArray35[13] = 13;
        map1 = nArray35;
        map2 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        this.doTest1("testFullToLean #20 - ", "20ABC,@DE,@FGH", "20ABC,@DE,@FGH", "20ABC,@DE,@FGH", map1, map1, "20ABC,@DE,@FGH", ">@20ABC,@DE,@FGH@^", map2, map1);
        int[] nArray36 = new int[12];
        nArray36[1] = 1;
        nArray36[2] = 2;
        nArray36[3] = 3;
        nArray36[4] = 4;
        nArray36[5] = 6;
        nArray36[6] = 7;
        nArray36[7] = 8;
        nArray36[8] = 10;
        nArray36[9] = 11;
        nArray36[10] = 12;
        nArray36[11] = 13;
        map1 = nArray36;
        int[] nArray37 = new int[16];
        nArray37[1] = 1;
        nArray37[2] = 2;
        nArray37[3] = 3;
        nArray37[4] = 4;
        nArray37[5] = -1;
        nArray37[6] = -1;
        nArray37[7] = 5;
        nArray37[8] = 6;
        nArray37[9] = 7;
        nArray37[10] = -1;
        nArray37[11] = -1;
        nArray37[12] = 8;
        nArray37[13] = 9;
        nArray37[14] = 10;
        nArray37[15] = 11;
        map2 = nArray37;
        map3 = new int[]{2, 3, 4, 5, 6, 8, 9, 10, 12, 13, 14, 15};
        this.doTest1("testFullToLean #21 - ", "21ABC@@,DE@@,FGH", "21ABC,DE,FGH", "21ABC@,DE@,FGH", map1, map2, "21ABC,DE,FGH", ">@21ABC@,DE@,FGH@^", map3, map2);
        int[] nArray38 = new int[14];
        nArray38[1] = 1;
        nArray38[2] = 2;
        nArray38[3] = 3;
        nArray38[4] = 4;
        nArray38[5] = 5;
        nArray38[6] = 6;
        nArray38[7] = 7;
        nArray38[8] = 8;
        nArray38[9] = 9;
        nArray38[10] = 10;
        nArray38[11] = 11;
        nArray38[12] = 12;
        nArray38[13] = 13;
        map1 = nArray38;
        int[] nArray39 = new int[16];
        nArray39[1] = 1;
        nArray39[2] = 2;
        nArray39[3] = 3;
        nArray39[4] = 4;
        nArray39[5] = 5;
        nArray39[6] = 6;
        nArray39[7] = -1;
        nArray39[8] = 7;
        nArray39[9] = 8;
        nArray39[10] = 9;
        nArray39[11] = 10;
        nArray39[12] = -1;
        nArray39[13] = 11;
        nArray39[14] = 12;
        nArray39[15] = 13;
        map2 = nArray39;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        this.doTest1("testFullToLean #22 - ", "22ABC,@@DE,@@FGH", "22ABC,@DE,@FGH", "22ABC,@DE,@FGH", map1, map2, "22ABC,@DE,@FGH", ">@22ABC,@DE,@FGH@^", map3, map2);
        int[] nArray40 = new int[5];
        nArray40[1] = 1;
        nArray40[2] = 2;
        nArray40[3] = 3;
        nArray40[4] = 4;
        map1 = nArray40;
        int[] nArray41 = new int[9];
        nArray41[0] = -1;
        nArray41[1] = -1;
        nArray41[3] = 1;
        nArray41[4] = 2;
        nArray41[5] = 3;
        nArray41[6] = 4;
        nArray41[7] = -1;
        nArray41[8] = -1;
        map2 = nArray41;
        map3 = new int[]{2, 3, 4, 5, 6};
        this.doTest1("testFullToLean #23 - ", ">@23abc@^", "23abc", "23abc", map1, map2, "23abc", ">@23abc@^", map3, map2);
        int[] nArray42 = new int[5];
        nArray42[1] = 1;
        nArray42[2] = 2;
        nArray42[3] = 3;
        nArray42[4] = 4;
        map1 = nArray42;
        int[] nArray43 = new int[7];
        nArray43[1] = 1;
        nArray43[2] = 2;
        nArray43[3] = 3;
        nArray43[4] = 4;
        nArray43[5] = -1;
        nArray43[6] = -1;
        map2 = nArray43;
        map3 = new int[]{2, 3, 4, 5, 6};
        this.doTest1("testFullToLean #24 - ", "24abc@^", "24abc", "24abc", map1, map2, "24abc", ">@24abc@^", map3, map2);
        int[] nArray44 = new int[5];
        nArray44[1] = 1;
        nArray44[2] = 2;
        nArray44[3] = 3;
        nArray44[4] = 4;
        map1 = nArray44;
        int[] nArray45 = new int[7];
        nArray45[0] = -1;
        nArray45[1] = -1;
        nArray45[3] = 1;
        nArray45[4] = 2;
        nArray45[5] = 3;
        nArray45[6] = 4;
        map2 = nArray45;
        map3 = new int[]{2, 3, 4, 5, 6};
        this.doTest1("testFullToLean #25 - ", ">@25abc", "25abc", "25abc", map1, map2, "25abc", ">@25abc@^", map3, map2);
        int[] nArray46 = new int[14];
        nArray46[1] = 1;
        nArray46[2] = 2;
        nArray46[3] = 3;
        nArray46[4] = 5;
        nArray46[5] = 6;
        nArray46[6] = 7;
        nArray46[7] = 8;
        nArray46[8] = 9;
        nArray46[9] = 10;
        nArray46[10] = 12;
        nArray46[11] = 13;
        nArray46[12] = 14;
        nArray46[13] = 15;
        map1 = nArray46;
        int[] nArray47 = new int[14];
        nArray47[1] = 1;
        nArray47[2] = 2;
        nArray47[3] = 3;
        nArray47[4] = 4;
        nArray47[5] = 5;
        nArray47[6] = 6;
        nArray47[7] = 7;
        nArray47[8] = 8;
        nArray47[9] = 9;
        nArray47[10] = 10;
        nArray47[11] = 11;
        nArray47[12] = 12;
        nArray47[13] = 13;
        map2 = nArray47;
        map3 = new int[]{2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17};
        this.doTest1("testFullToLean #26 - ", "26AB,CD@EF,GHI", "26AB,CD@EF,GHI", "26AB@,CD@EF@,GHI", map1, map2, "26AB,CD@EF,GHI", ">@26AB@,CD@EF@,GHI@^", map3, map2);
        int[] nArray48 = new int[17];
        nArray48[1] = 1;
        nArray48[2] = 2;
        nArray48[3] = 3;
        nArray48[4] = 5;
        nArray48[5] = 6;
        nArray48[6] = 7;
        nArray48[7] = 8;
        nArray48[8] = 9;
        nArray48[9] = 10;
        nArray48[10] = 11;
        nArray48[11] = 12;
        nArray48[12] = 13;
        nArray48[13] = 14;
        nArray48[14] = 15;
        nArray48[15] = 16;
        nArray48[16] = 17;
        map1 = nArray48;
        int[] nArray49 = new int[17];
        nArray49[1] = 1;
        nArray49[2] = 2;
        nArray49[3] = 3;
        nArray49[4] = 4;
        nArray49[5] = 5;
        nArray49[6] = 6;
        nArray49[7] = 7;
        nArray49[8] = 8;
        nArray49[9] = 9;
        nArray49[10] = 10;
        nArray49[11] = 11;
        nArray49[12] = 12;
        nArray49[13] = 13;
        nArray49[14] = 14;
        nArray49[15] = 15;
        nArray49[16] = 16;
        map2 = nArray49;
        map3 = new int[]{2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
        this.doTest1("testFullToLean #27 - ", "27AB,CD@123ef,GHI", "27AB,CD@123ef,GHI", "27AB@,CD@123ef,GHI", map1, map2, "27AB,CD@123ef,GHI", ">@27AB@,CD@123ef,GHI@^", map3, map2);
        int[] nArray50 = new int[12];
        nArray50[1] = 1;
        nArray50[2] = 2;
        nArray50[3] = 3;
        nArray50[4] = 4;
        nArray50[5] = 6;
        nArray50[6] = 7;
        nArray50[7] = 8;
        nArray50[8] = 10;
        nArray50[9] = 11;
        nArray50[10] = 12;
        nArray50[11] = 13;
        map1 = nArray50;
        int[] nArray51 = new int[16];
        nArray51[0] = -1;
        nArray51[2] = 1;
        nArray51[3] = 2;
        nArray51[4] = 3;
        nArray51[5] = 4;
        nArray51[6] = -1;
        nArray51[7] = 5;
        nArray51[8] = 6;
        nArray51[9] = 7;
        nArray51[10] = -1;
        nArray51[11] = 8;
        nArray51[12] = 9;
        nArray51[13] = 10;
        nArray51[14] = 11;
        nArray51[15] = -1;
        map2 = nArray51;
        map3 = new int[]{2, 3, 4, 5, 6, 8, 9, 10, 12, 13, 14, 15};
        this.doTest1("testFullToLean #28 - ", ">28ABC@,DE@,FGH^", "28ABC,DE,FGH", "28ABC@,DE@,FGH", map1, map2, "28ABC,DE,FGH", ">@28ABC@,DE@,FGH@^", map3, map2);
        int[] nArray52 = new int[12];
        nArray52[1] = 1;
        nArray52[2] = 2;
        nArray52[3] = 3;
        nArray52[4] = 4;
        nArray52[5] = 6;
        nArray52[6] = 7;
        nArray52[7] = 8;
        nArray52[8] = 10;
        nArray52[9] = 11;
        nArray52[10] = 12;
        nArray52[11] = 13;
        map1 = nArray52;
        int[] nArray53 = new int[18];
        nArray53[0] = -1;
        nArray53[1] = -1;
        nArray53[3] = 1;
        nArray53[4] = 2;
        nArray53[5] = 3;
        nArray53[6] = 4;
        nArray53[7] = -1;
        nArray53[8] = 5;
        nArray53[9] = 6;
        nArray53[10] = 7;
        nArray53[11] = -1;
        nArray53[12] = 8;
        nArray53[13] = 9;
        nArray53[14] = 10;
        nArray53[15] = 11;
        nArray53[16] = -1;
        nArray53[17] = -1;
        map2 = nArray53;
        map3 = new int[]{2, 3, 4, 5, 6, 8, 9, 10, 12, 13, 14, 15};
        this.doTest1("testFullToLean #29 - ", ">>29ABC@,DE@,FGH^^", "29ABC,DE,FGH", "29ABC@,DE@,FGH", map1, map2, "29ABC,DE,FGH", ">@29ABC@,DE@,FGH@^", map3, map2);
        int[] nArray54 = new int[14];
        nArray54[1] = 1;
        nArray54[2] = 2;
        nArray54[3] = 3;
        nArray54[4] = 4;
        nArray54[5] = 5;
        nArray54[6] = 6;
        nArray54[7] = 8;
        nArray54[8] = 9;
        nArray54[9] = 10;
        nArray54[10] = 12;
        nArray54[11] = 13;
        nArray54[12] = 14;
        nArray54[13] = 15;
        map1 = nArray54;
        int[] nArray55 = new int[18];
        nArray55[0] = -1;
        nArray55[2] = 1;
        nArray55[3] = 2;
        nArray55[4] = 3;
        nArray55[5] = 4;
        nArray55[6] = 5;
        nArray55[7] = 6;
        nArray55[8] = -1;
        nArray55[9] = 7;
        nArray55[10] = 8;
        nArray55[11] = 9;
        nArray55[12] = -1;
        nArray55[13] = 10;
        nArray55[14] = 11;
        nArray55[15] = 12;
        nArray55[16] = 13;
        nArray55[17] = -1;
        map2 = nArray55;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 14, 15, 16, 17};
        this.doTest1("testFullToLean #30 - ", ">30AB>C^@,DE@,FGH^", "30AB>C^,DE,FGH", "30AB>C^@,DE@,FGH", map1, map2, "30AB>C^,DE,FGH", ">@30AB>C^@,DE@,FGH@^", map3, map2);
        int[] nArray56 = new int[13];
        nArray56[1] = 1;
        nArray56[2] = 2;
        nArray56[3] = 3;
        nArray56[4] = 4;
        nArray56[5] = 5;
        nArray56[6] = 7;
        nArray56[7] = 8;
        nArray56[8] = 9;
        nArray56[9] = 11;
        nArray56[10] = 12;
        nArray56[11] = 13;
        nArray56[12] = 14;
        map1 = nArray56;
        int[] nArray57 = new int[18];
        nArray57[0] = -1;
        nArray57[2] = 1;
        nArray57[3] = 2;
        nArray57[4] = 3;
        nArray57[5] = 4;
        nArray57[6] = 5;
        nArray57[7] = -1;
        nArray57[8] = 6;
        nArray57[9] = 7;
        nArray57[10] = 8;
        nArray57[11] = -1;
        nArray57[12] = 9;
        nArray57[13] = 10;
        nArray57[14] = 11;
        nArray57[15] = 12;
        nArray57[16] = -1;
        nArray57[17] = -1;
        map2 = nArray57;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 16};
        this.doTest1("testFullToLean #31 - ", ">31AB>C@,DE@,FGH^^", "31AB>C,DE,FGH", "31AB>C@,DE@,FGH", map1, map2, "31AB>C,DE,FGH", ">@31AB>C@,DE@,FGH@^", map3, map2);
        int[] nArray58 = new int[12];
        nArray58[1] = 1;
        nArray58[2] = 2;
        nArray58[3] = 3;
        nArray58[4] = 4;
        nArray58[5] = 6;
        nArray58[6] = 7;
        nArray58[7] = 8;
        nArray58[8] = 10;
        nArray58[9] = 11;
        nArray58[10] = 12;
        nArray58[11] = 13;
        map1 = nArray58;
        int[] nArray59 = new int[18];
        nArray59[0] = -1;
        nArray59[1] = -1;
        nArray59[3] = 1;
        nArray59[4] = 2;
        nArray59[5] = 3;
        nArray59[6] = 4;
        nArray59[7] = -1;
        nArray59[8] = 5;
        nArray59[9] = 6;
        nArray59[10] = 7;
        nArray59[11] = -1;
        nArray59[12] = 8;
        nArray59[13] = 9;
        nArray59[14] = 10;
        nArray59[15] = 11;
        nArray59[16] = -1;
        nArray59[17] = -1;
        map2 = nArray59;
        map3 = new int[]{2, 3, 4, 5, 6, 8, 9, 10, 12, 13, 14, 15};
        this.doTest1("testFullToLean #32 - ", ">@32ABC@,DE@,FGH@^", "32ABC,DE,FGH", "32ABC@,DE@,FGH", map1, map2, "32ABC,DE,FGH", ">@32ABC@,DE@,FGH@^", map3, map2);
        int[] nArray60 = new int[12];
        nArray60[1] = 1;
        nArray60[2] = 2;
        nArray60[3] = 3;
        nArray60[4] = 4;
        nArray60[5] = 6;
        nArray60[6] = 7;
        nArray60[7] = 8;
        nArray60[8] = 10;
        nArray60[9] = 11;
        nArray60[10] = 12;
        nArray60[11] = 13;
        map1 = nArray60;
        int[] nArray61 = new int[17];
        nArray61[0] = -1;
        nArray61[2] = 1;
        nArray61[3] = 2;
        nArray61[4] = 3;
        nArray61[5] = 4;
        nArray61[6] = -1;
        nArray61[7] = 5;
        nArray61[8] = 6;
        nArray61[9] = 7;
        nArray61[10] = -1;
        nArray61[11] = 8;
        nArray61[12] = 9;
        nArray61[13] = 10;
        nArray61[14] = 11;
        nArray61[15] = -1;
        nArray61[16] = -1;
        map2 = nArray61;
        map3 = new int[]{2, 3, 4, 5, 6, 8, 9, 10, 12, 13, 14, 15};
        this.doTest1("testFullToLean #33 - ", "@33ABC@,DE@,FGH@^", "33ABC,DE,FGH", "33ABC@,DE@,FGH", map1, map2, "33ABC,DE,FGH", ">@33ABC@,DE@,FGH@^", map3, map2);
        int[] nArray62 = new int[12];
        nArray62[1] = 1;
        nArray62[2] = 2;
        nArray62[3] = 3;
        nArray62[4] = 4;
        nArray62[5] = 6;
        nArray62[6] = 7;
        nArray62[7] = 8;
        nArray62[8] = 10;
        nArray62[9] = 11;
        nArray62[10] = 12;
        nArray62[11] = 13;
        map1 = nArray62;
        int[] nArray63 = new int[17];
        nArray63[0] = -1;
        nArray63[1] = -1;
        nArray63[3] = 1;
        nArray63[4] = 2;
        nArray63[5] = 3;
        nArray63[6] = 4;
        nArray63[7] = -1;
        nArray63[8] = 5;
        nArray63[9] = 6;
        nArray63[10] = 7;
        nArray63[11] = -1;
        nArray63[12] = 8;
        nArray63[13] = 9;
        nArray63[14] = 10;
        nArray63[15] = 11;
        nArray63[16] = -1;
        map2 = nArray63;
        map3 = new int[]{2, 3, 4, 5, 6, 8, 9, 10, 12, 13, 14, 15};
        this.doTest1("testFullToLean #34 - ", ">@34ABC@,DE@,FGH@", "34ABC,DE,FGH", "34ABC@,DE@,FGH", map1, map2, "34ABC,DE,FGH", ">@34ABC@,DE@,FGH@^", map3, map2);
        int[] nArray64 = new int[11];
        nArray64[1] = 1;
        nArray64[2] = 2;
        nArray64[3] = 3;
        nArray64[4] = 4;
        nArray64[5] = 5;
        nArray64[6] = 6;
        nArray64[7] = 7;
        nArray64[8] = 8;
        nArray64[9] = 9;
        nArray64[10] = 10;
        map1 = nArray64;
        int[] nArray65 = new int[15];
        nArray65[1] = 1;
        nArray65[2] = 2;
        nArray65[3] = 3;
        nArray65[4] = 4;
        nArray65[5] = 5;
        nArray65[6] = -1;
        nArray65[7] = 6;
        nArray65[8] = 7;
        nArray65[9] = 8;
        nArray65[10] = -1;
        nArray65[11] = -1;
        nArray65[12] = 9;
        nArray65[13] = 10;
        nArray65[14] = -1;
        map2 = nArray65;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        this.doTest1("testFullToLean #35 - ", "35ABC@@DE@@@GH@", "35ABC@DE@GH", "35ABC@DE@GH", map1, map2, "35ABC@DE@GH", ">@35ABC@DE@GH@^", map3, map2);
        int[] nArray66 = new int[8];
        nArray66[1] = 1;
        nArray66[2] = 2;
        nArray66[3] = 3;
        nArray66[4] = 4;
        nArray66[5] = 5;
        nArray66[6] = 6;
        nArray66[7] = 7;
        map1 = nArray66;
        int[] nArray67 = new int[15];
        nArray67[1] = 1;
        nArray67[2] = 2;
        nArray67[3] = 3;
        nArray67[4] = 4;
        nArray67[5] = 5;
        nArray67[6] = -1;
        nArray67[7] = 6;
        nArray67[8] = 7;
        nArray67[9] = -1;
        nArray67[10] = -1;
        nArray67[11] = -1;
        nArray67[12] = -1;
        nArray67[13] = -1;
        nArray67[14] = -1;
        map2 = nArray67;
        map3 = new int[]{2, 3, 4, 5, 6, 7, 8, 9};
        this.doTest1("testFullToLean #36 - ", "36ABC@@DE@@@@@@", "36ABC@DE", "36ABC@DE", map1, map2, "36ABC@DE", ">@36ABC@DE@^", map3, map2);
        map1 = new int[]{};
        map2 = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        this.doTest1("testFullToLean #37 - ", ">>>@@@@@^^^", "", "", map1, map2, "", "", map1, map2);
        this.type = "sql";
        this.doTest2("testFullToLean #38 - ");
    }
}

