/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.tests;

import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.custom.StructuredTextCharTypes;
import org.eclipse.equinox.bidi.custom.StructuredTextTypeHandler;

public class StructuredTextMath
extends StructuredTextTypeHandler {
    static final byte L = 0;
    static final byte R = 1;
    static final byte AL = 2;
    static final byte AN = 6;

    public StructuredTextMath() {
        super("+-/*()=");
    }

    public int getDirection(IStructuredTextExpert expert, String text) {
        return this.getDirection(expert, text, new StructuredTextCharTypes(expert, text));
    }

    public int getDirection(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes) {
        String language = expert.getEnvironment().getLanguage();
        if (!language.equals("ar")) {
            return 0;
        }
        boolean flagAN = false;
        int i = 0;
        while (i < text.length()) {
            byte charType = charTypes.getBidiTypeAt(i);
            if (charType == 2) {
                return 1;
            }
            if (charType == 0 || charType == 1) {
                return 0;
            }
            if (charType == 6) {
                flagAN = true;
            }
            ++i;
        }
        if (flagAN) {
            return 1;
        }
        return 0;
    }
}

