/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.tests;

import java.util.Locale;
import org.eclipse.equinox.bidi.StructuredTextProcessor;
import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.advanced.StructuredTextExpertFactory;
import org.eclipse.equinox.bidi.internal.tests.StructuredTextTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StructuredTextProcessorTest
extends StructuredTextTestBase {
    private static final String HEBREW = "iw";
    private static final String HEBREW2 = "he";
    private static final String ARABIC = "ar";
    private static final String FARSI = "fa";
    private static final String URDU = "ur";
    private Locale locale;

    @Before
    public void setUp() throws Exception {
        this.locale = Locale.getDefault();
    }

    @After
    public void tearDown() {
        Locale.setDefault(this.locale);
    }

    private void doTest1(String data, String result) {
        Locale.setDefault(Locale.ENGLISH);
        String full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data));
        Assert.assertEquals((String)"Util #1 full EN - ", (Object)result, (Object)StructuredTextProcessorTest.toPseudo(full));
        Locale.setDefault(new Locale(HEBREW2));
        full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data));
        Assert.assertEquals((String)"Util #1 full HE - ", (Object)result, (Object)StructuredTextProcessorTest.toPseudo(full));
        Locale.setDefault(new Locale(ARABIC));
        full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data));
        Assert.assertEquals((String)"Util #1 full AR - ", (Object)result, (Object)StructuredTextProcessorTest.toPseudo(full));
        Locale.setDefault(new Locale(FARSI));
        full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data));
        Assert.assertEquals((String)"Util #1 full FA - ", (Object)result, (Object)StructuredTextProcessorTest.toPseudo(full));
        Locale.setDefault(new Locale(URDU));
        full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data));
        Assert.assertEquals((String)"Util #1 full UR - ", (Object)result, (Object)StructuredTextProcessorTest.toPseudo(full));
        Locale.setDefault(new Locale(HEBREW));
        full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data));
        String ful2 = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data), null);
        Assert.assertEquals((String)"Util #1 full - ", (Object)result, (Object)StructuredTextProcessorTest.toPseudo(full));
        Assert.assertEquals((String)"Util #1 ful2 - ", (Object)result, (Object)StructuredTextProcessorTest.toPseudo(ful2));
        String lean = StructuredTextProcessor.deprocess((String)full);
        Assert.assertEquals((String)"Util #1 lean - ", (Object)data, (Object)StructuredTextProcessorTest.toPseudo(lean));
    }

    private void doTest2(String msg, String data, String result) {
        this.doTest2(msg, data, result, data);
    }

    private void doTest2(String msg, String data, String result, String resLean) {
        String full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data), (String)"*");
        Assert.assertEquals((String)(msg + "full"), (Object)result, (Object)StructuredTextProcessorTest.toPseudo(full));
        String lean = StructuredTextProcessor.deprocess((String)full);
        Assert.assertEquals((String)(msg + "lean"), (Object)resLean, (Object)StructuredTextProcessorTest.toPseudo(lean));
    }

    private void doTest3(String msg, String data, String result) {
        this.doTest3(msg, data, result, data);
    }

    private void doTest3(String msg, String data, String result, String resLean) {
        String full = StructuredTextProcessor.processTyped((String)StructuredTextProcessorTest.toUT16(data), (String)"comma");
        Assert.assertEquals((String)(msg + "full"), (Object)result, (Object)StructuredTextProcessorTest.toPseudo(full));
        String lean = StructuredTextProcessor.deprocessTyped((String)full, (String)"comma");
        Assert.assertEquals((String)(msg + "lean"), (Object)resLean, (Object)StructuredTextProcessorTest.toPseudo(lean));
    }

    private void doTest4(String msg, String data, int[] offsets, int direction, int affixLength, String result) {
        String txt = msg + "text=" + data + "\n    offsets=" + StructuredTextProcessorTest.array_display(offsets) + "\n    direction=" + direction + "\n    affixLength=" + affixLength;
        String lean = StructuredTextProcessorTest.toUT16(data);
        IStructuredTextExpert expert = StructuredTextExpertFactory.getExpert();
        String full = expert.insertMarks(lean, offsets, direction, affixLength);
        Assert.assertEquals((String)txt, (Object)result, (Object)StructuredTextProcessorTest.toPseudo(full));
    }

    @Test
    public void testStructuredTextProcessor() {
        this.doTest1("ABC/DEF/G", ">@ABC@/DEF@/G@^");
        this.doTest2("Util #2.1 - ", "", "");
        this.doTest2("Util #2.2 - ", ">@ABC@^", ">@ABC@^", "ABC");
        this.doTest2("Util #2.3 - ", "abc", "abc");
        this.doTest2("Util #2.4 - ", "!abc", ">@!abc@^");
        this.doTest2("Util #2.5 - ", "abc!", ">@abc!@^");
        this.doTest2("Util #2.6 - ", "ABC*DEF*G", ">@ABC@*DEF@*G@^");
        this.doTest3("Util #3.1 - ", "ABC,DEF,G", ">@ABC@,DEF@,G@^");
        this.doTest3("Util #3.2 - ", "", "");
        this.doTest3("Util #3.3 - ", ">@DEF@^", ">@DEF@^", "DEF");
        this.doTest4("Util #4.1 - ", "ABCDEFG", new int[]{3, 6}, 0, 0, "ABC@DEF@G");
        this.doTest4("Util #4.2 - ", "ABCDEFG", new int[]{3, 6}, 0, 2, ">@ABC@DEF@G@^");
        this.doTest4("Util #4.3 - ", "ABCDEFG", new int[]{3, 6}, 1, 0, "ABC&DEF&G");
        this.doTest4("Util #4.4 - ", "ABCDEFG", new int[]{3, 6}, 1, 2, "<&ABC&DEF&G&^");
        this.doTest4("Util #4.5 - ", "", new int[]{3, 6}, 0, 0, "");
        this.doTest4("Util #4.6 - ", "", new int[]{3, 6}, 0, 2, "");
        this.doTest4("Util #4.7 - ", "ABCDEFG", null, 1, 0, "ABCDEFG");
        this.doTest4("Util #4.8 - ", "ABCDEFG", null, 1, 2, "<&ABCDEFG&^");
    }
}

