/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.tests;

import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.advanced.StructuredTextEnvironment;
import org.eclipse.equinox.bidi.advanced.StructuredTextExpertFactory;
import org.eclipse.equinox.bidi.custom.StructuredTextCharTypes;
import org.eclipse.equinox.bidi.custom.StructuredTextOffsets;
import org.eclipse.equinox.bidi.custom.StructuredTextTypeHandler;
import org.eclipse.equinox.bidi.internal.tests.StructuredTextTestBase;
import org.junit.Assert;
import org.junit.Test;

public class StructuredTextSomeMoreTest
extends StructuredTextTestBase {
    static final StructuredTextEnvironment env1 = new StructuredTextEnvironment("en_US", false, 0);
    static final StructuredTextEnvironment env2 = new StructuredTextEnvironment("he", false, 0);

    @Test
    public void testSomeMore() {
        Assert.assertFalse((boolean)env1.isProcessingNeeded());
        Assert.assertTrue((boolean)env2.isProcessingNeeded());
        TestHandler1 handler1 = new TestHandler1();
        IStructuredTextExpert expert1 = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)handler1, (StructuredTextEnvironment)env1);
        String full = expert1.leanToFullText("abcd");
        Assert.assertEquals((Object)"@a@b@c@d", (Object)StructuredTextSomeMoreTest.toPseudo(full));
        TestHandler2 handler2 = new TestHandler2();
        IStructuredTextExpert expert2 = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)handler2, (StructuredTextEnvironment)env1);
        boolean catchFlag = false;
        try {
            full = expert2.leanToFullText("abcd");
        }
        catch (IllegalStateException e) {
            catchFlag = true;
        }
        Assert.assertTrue((String)"Catch missing indexOfSpecial", (boolean)catchFlag);
        TestHandler3 handler3 = new TestHandler3();
        IStructuredTextExpert expert3 = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)handler3, (StructuredTextEnvironment)env1);
        catchFlag = false;
        try {
            full = expert3.leanToFullText("abcd");
        }
        catch (IllegalStateException e) {
            catchFlag = true;
        }
        Assert.assertTrue((String)"Catch missing processSpecial", (boolean)catchFlag);
    }

    private static class TestHandler1
    extends StructuredTextTypeHandler {
        public int getSpecialsCount(IStructuredTextExpert expert) {
            return 1;
        }

        public int indexOfSpecial(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes, StructuredTextOffsets offsets, int caseNumber, int fromIndex) {
            return fromIndex;
        }

        public int processSpecial(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes, StructuredTextOffsets offsets, int caseNumber, int separLocation) {
            int len = text.length();
            int i = len - 1;
            while (i >= 0) {
                StructuredTextTypeHandler.insertMark((String)text, (StructuredTextCharTypes)charTypes, (StructuredTextOffsets)offsets, (int)i);
                StructuredTextTypeHandler.insertMark((String)text, (StructuredTextCharTypes)charTypes, (StructuredTextOffsets)offsets, (int)i);
                --i;
            }
            return len;
        }
    }

    private static class TestHandler2
    extends StructuredTextTypeHandler {
        public int getSpecialsCount(IStructuredTextExpert expert) {
            return 1;
        }
    }

    private static class TestHandler3
    extends StructuredTextTypeHandler {
        public int getSpecialsCount(IStructuredTextExpert expert) {
            return 1;
        }

        public int indexOfSpecial(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes, StructuredTextOffsets offsets, int caseNumber, int fromIndex) {
            return fromIndex;
        }
    }
}

