/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.unittest.junit.launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jdt.internal.junit.launcher.JUnitRuntimeClasspathEntry;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jdt.ui.unittest.junit.JUnitTestPlugin;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.EclipsePluginValidationOperation;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.internal.launching.launcher.RequirementHelper;
import org.eclipse.pde.internal.launching.launcher.VMHelper;
import org.eclipse.pde.launching.JUnitLaunchConfigurationDelegate;
import org.eclipse.pde.unittest.junit.JUnitPluginTestPlugin;
import org.eclipse.pde.unittest.junit.launcher.Messages;
import org.osgi.framework.Bundle;

public class JUnitPluginLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String ATTR_PORT = "org.eclipse.pde.unittest.junit.PORT";
    private boolean fKeepAlive = false;
    private int fPort;
    private IJavaElement[] fTestElements;
    private static final String DEFAULT = "<default>";
    private String fWorkspaceLocation;
    protected File fConfigDir = null;
    private Map<String, List<IPluginModelBase>> fAllBundles;
    private Map<IPluginModelBase, String> fModels;
    private String launchMode;
    private static final String PDE_JUNIT_SHOW_COMMAND = "pde.junit.showcommandline";

    static {
        RequirementHelper.registerSameRequirementsAsFor((String)"org.eclipse.pde.unittest.junit.launchConfiguration", (String)"org.eclipse.pde.ui.JunitLaunchConfig");
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        JUnitPluginTestPlugin.activateUnitTestCoreBundle();
        return super.getLaunch(configuration, mode);
    }

    public String showCommandLine(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        launch.setAttribute(PDE_JUNIT_SHOW_COMMAND, "true");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            VMRunnerConfiguration runConfig = this.getVMRunnerConfiguration(configuration, launch, mode, monitor);
            if (runConfig == null) {
                return "";
            }
            IVMRunner runner = this.getVMRunner(configuration, mode);
            String cmdLine = runner.showCommandLine(runConfig, launch, monitor);
            if (monitor.isCanceled()) {
                return "";
            }
            String string = cmdLine;
            return string;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VMRunnerConfiguration getVMRunnerConfiguration(ILaunchConfiguration configuration, ILaunch launch, String mode, IProgressMonitor monitor) throws CoreException {
        IJavaElement testTarget;
        VMRunnerConfiguration runConfig = null;
        monitor.beginTask(MessageFormat.format("{0}...", configuration.getName()), 5);
        if (monitor.isCanceled()) {
            return null;
        }
        if (mode.equals("runQuietly")) {
            launch.setAttribute("org.eclipse.jdt.junit.NO_DISPLAY", "true");
            mode = "run";
        }
        monitor.subTask(Messages.JUnitPluginLaunchConfigurationDelegate_verifying_attriburtes_description);
        try {
            this.preLaunchCheck(configuration, launch, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)2));
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() != 8) throw e;
            monitor.setCanceled(true);
            monitor.worked(1);
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        this.fKeepAlive = mode.equals("debug") && configuration.getAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
        this.fPort = this.evaluatePort();
        launch.setAttribute(ATTR_PORT, String.valueOf(this.fPort));
        JUnitTestPlugin.JUnitVersion junitVersion = JUnitPluginLaunchConfigurationDelegate.getJUnitVersion(configuration);
        IJavaProject javaProject = this.getJavaProject(configuration);
        this.fTestElements = junitVersion == JUnitTestPlugin.JUnitVersion.JUNIT3 || junitVersion == JUnitTestPlugin.JUnitVersion.JUNIT4 ? this.evaluateTests(configuration, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1)) : ((testTarget = this.getTestTarget(configuration, javaProject)) instanceof IPackageFragment || testTarget instanceof IPackageFragmentRoot || testTarget instanceof IJavaProject ? new IJavaElement[]{testTarget} : this.evaluateTests(configuration, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1)));
        String mainTypeName = this.verifyMainTypeName(configuration);
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String[] envp = this.getEnvironment(configuration);
        ArrayList<String> vmArguments = new ArrayList<String>();
        ArrayList<String> programArguments = new ArrayList<String>();
        this.collectExecutionArguments(configuration, vmArguments, programArguments);
        vmArguments.addAll(Arrays.asList(DebugPlugin.parseArguments((String)this.getVMArguments(configuration, mode))));
        if (JavaRuntime.isModularProject((IJavaProject)javaProject)) {
            vmArguments.add("--add-modules=ALL-MODULE-PATH");
        }
        Map<String, Object> vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[][] classpathAndModulepath = this.getClasspathAndModulepath(configuration);
        String[] classpath = classpathAndModulepath[0];
        String[] modulepath = classpathAndModulepath[1];
        if (junitVersion == JUnitTestPlugin.JUnitVersion.JUNIT5 && !configuration.getAttribute("org.eclipse.jdt.junit.DONT_ADD_MISSING_JUNIT5_DEPENDENCY", false) && !Arrays.stream(classpath).anyMatch(s -> s.contains("junit-platform-launcher") || s.contains("org.junit.platform.launcher"))) {
            try {
                JUnitRuntimeClasspathEntry x = new JUnitRuntimeClasspathEntry("junit-platform-launcher", null);
                String entryString = new ClasspathLocalizer(Platform.inDevelopmentMode()).entryString(x);
                int length = classpath.length;
                String[] stringArray = classpath;
                classpath = new String[length + 1];
                System.arraycopy(stringArray, 0, classpath, 0, length);
                classpath[length] = entryString;
            }
            catch (IOException | URISyntaxException e) {
                throw new CoreException(Status.error((String)"", (Throwable)e));
            }
        }
        runConfig = new VMRunnerConfiguration(mainTypeName, classpath);
        runConfig.setVMArguments(vmArguments.toArray(new String[vmArguments.size()]));
        runConfig.setProgramArguments(programArguments.toArray(new String[programArguments.size()]));
        runConfig.setEnvironment(envp);
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        runConfig.setPreviewEnabled(this.supportsPreviewFeatures(configuration));
        if (!JavaRuntime.isModularConfiguration((ILaunchConfiguration)configuration)) {
            runConfig.setBootClassPath(this.getBootpath(configuration));
        } else {
            runConfig.setModulepath(modulepath);
            if (!configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_MODULE_CLI_OPTIONS, true)) {
                runConfig.setOverrideDependencies(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MODULE_CLI_OPTIONS, ""));
            } else {
                runConfig.setOverrideDependencies(this.getModuleCLIOptions(configuration));
            }
        }
        if (!monitor.isCanceled()) return runConfig;
        return null;
        finally {
            monitor.worked(1);
        }
    }

    static JUnitTestPlugin.JUnitVersion getJUnitVersion(ILaunchConfiguration configuration) {
        try {
            String junitTestKindId = configuration.getAttribute("org.eclipse.jdt.junit.TEST_KIND", "");
            if (!junitTestKindId.isEmpty()) {
                return JUnitTestPlugin.JUnitVersion.fromJUnitTestKindId((String)junitTestKindId);
            }
        }
        catch (Exception ex) {
            JUnitPluginTestPlugin.log(ex);
        }
        IJavaProject javaProject = JUnitLaunchConfigurationConstants.getJavaProject((ILaunchConfiguration)configuration);
        if (javaProject != null) {
            return JUnitTestPlugin.getJUnitVersion((IJavaElement)javaProject);
        }
        return JUnitTestPlugin.JUnitVersion.JUNIT3;
    }

    public synchronized void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            VMRunnerConfiguration runConfig = this.getVMRunnerConfiguration(configuration, launch, mode, monitor);
            if (monitor.isCanceled() || runConfig == null) {
                return;
            }
            IVMRunner runner = this.getVMRunner(configuration, mode);
            monitor.subTask(Messages.JUnitPluginLaunchConfigurationDelegate_create_source_locator_description);
            this.setDefaultSourceLocator(launch, configuration);
            monitor.worked(1);
            runner.run(runConfig, launch, monitor);
        }
        finally {
            this.fTestElements = null;
            monitor.done();
        }
    }

    private int evaluatePort() throws CoreException {
        int port = SocketUtil.findFreePort();
        if (port == -1) {
            this.abort(Messages.JUnitPluginLaunchConfigurationDelegate_error_no_socket, null, 118);
        }
        return port;
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean autoValidate;
        this.launchMode = launch.getLaunchMode();
        this.fWorkspaceLocation = null;
        this.fConfigDir = null;
        this.fModels = BundleLauncherHelper.getMergedBundleMap((ILaunchConfiguration)configuration, (boolean)false);
        this.fAllBundles = this.fModels.keySet().stream().collect(Collectors.groupingBy(m -> m.getPluginBase().getId(), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
        this.addRequiredJunitRuntimePlugins(configuration);
        String attribute = launch.getAttribute(PDE_JUNIT_SHOW_COMMAND);
        boolean isShowCommand = false;
        if (attribute != null) {
            isShowCommand = attribute.equals("true");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)((autoValidate = configuration.getAttribute("automaticValidate", false)) ? 3 : 4));
        if (!isShowCommand) {
            if (autoValidate) {
                this.validatePluginDependencies(configuration, (IProgressMonitor)subMonitor.split(1));
            }
            this.validateProjectDependencies(configuration, (IProgressMonitor)subMonitor.split(1));
            this.clear(configuration, (IProgressMonitor)subMonitor.split(1));
        }
        launch.setAttribute(PDE_JUNIT_SHOW_COMMAND, "false");
        launch.setAttribute("configLocation", this.getConfigurationDirectory(configuration).toString());
        this.synchronizeManifests(configuration, (IProgressMonitor)subMonitor.split(1));
    }

    private void addRequiredJunitRuntimePlugins(ILaunchConfiguration configuration) throws CoreException {
        LinkedHashSet<String> requiredPlugins = new LinkedHashSet<String>(JUnitLaunchConfigurationDelegate.getRequiredJunitRuntimePlugins((ILaunchConfiguration)configuration));
        if (this.fAllBundles.containsKey("junit-platform-runner")) {
            requiredPlugins.add("junit-platform-launcher");
            requiredPlugins.add("junit-jupiter-engine");
        }
        HashSet<BundleDescription> addedRequirements = new HashSet<BundleDescription>();
        this.addAbsentRequirements(requiredPlugins, addedRequirements);
        Set requirementsOfRequirements = DependencyManager.findRequirementsClosure(addedRequirements, (DependencyManager.Options[])new DependencyManager.Options[0]);
        Set<String> rorIds = requirementsOfRequirements.stream().map(BundleDescription::getSymbolicName).collect(Collectors.toSet());
        this.addAbsentRequirements(rorIds, null);
    }

    private void addAbsentRequirements(Collection<String> requirements, Set<BundleDescription> addedRequirements) throws CoreException {
        for (String id : requirements) {
            List models = this.fAllBundles.computeIfAbsent(id, k -> new ArrayList());
            if (!models.stream().noneMatch(m -> m.getBundleDescription().isResolved())) continue;
            IPluginModelBase model = this.findRequiredPluginInTargetOrHost(id);
            models.add(model);
            BundleLauncherHelper.addDefaultStartingBundle(this.fModels, (IPluginModelBase)model);
            if (addedRequirements == null) continue;
            addedRequirements.add(model.getBundleDescription());
        }
    }

    public String getJavaProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
    }

    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        String mainType = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        if (mainType == null) {
            return null;
        }
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(mainType);
    }

    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        if (TargetPlatformHelper.getTargetVersion() >= 3.3) {
            return "org.eclipse.equinox.launcher.Main";
        }
        return "org.eclipse.core.launcher.Main";
    }

    protected IMember[] evaluateTests(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        IJavaElement testTarget = this.getTestTarget(configuration, javaProject);
        String testMethodName = configuration.getAttribute("org.eclipse.jdt.junit.TESTNAME", "");
        if (testMethodName.length() > 0 && testTarget instanceof IType) {
            return new IMember[]{((IType)testTarget).getMethod(testMethodName, new String[0])};
        }
        HashSet result = new HashSet();
        ITestKind junitTestKind = JUnitPluginLaunchConfigurationDelegate.getJUnitVersion(configuration).getJUnitTestKind();
        junitTestKind.getFinder().findTestsInContainer(testTarget, result, monitor);
        if (result.isEmpty()) {
            String msg = MessageFormat.format(Messages.JUnitPluginLaunchConfigurationDelegate_error_notests_kind, junitTestKind.getDisplayName());
            this.abort(msg, null, 101);
        }
        return result.toArray(new IMember[result.size()]);
    }

    protected void collectExecutionArguments(ILaunchConfiguration configuration, List<String> vmArguments, List<String> programArgs) throws CoreException {
        String[] userArgs;
        this.internalCollectExecutionArguments(configuration, vmArguments, programArgs);
        programArgs.add("-application");
        String application = this.getApplication(configuration);
        programArgs.add(application);
        if (configuration.getAttribute("useProduct", false)) {
            programArgs.add("-product");
            programArgs.add(configuration.getAttribute("product", ""));
        } else {
            String defaultApplication = TargetPlatform.getDefaultApplication();
            if ("org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
                defaultApplication = null;
            } else if ("org.eclipse.pde.junit.runtime.nonuithreadtestapplication".equals(application)) {
                defaultApplication = "org.eclipse.pde.junit.runtime.coretestapplication";
            }
            String testApplication = configuration.getAttribute("testApplication", defaultApplication);
            if (testApplication != null) {
                programArgs.add("-testApplication");
                programArgs.add(testApplication);
            }
        }
        if (this.fWorkspaceLocation == null) {
            this.fWorkspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation((ILaunchConfiguration)configuration);
        }
        if (this.fWorkspaceLocation.length() > 0) {
            programArgs.add("-data");
            programArgs.add(this.fWorkspaceLocation);
        }
        String productID = LaunchConfigurationHelper.getProductID((ILaunchConfiguration)configuration);
        LaunchConfigurationHelper.createConfigIniFile((ILaunchConfiguration)configuration, (String)productID, this.fAllBundles, this.fModels, (File)this.getConfigurationDirectory(configuration));
        TargetPlatformHelper.checkPluginPropertiesConsistency(this.fAllBundles, (File)this.getConfigurationDirectory(configuration));
        programArgs.add("-configuration");
        programArgs.add("file:" + String.valueOf(IPath.fromFile((File)this.getConfigurationDirectory(configuration)).addTrailingSeparator()));
        programArgs.add("-dev");
        programArgs.add(ClasspathHelper.getDevEntriesProperties((String)(this.getConfigurationDirectory(configuration).toString() + "/dev.properties"), this.fAllBundles).toUri().toString());
        if (configuration.getAttribute("tracing", false) && !"[NONE]".equals(configuration.getAttribute("checked", null))) {
            programArgs.add("-debug");
            Path path = this.getConfigurationDirectory(configuration).toPath().resolve(".options");
            programArgs.add(LaunchArgumentsHelper.getTracingFileArgument((ILaunchConfiguration)configuration, (Path)path));
        }
        String[] stringArray = userArgs = LaunchArgumentsHelper.getUserProgramArgumentArray((ILaunchConfiguration)configuration);
        int n = userArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String userArg = stringArray[n2];
            if (!userArg.equals("-debug") || !programArgs.contains("-debug")) {
                programArgs.add(userArg);
            }
            ++n2;
        }
        if (!configuration.getAttribute("append.args", false)) {
            if (!programArgs.contains("-os")) {
                programArgs.add("-os");
                programArgs.add(TargetPlatform.getOS());
            }
            if (!programArgs.contains("-ws")) {
                programArgs.add("-ws");
                programArgs.add(TargetPlatform.getWS());
            }
            if (!programArgs.contains("-arch")) {
                programArgs.add("-arch");
                programArgs.add(TargetPlatform.getOSArch());
            }
        }
        programArgs.add("-testpluginname");
        programArgs.add(this.getTestPluginId(configuration));
        IVMInstall launcher = VMHelper.createLauncher((ILaunchConfiguration)configuration, this.fModels.keySet());
        boolean isModular = JavaRuntime.isModularJava((IVMInstall)launcher);
        if (isModular) {
            VMHelper.addNewArgument(vmArguments, (String)"--add-modules", (String)"ALL-SYSTEM");
        }
        if (configuration.getAttribute("org.eclipse.jdt.junit.IS_RUN_WITH_JUNIT_PLATFORM", false)) {
            programArgs.add("-runasjunit5");
        }
    }

    private void internalCollectExecutionArguments(ILaunchConfiguration configuration, List<String> vmArguments, List<String> programArguments) throws CoreException {
        String excludeTags;
        boolean hasExcludeTags;
        int n;
        String includeTags;
        boolean hasIncludeTags;
        String uniqueId;
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        vmArguments.addAll(Arrays.asList(execArgs.getVMArgumentsArray()));
        programArguments.addAll(Arrays.asList(execArgs.getProgramArgumentsArray()));
        boolean isModularProject = JavaRuntime.isModularProject((IJavaProject)this.getJavaProject(configuration));
        String addOpensTargets = isModularProject ? (JUnitPluginLaunchConfigurationDelegate.getJUnitVersion(configuration) == JUnitTestPlugin.JUnitVersion.JUNIT5 ? (JUnitPluginLaunchConfigurationDelegate.isOnModulePath(this.getJavaProject(configuration), "org.junit.jupiter.api.Test") ? "junit-platform-commons,ALL-UNNAMED" : "ALL-UNNAMED") : (JUnitPluginLaunchConfigurationDelegate.isOnModulePath(this.getJavaProject(configuration), "junit.framework.TestCase") ? "junit,ALL-UNNAMED" : "ALL-UNNAMED")) : null;
        ArrayList<String> addOpensVmArgs = new ArrayList<String>();
        programArguments.add("-version");
        programArguments.add("3");
        programArguments.add("-port");
        programArguments.add(String.valueOf(this.fPort));
        if (this.fKeepAlive) {
            programArguments.add(0, "-keepalive");
        }
        ITestKind testRunnerKind = JUnitPluginLaunchConfigurationDelegate.getJUnitVersion(configuration).getJUnitTestKind();
        programArguments.add("-testLoaderClass");
        programArguments.add(testRunnerKind.getLoaderClassName());
        programArguments.add("-loaderpluginname");
        programArguments.add(testRunnerKind.getLoaderPluginId());
        IJavaElement[] testElements = this.fTestElements;
        if (testElements.length == 1) {
            IJavaElement testElement = testElements[0];
            if (testElement instanceof IMethod) {
                IMethod method = (IMethod)testElement;
                programArguments.add("-test");
                programArguments.add(method.getDeclaringType().getFullyQualifiedName() + ":" + method.getElementName());
                this.collectAddOpensVmArgs(addOpensTargets, addOpensVmArgs, (IJavaElement)method, configuration);
            } else if (testElement instanceof IType) {
                IType type = (IType)testElement;
                programArguments.add("-classNames");
                programArguments.add(type.getFullyQualifiedName());
                this.collectAddOpensVmArgs(addOpensTargets, addOpensVmArgs, (IJavaElement)type, configuration);
            } else if (testElement instanceof IPackageFragment || testElement instanceof IPackageFragmentRoot || testElement instanceof IJavaProject) {
                HashSet<String> pkgNames = new HashSet<String>();
                fileName = this.createPackageNamesFile(testElement, testRunnerKind, pkgNames);
                programArguments.add("-packageNameFile");
                programArguments.add((String)fileName);
                for (String pkgName : pkgNames) {
                    if (DEFAULT.equals(pkgName)) continue;
                    this.collectAddOpensVmArgs(addOpensTargets, addOpensVmArgs, pkgName, configuration);
                }
            } else {
                this.abort(Messages.JUnitPluginLaunchConfigurationDelegate_error_wrong_input, null, 101);
            }
        } else if (testElements.length > 1) {
            String fileName = this.createTestNamesFile(testElements);
            programArguments.add("-testNameFile");
            programArguments.add(fileName);
            fileName = testElements;
            int pkgNames = testElements.length;
            int type = 0;
            while (type < pkgNames) {
                IJavaElement testElement = fileName[type];
                this.collectAddOpensVmArgs(addOpensTargets, addOpensVmArgs, testElement, configuration);
                ++type;
            }
        }
        String testFailureNames = configuration.getAttribute("org.eclipse.jdt.junit.FAILURENAMES", "");
        if (testFailureNames.length() > 0) {
            programArguments.add("-testfailures");
            programArguments.add(testFailureNames);
        }
        if (!(uniqueId = configuration.getAttribute("org.eclipse.jdt.junit.TEST_UNIQUE_ID", "")).trim().isEmpty()) {
            programArguments.add("-uniqueId");
            programArguments.add(uniqueId);
        }
        if ((hasIncludeTags = configuration.getAttribute("org.eclipse.jdt.junit.HAS_INCLUDE_TAGS", false)) && (includeTags = configuration.getAttribute("org.eclipse.jdt.junit.INCLUDE_TAGS", "")) != null && !includeTags.trim().isEmpty()) {
            String[] tags;
            String[] stringArray = tags = includeTags.split(",");
            n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                programArguments.add("--include-tag");
                programArguments.add(tag.trim());
                ++n2;
            }
        }
        if ((hasExcludeTags = configuration.getAttribute("org.eclipse.jdt.junit.HAS_EXCLUDE_TAGS", false)) && (excludeTags = configuration.getAttribute("org.eclipse.jdt.junit.EXCLUDE_TAGS", "")) != null && !excludeTags.trim().isEmpty()) {
            String[] tags;
            String[] stringArray = tags = excludeTags.split(",");
            int n3 = tags.length;
            n = 0;
            while (n < n3) {
                String tag = stringArray[n];
                programArguments.add("--exclude-tag");
                programArguments.add(tag.trim());
                ++n;
            }
        }
        if (addOpensTargets != null) {
            vmArguments.addAll(addOpensVmArgs);
        }
    }

    private static boolean isOnModulePath(IJavaProject javaProject, String typeToCheck) {
        IType type;
        block3: {
            try {
                type = javaProject.findType(typeToCheck);
                if (type != null) break block3;
                return false;
            }
            catch (JavaModelException e) {
                return true;
            }
        }
        IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        IClasspathEntry resolvedClasspathEntry = packageFragmentRoot.getResolvedClasspathEntry();
        return Arrays.stream(resolvedClasspathEntry.getExtraAttributes()).anyMatch(p -> p.getName().equals("module") && p.getValue().equals("true"));
    }

    private void collectAddOpensVmArgs(String addOpensTargets, List<String> addOpensVmArgs, IJavaElement javaElem, ILaunchConfiguration configuration) throws CoreException {
        IPackageFragment pkg;
        if (addOpensTargets != null && (pkg = this.getParentPackageFragment(javaElem)) != null) {
            String pkgName = pkg.getElementName();
            this.collectAddOpensVmArgs(addOpensTargets, addOpensVmArgs, pkgName, configuration);
        }
    }

    private void collectAddOpensVmArgs(String addOpensTargets, List<String> addOpensVmArgs, String pkgName, ILaunchConfiguration configuration) throws CoreException {
        if (addOpensTargets != null) {
            IJavaProject javaProject = this.getJavaProject(configuration);
            String sourceModuleName = javaProject.getModuleDescription().getElementName();
            addOpensVmArgs.add("--add-opens");
            addOpensVmArgs.add(sourceModuleName + "/" + pkgName + "=" + addOpensTargets);
        }
    }

    private IPackageFragment getParentPackageFragment(IJavaElement element) {
        IJavaElement parent = element.getParent();
        while (parent != null) {
            if (parent instanceof IPackageFragment) {
                return (IPackageFragment)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private String createPackageNamesFile(IJavaElement testContainer, ITestKind testRunnerKind, Set<String> pkgNames) throws CoreException {
        try {
            File file = File.createTempFile("packageNames", ".txt");
            file.deleteOnExit();
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                if (testContainer instanceof IPackageFragment) {
                    pkgNames.add(this.getPackageName(testContainer.getElementName()));
                } else if (testContainer instanceof IPackageFragmentRoot) {
                    this.addAllPackageFragments((IPackageFragmentRoot)testContainer, pkgNames);
                } else if (testContainer instanceof IJavaProject) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = ((IJavaProject)testContainer).getPackageFragmentRoots();
                    int n = iPackageFragmentRootArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot pkgFragmentRoot = iPackageFragmentRootArray[n2];
                        if (!pkgFragmentRoot.isExternal() && !pkgFragmentRoot.isArchive()) {
                            this.addAllPackageFragments(pkgFragmentRoot, pkgNames);
                        }
                        ++n2;
                    }
                } else {
                    this.abort(Messages.JUnitPluginLaunchConfigurationDelegate_error_wrong_input, null, 101);
                }
                if (pkgNames.isEmpty()) {
                    String msg = MessageFormat.format(Messages.JUnitPluginLaunchConfigurationDelegate_error_notests_kind, testRunnerKind.getDisplayName());
                    this.abort(msg, null, 101);
                } else {
                    for (String pkgName : pkgNames) {
                        bw.write(pkgName);
                        bw.newLine();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return file.getAbsolutePath();
        }
        catch (IOException | JavaModelException e) {
            throw new CoreException(Status.error((String)"", (Throwable)e));
        }
    }

    private Set<String> addAllPackageFragments(IPackageFragmentRoot pkgFragmentRoot, Set<String> pkgNames) throws JavaModelException {
        IJavaElement[] iJavaElementArray = pkgFragmentRoot.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (child instanceof IPackageFragment && ((IPackageFragment)child).hasChildren()) {
                pkgNames.add(this.getPackageName(child.getElementName()));
            }
            ++n2;
        }
        return pkgNames;
    }

    private String getPackageName(String elementName) {
        if (elementName.isEmpty()) {
            return DEFAULT;
        }
        return elementName;
    }

    private String createTestNamesFile(IJavaElement[] testElements) throws CoreException {
        try {
            File file = File.createTempFile("testNames", ".txt");
            file.deleteOnExit();
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                IJavaElement[] iJavaElementArray = testElements;
                int n = testElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement testElement = iJavaElementArray[n2];
                    if (testElement instanceof IType) {
                        IType type = (IType)testElement;
                        String testName = type.getFullyQualifiedName();
                        bw.write(testName);
                        bw.newLine();
                    } else {
                        this.abort(Messages.JUnitPluginLaunchConfigurationDelegate_error_wrong_input, null, 101);
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)"", (Throwable)e));
        }
    }

    public String[][] getClasspathAndModulepath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = LaunchArgumentsHelper.constructClasspath((ILaunchConfiguration)configuration);
        if (classpath == null) {
            this.abort(Messages.JUnitPluginLaunchConfigurationDelegate_error_noStartup, null, 0);
        }
        String[][] cpmp = this.internalGetClasspathAndModulepath(configuration);
        cpmp[0] = classpath;
        return cpmp;
    }

    public String[][] internalGetClasspathAndModulepath(ILaunchConfiguration configuration) throws CoreException {
        String[][] cpmp = super.getClasspathAndModulepath(configuration);
        String[] cp = cpmp[0];
        List<String> junitEntries = new ClasspathLocalizer(Platform.inDevelopmentMode()).localizeClasspath(JUnitPluginLaunchConfigurationDelegate.getJUnitVersion(configuration));
        String[] classPath = new String[cp.length + junitEntries.size()];
        Object[] jea = junitEntries.toArray();
        System.arraycopy(cp, 0, classPath, 0, cp.length);
        System.arraycopy(jea, 0, classPath, cp.length, jea.length);
        cpmp[0] = classPath;
        return cpmp;
    }

    private final IJavaElement getTestTarget(ILaunchConfiguration configuration, IJavaProject javaProject) throws CoreException {
        IType type;
        String containerHandle = configuration.getAttribute("org.eclipse.jdt.junit.CONTAINER", "");
        if (containerHandle.length() != 0) {
            IJavaElement element = JavaCore.create((String)containerHandle);
            if (element == null || !element.exists()) {
                this.abort(Messages.JUnitPluginLaunchConfigurationDelegate_error_input_element_deosn_not_exist, null, 101);
            }
            return element;
        }
        String testTypeName = this.getMainTypeName(configuration);
        if (testTypeName != null && testTypeName.length() != 0 && (type = javaProject.findType(testTypeName)) != null && type.exists()) {
            return type;
        }
        this.abort(Messages.JUnitPluginLaunchConfigurationDelegate_input_type_does_not_exist, null, 101);
        return null;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.unittest.junit", code, message, exception));
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IVMInstall launcher = VMHelper.createLauncher((ILaunchConfiguration)configuration, this.fModels.keySet());
        return launcher.getVMRunner(mode);
    }

    private String getTestPluginId(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        IPluginModelBase model = PluginRegistry.findModel((IProject)javaProject.getProject());
        if (model == null) {
            this.abort(NLS.bind((String)Messages.JUnitPluginLaunchConfigurationDelegate_error_notaplugin, (Object)javaProject.getProject().getName()), null, 0);
            return null;
        }
        if (model instanceof IFragmentModel) {
            return ((IFragmentModel)model).getFragment().getPluginId();
        }
        return model.getPluginBase().getId();
    }

    public String getModuleCLIOptions(ILaunchConfiguration configuration) throws CoreException {
        return "";
    }

    protected String getApplication(ILaunchConfiguration configuration) {
        String application = null;
        boolean shouldRunInUIThread = true;
        try {
            shouldRunInUIThread = configuration.getAttribute("run_in_ui_thread", true);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (!shouldRunInUIThread) {
            return "org.eclipse.pde.junit.runtime.nonuithreadtestapplication";
        }
        try {
            application = configuration.getAttribute("application", null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (application == null) {
            application = "org.eclipse.pde.junit.runtime.uitestapplication";
        }
        return application;
    }

    private IPluginModelBase findRequiredPluginInTargetOrHost(String id) throws CoreException {
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model == null || !model.getBundleDescription().isResolved()) {
            model = PDECore.getDefault().findPluginInHost(id);
        }
        if (model == null) {
            this.abort(NLS.bind((String)Messages.JUnitPluginLaunchConfigurationDelegate_error_missingPlugin, (Object)id), null, 0);
        }
        return model;
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getUserProgramArguments((ILaunchConfiguration)configuration);
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String vmArgs = LaunchArgumentsHelper.getUserVMArguments((ILaunchConfiguration)configuration);
        vmArgs = this.concatArg(vmArgs, "-Declipse.pde.launch=true");
        if (this.fAllBundles.containsKey("org.eclipse.equinox.p2.core") && !vmArgs.contains("-Declipse.p2.data.area=")) {
            vmArgs = this.concatArg(vmArgs, "-Declipse.p2.data.area=@config.dir" + File.separator + "p2");
        }
        return vmArgs;
    }

    private String concatArg(String vmArgs, String arg) {
        if (vmArgs.length() > 0 && !vmArgs.endsWith(" ")) {
            vmArgs = vmArgs.concat(" ");
        }
        return vmArgs.concat(arg);
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    @Deprecated
    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = LaunchArgumentsHelper.constructClasspath((ILaunchConfiguration)configuration);
        if (classpath == null) {
            this.abort(Messages.JUnitPluginLaunchConfigurationDelegate_error_noStartup, null, 0);
        }
        return classpath;
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getWorkingDirectory((ILaunchConfiguration)configuration);
    }

    public Map<String, Object> getVMSpecificAttributesMap(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getVMSpecificAttributesMap((ILaunchConfiguration)configuration, this.fModels.keySet());
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        String id = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        if (!"org.eclipse.pde.ui.workbenchClasspathProvider".equals(id)) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
            wc.doSave();
        }
        this.manageLaunch(launch);
    }

    protected File getConfigurationDirectory(ILaunchConfiguration configuration) {
        if (this.fConfigDir == null) {
            this.fConfigDir = LaunchConfigurationHelper.getConfigurationArea((ILaunchConfiguration)configuration);
        }
        return this.fConfigDir;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.computeBuildOrder(LaunchPluginValidator.getAffectedProjects((ILaunchConfiguration)configuration));
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return LaunchPluginValidator.getAffectedProjects((ILaunchConfiguration)configuration);
    }

    protected void manageLaunch(ILaunch launch) {
    }

    protected void synchronizeManifests(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        LaunchConfigurationHelper.synchronizeManifests((ILaunchConfiguration)configuration, (File)this.getConfigurationDirectory(configuration));
        monitor.done();
    }

    protected void clear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (this.fWorkspaceLocation == null) {
            this.fWorkspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation((ILaunchConfiguration)configuration);
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        LauncherUtils.clearWorkspace((ILaunchConfiguration)configuration, (String)this.fWorkspaceLocation, (String)this.launchMode, (IProgressMonitor)subMon.split(25));
        subMon.setWorkRemaining(25);
        if (configuration.getAttribute("clearConfig", false)) {
            CoreUtility.deleteContent((File)this.getConfigurationDirectory(configuration), (IProgressMonitor)subMon.split(25));
        }
        subMon.done();
    }

    protected void validateProjectDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        LauncherUtils.validateProjectDependencies((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
    }

    protected void validatePluginDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        EclipsePluginValidationOperation op = new EclipsePluginValidationOperation(configuration, this.fModels.keySet(), this.launchMode);
        LaunchPluginValidator.runValidationOperation((LaunchValidationOperation)op, (IProgressMonitor)monitor);
    }

    private static class ClasspathLocalizer {
        private final boolean fInDevelopmentMode;

        public ClasspathLocalizer(boolean inDevelopmentMode) {
            this.fInDevelopmentMode = inDevelopmentMode;
        }

        public List<String> localizeClasspath(JUnitTestPlugin.JUnitVersion junitVersion) {
            JUnitRuntimeClasspathEntry[] entries = junitVersion.getJUnitTestKind().getClasspathEntries();
            ArrayList<String> junitEntries = new ArrayList<String>();
            JUnitRuntimeClasspathEntry[] jUnitRuntimeClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                JUnitRuntimeClasspathEntry entrie = jUnitRuntimeClasspathEntryArray[n2];
                try {
                    this.addEntry(junitEntries, entrie);
                }
                catch (IOException | URISyntaxException e) {
                    Assert.isTrue((boolean)false, (String)(entrie.getPluginId() + " is available (required JAR)"));
                }
                ++n2;
            }
            return junitEntries;
        }

        private void addEntry(List<String> junitEntries, JUnitRuntimeClasspathEntry entry) throws IOException, MalformedURLException, URISyntaxException {
            String entryString = this.entryString(entry);
            if (entryString != null) {
                junitEntries.add(entryString);
            }
        }

        private String entryString(JUnitRuntimeClasspathEntry entry) throws IOException, MalformedURLException, URISyntaxException {
            if (this.inDevelopmentMode()) {
                try {
                    return this.localURL(entry.developmentModeEntry());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.localURL(entry);
        }

        private boolean inDevelopmentMode() {
            return this.fInDevelopmentMode;
        }

        private String localURL(JUnitRuntimeClasspathEntry jar) throws IOException, MalformedURLException, URISyntaxException {
            URL url;
            Bundle bundle = JUnitPluginTestPlugin.getDefault().getBundle(jar.getPluginId());
            if (jar.getPluginRelativePath() == null) {
                String bundleClassPath = (String)bundle.getHeaders().get("Bundle-ClassPath");
                URL uRL = url = bundleClassPath != null ? bundle.getEntry(bundleClassPath) : null;
                if (url == null) {
                    url = bundle.getEntry("/");
                }
            } else {
                url = bundle.getEntry(jar.getPluginRelativePath());
            }
            if (url == null) {
                throw new IOException();
            }
            return URIUtil.toFile((URI)URIUtil.toURI((URL)FileLocator.toFileURL((URL)url))).getAbsolutePath();
        }
    }
}

