/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import java.util.Arrays;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservablesManagerTest
extends AbstractDefaultRealmTestCase {
    private DataBindingContext dbc;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dbc = new DataBindingContext();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        super.tearDown();
    }

    @Test
    public void testOnlyModelIsDisposed() throws Exception {
        WritableValue targetOv = new WritableValue();
        WritableValue modelOv = new WritableValue();
        this.dbc.bindValue((IObservableValue)targetOv, (IObservableValue)modelOv);
        ObservablesManager observablesManager = new ObservablesManager();
        observablesManager.addObservablesFromContext(this.dbc, false, true);
        observablesManager.dispose();
        Assert.assertFalse((boolean)targetOv.isDisposed());
        Assert.assertTrue((boolean)modelOv.isDisposed());
    }

    @Test
    public void testOnlyTargetIsDisposed() throws Exception {
        WritableValue targetOv = new WritableValue();
        WritableValue modelOv = new WritableValue();
        this.dbc.bindValue((IObservableValue)targetOv, (IObservableValue)modelOv);
        ObservablesManager observablesManager = new ObservablesManager();
        observablesManager.addObservablesFromContext(this.dbc, true, false);
        observablesManager.dispose();
        Assert.assertTrue((boolean)targetOv.isDisposed());
        Assert.assertFalse((boolean)modelOv.isDisposed());
    }

    @Test
    public void testContextIsDisposed() {
        WritableValue targetOv = new WritableValue();
        WritableValue modelOv = new WritableValue();
        this.dbc.bindValue((IObservableValue)targetOv, (IObservableValue)modelOv);
        Binding dummyProvider = this.createDummyBinding((IObservableList<IObservable>)Observables.emptyObservableList(), (IObservableList<IObservable>)Observables.emptyObservableList());
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)dummyProvider);
        ObservablesManager observablesManager = new ObservablesManager();
        observablesManager.addContext(this.dbc, true, false);
        observablesManager.dispose();
        Assert.assertTrue((boolean)dummyProvider.isDisposed());
        Assert.assertTrue((boolean)targetOv.isDisposed());
        Assert.assertFalse((boolean)modelOv.isDisposed());
    }

    @Test
    public void testContextIsNotDisposed() {
        WritableValue targetOv = new WritableValue();
        WritableValue modelOv = new WritableValue();
        this.dbc.bindValue((IObservableValue)targetOv, (IObservableValue)modelOv);
        Binding dummyProvider = this.createDummyBinding((IObservableList<IObservable>)Observables.emptyObservableList(), (IObservableList<IObservable>)Observables.emptyObservableList());
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)dummyProvider);
        ObservablesManager observablesManager = new ObservablesManager();
        observablesManager.addObservablesFromContext(this.dbc, true, true);
        observablesManager.dispose();
        Assert.assertFalse((boolean)dummyProvider.isDisposed());
    }

    @Test
    public void testTargetAndModelIsDisposed() throws Exception {
        WritableValue targetOv = new WritableValue();
        WritableValue modelOv = new WritableValue();
        this.dbc.bindValue((IObservableValue)targetOv, (IObservableValue)modelOv);
        ObservablesManager observablesManager = new ObservablesManager();
        observablesManager.addObservablesFromContext(this.dbc, true, true);
        observablesManager.dispose();
        Assert.assertTrue((boolean)targetOv.isDisposed());
        Assert.assertTrue((boolean)modelOv.isDisposed());
    }

    @Test
    public void testDispose_Bug277966_NPEWhenManagedObservableAlreadyDisposed() {
        ObservablesManager manager = new ObservablesManager();
        WritableList observable = new WritableList();
        manager.addObservable((IObservable)observable);
        observable.dispose();
        manager.dispose();
    }

    @Test
    public void testDisposeMultipleTargets_Bug546983() {
        DataBindingContext context = new DataBindingContext();
        WritableList targets = new WritableList(Arrays.asList(new WritableValue(), new WritableValue()), WritableValue.class);
        WritableList models = new WritableList(Arrays.asList(new WritableValue(), new WritableValue()), WritableValue.class);
        context.addBinding(this.createDummyBinding((IObservableList<IObservable>)targets, (IObservableList<IObservable>)models));
        ObservablesManager manager = new ObservablesManager();
        manager.addObservablesFromContext(context, true, true);
        manager.dispose();
        Assert.assertTrue((boolean)((IObservable)targets.get(0)).isDisposed());
        Assert.assertTrue((boolean)((IObservable)targets.get(1)).isDisposed());
        Assert.assertTrue((boolean)((IObservable)models.get(0)).isDisposed());
        Assert.assertTrue((boolean)((IObservable)models.get(1)).isDisposed());
    }

    private Binding createDummyBinding(final IObservableList<IObservable> targets, final IObservableList<IObservable> models) {
        return new Binding((IObservable)new WritableValue(), (IObservable)new WritableValue()){

            public IObservableList<IObservable> getTargets() {
                return targets;
            }

            public IObservableList<IObservable> getModels() {
                return models;
            }

            public IObservableValue<IStatus> getValidationStatus() {
                return Observables.constantObservableValue((Object)Status.OK_STATUS);
            }

            public void validateTargetToModel() {
            }

            public void validateModelToTarget() {
            }

            public void updateTargetToModel() {
            }

            public void updateModelToTarget() {
            }

            protected void preInit() {
            }

            protected void postInit() {
            }
        };
    }
}

