/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffect;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SideEffectTest
extends AbstractDefaultRealmTestCase {
    private ISideEffect sideEffect;
    private int sideEffectInvocations;
    private WritableValue<String> defaultDependency;
    private WritableValue<String> alternateDependency;
    private WritableValue<Boolean> useDefaultDependency;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.defaultDependency = new WritableValue((Object)"", null);
        this.alternateDependency = new WritableValue((Object)"", null);
        this.useDefaultDependency = new WritableValue((Object)true, null);
        this.sideEffect = ISideEffect.createPaused(() -> {
            if (((Boolean)this.useDefaultDependency.getValue()).booleanValue()) {
                this.defaultDependency.getValue();
            } else {
                this.alternateDependency.getValue();
            }
            ++this.sideEffectInvocations;
        });
    }

    @Test
    public void testSideEffectDoesntRunUntilResumed() throws Exception {
        this.runAsync();
        Assert.assertEquals((long)0L, (long)this.sideEffectInvocations);
    }

    @Test
    public void testSideEffectRunsWhenResumed() throws Exception {
        this.sideEffect.resume();
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
    }

    @Test(expected=IllegalStateException.class)
    public void testResumingSideEffectMultipleTimesThrowsIllegalStateException() throws Exception {
        this.sideEffect.resume();
        this.sideEffect.resume();
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
    }

    @Test
    public void testSideEffectSelectsCorrectDependency() throws Exception {
        this.sideEffect.resume();
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
        this.defaultDependency.setValue((Object)"foo");
        this.runAsync();
        Assert.assertEquals((long)2L, (long)this.sideEffectInvocations);
        this.alternateDependency.setValue((Object)"foo");
        this.runAsync();
        Assert.assertEquals((long)2L, (long)this.sideEffectInvocations);
        this.useDefaultDependency.setValue((Object)false);
        this.runAsync();
        Assert.assertEquals((long)3L, (long)this.sideEffectInvocations);
        this.defaultDependency.setValue((Object)"bar");
        this.runAsync();
        Assert.assertEquals((long)3L, (long)this.sideEffectInvocations);
        this.alternateDependency.setValue((Object)"bar");
        this.runAsync();
        Assert.assertEquals((long)4L, (long)this.sideEffectInvocations);
    }

    @Test
    public void testChangingMultipleDependenciesOnlyRunsTheSideEffectOnce() throws Exception {
        this.sideEffect.resume();
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
        this.defaultDependency.setValue((Object)"Foo");
        this.alternateDependency.setValue((Object)"Foo");
        this.useDefaultDependency.setValue((Object)false);
        this.runAsync();
        Assert.assertEquals((long)2L, (long)this.sideEffectInvocations);
    }

    @Test
    public void testChangingDependencyRerunsSideEffect() throws Exception {
        this.sideEffect.resume();
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
        this.defaultDependency.setValue((Object)"Foo");
        this.runAsync();
        Assert.assertEquals((long)2L, (long)this.sideEffectInvocations);
    }

    @Test
    public void testChangingUnrelatedNodeDoesntRunSideEffect() throws Exception {
        this.sideEffect.resume();
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
        this.alternateDependency.setValue((Object)"Bar");
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
    }

    @Test
    public void testDeactivatedSideEffectWontRunWhenTriggeredByDependency() throws Exception {
        this.sideEffect.resume();
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
        this.defaultDependency.setValue((Object)"Foo");
        this.sideEffect.dispose();
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
    }

    @Test
    public void testDeactivatedSideEffectWontRunWhenRunIfDirtyInvoked() throws Exception {
        this.sideEffect.resume();
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
        this.sideEffect.pause();
        this.defaultDependency.setValue((Object)"MakeItDirty");
        this.sideEffect.runIfDirty();
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
    }

    @Test
    public void testRunIfDirtyDoesNothingIfSideEffectNotDirty() throws Exception {
        this.sideEffect.resume();
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
        this.sideEffect.runIfDirty();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
    }

    @Test
    public void testRunIfDirty() throws Exception {
        this.sideEffect.resume();
        this.runAsync();
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
        this.defaultDependency.setValue((Object)"Foo");
        this.sideEffect.runIfDirty();
        Assert.assertEquals((long)2L, (long)this.sideEffectInvocations);
    }

    @Test
    public void testNestedDependencyChangeAndRunIfDirtyCompletes() throws Exception {
        AtomicBoolean hasRun = new AtomicBoolean();
        WritableValue invalidator = new WritableValue(new Object(), null);
        ISideEffect innerSideEffect = ISideEffect.create(() -> invalidator.getValue());
        ISideEffect.createPaused(() -> {
            Assert.assertFalse((boolean)hasRun.get());
            hasRun.set(true);
            invalidator.setValue(new Object());
            innerSideEffect.runIfDirty();
        }).resume();
        this.runAsync();
        Assert.assertTrue((boolean)hasRun.get());
    }

    @Test
    public void testNestedInvalidateAndRunIfDirtyCompletes() throws Exception {
        AtomicBoolean hasRun = new AtomicBoolean();
        WritableValue makesThingsDirty = new WritableValue(null, null);
        ISideEffect innerSideEffect = ISideEffect.createPaused(() -> makesThingsDirty.getValue());
        innerSideEffect.resume();
        ISideEffect.createPaused(() -> {
            Assert.assertFalse((boolean)hasRun.get());
            hasRun.set(true);
            makesThingsDirty.setValue(new Object());
            innerSideEffect.runIfDirty();
        }).resume();
        this.runAsync();
        Assert.assertTrue((boolean)hasRun.get());
    }

    @Test
    public void testConsumeOnceDoesntPassNullToConsumer() throws Exception {
        AtomicBoolean consumerHasRun = new AtomicBoolean();
        final WritableValue makesThingsDirty = new WritableValue(null, null);
        ComputedValue<Object> value = new ComputedValue<Object>(){

            protected Object calculate() {
                makesThingsDirty.getValue();
                return null;
            }
        };
        ISideEffect consumeOnce = ISideEffect.consumeOnceAsync(() -> ((ComputedValue)value).getValue(), Object2 -> consumerHasRun.set(true));
        makesThingsDirty.setValue(new Object());
        this.runAsync();
        makesThingsDirty.setValue(new Object());
        this.runAsync();
        Assert.assertFalse((boolean)consumerHasRun.get());
        consumeOnce.dispose();
    }

    @Test
    public void testConsumeOnceDoesntRunTwice() throws Exception {
        AtomicInteger numberOfRuns = new AtomicInteger();
        final WritableValue makesThingsDirty = new WritableValue(null, null);
        final WritableValue returnValue = new WritableValue(null, null);
        ComputedValue<Object> value = new ComputedValue<Object>(){

            protected Object calculate() {
                makesThingsDirty.getValue();
                return returnValue.getValue();
            }
        };
        ISideEffect consumeOnce = ISideEffect.consumeOnceAsync(() -> ((ComputedValue)value).getValue(), Object2 -> numberOfRuns.set(numberOfRuns.get() + 1));
        makesThingsDirty.setValue(new Object());
        this.runAsync();
        Assert.assertEquals((long)0L, (long)numberOfRuns.get());
        returnValue.setValue((Object)"Foo");
        this.runAsync();
        Assert.assertEquals((long)1L, (long)numberOfRuns.get());
        returnValue.setValue((Object)"Bar");
        this.runAsync();
        Assert.assertEquals((long)1L, (long)numberOfRuns.get());
        consumeOnce.dispose();
    }

    @Test
    public void testConsumeOnceDoesntRunAtAllIfDisposed() throws Exception {
        AtomicInteger numberOfRuns = new AtomicInteger();
        WritableValue returnValue = new WritableValue((Object)"foo", null);
        ISideEffect consumeOnce = ISideEffect.consumeOnceAsync(() -> ((WritableValue)returnValue).getValue(), Object2 -> numberOfRuns.set(numberOfRuns.get() + 1));
        consumeOnce.dispose();
        this.runAsync();
        Assert.assertEquals((long)0L, (long)numberOfRuns.get());
    }

    @Test
    public void testConsumeOnceRunsIfInitialValueNonNull() throws Exception {
        AtomicInteger numberOfRuns = new AtomicInteger();
        WritableValue returnValue = new WritableValue((Object)"foo", null);
        ISideEffect consumeOnce = ISideEffect.consumeOnceAsync(() -> ((WritableValue)returnValue).getValue(), Object2 -> numberOfRuns.set(numberOfRuns.get() + 1));
        this.runAsync();
        Assert.assertEquals((long)1L, (long)numberOfRuns.get());
        consumeOnce.dispose();
    }

    @Test
    public void testNestedSideEffectCreation() throws Exception {
        AtomicBoolean hasRun = new AtomicBoolean();
        ISideEffect.createPaused(() -> ISideEffect.createPaused(() -> {
            Assert.assertFalse((boolean)hasRun.get());
            hasRun.set(true);
        }).resume()).resume();
        this.runAsync();
        Assert.assertTrue((boolean)hasRun.get());
    }

    @Test
    public void testSideEffectFiresDisposeEvent() throws Exception {
        AtomicBoolean hasRun = new AtomicBoolean();
        ISideEffect disposeTest = ISideEffect.createPaused(() -> {});
        disposeTest.resume();
        disposeTest.addDisposeListener(sideEffect -> {
            Assert.assertTrue((disposeTest == sideEffect ? 1 : 0) != 0);
            hasRun.set(true);
        });
        disposeTest.dispose();
        this.runAsync();
        Assert.assertTrue((boolean)hasRun.get());
    }

    @Test
    public void testCanRemoveDisposeListener() throws Exception {
        AtomicBoolean hasRun = new AtomicBoolean();
        ISideEffect disposeTest = ISideEffect.createPaused(() -> {});
        disposeTest.resume();
        Consumer<ISideEffect> disposeListener = sideEffect -> hasRun.set(true);
        disposeTest.addDisposeListener(disposeListener);
        disposeTest.removeDisposeListener(disposeListener);
        disposeTest.dispose();
        this.runAsync();
        Assert.assertFalse((boolean)hasRun.get());
    }

    @Test
    public void testObservableInMap() {
        HashMap<String, WritableValue> hashMap = new HashMap<String, WritableValue>();
        WritableValue observableValue = new WritableValue();
        observableValue.setValue((Object)"Simon");
        hashMap.put("Simon", observableValue);
        ISideEffect.create(() -> {
            IObservableValue observable = (IObservableValue)hashMap.get("Simon");
            observable.getValue();
            ++this.sideEffectInvocations;
        });
        Assert.assertEquals((long)1L, (long)this.sideEffectInvocations);
        observableValue.setValue((Object)"Stefan");
        this.runAsync();
        Assert.assertEquals((long)2L, (long)this.sideEffectInvocations);
    }
}

