/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.internal.databinding.conversion.IdentityConverter;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class UpdateListStrategyTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testFillDefaults_AssertSourceTypeExtendsConverterFromType() {
        UpdateListStrategyStub strategy = new UpdateListStrategyStub();
        strategy.setConverter((IConverter)new IdentityConverter(Object.class, Object.class));
        strategy.fillDefaults(WritableList.withElementType(String.class), WritableList.withElementType(Object.class));
        UpdateListStrategyStub strategy2 = new UpdateListStrategyStub();
        strategy2.setConverter((IConverter)new IdentityConverter(String.class, Object.class));
        Assert.assertThrows((String)"Expected BindingException since Object does not extend String", BindingException.class, () -> strategy2.fillDefaults(WritableList.withElementType(Object.class), WritableList.withElementType(Object.class)));
    }

    @Test
    public void testFillDefaults_AssertConverterToTypeExtendsDestinationType() {
        UpdateListStrategyStub strategy = new UpdateListStrategyStub();
        strategy.setConverter((IConverter)new IdentityConverter(Object.class, String.class));
        strategy.fillDefaults(WritableList.withElementType(Object.class), WritableList.withElementType(Object.class));
        UpdateListStrategyStub strategy2 = new UpdateListStrategyStub();
        strategy2.setConverter((IConverter)new IdentityConverter(Object.class, Object.class));
        Assert.assertThrows((String)"Expected BindingException since Object does not extend String", BindingException.class, () -> strategy2.fillDefaults(WritableList.withElementType(Object.class), WritableList.withElementType(String.class)));
    }

    class UpdateListStrategyStub<S, D>
    extends UpdateListStrategy<S, D> {
        UpdateListStrategyStub() {
        }

        protected void fillDefaults(IObservableList<? extends S> source, IObservableList<? super D> destination) {
            super.fillDefaults(source, destination);
        }
    }
}

