/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.internal.databinding.conversion.IdentityConverter;
import org.eclipse.core.internal.databinding.validation.NumberToByteValidator;
import org.eclipse.core.internal.databinding.validation.NumberToDoubleValidator;
import org.eclipse.core.internal.databinding.validation.NumberToFloatValidator;
import org.eclipse.core.internal.databinding.validation.NumberToIntegerValidator;
import org.eclipse.core.internal.databinding.validation.NumberToLongValidator;
import org.eclipse.core.internal.databinding.validation.NumberToShortValidator;
import org.eclipse.core.internal.databinding.validation.NumberToUnboundedNumberValidator;
import org.eclipse.core.internal.databinding.validation.StringToByteValidator;
import org.eclipse.core.internal.databinding.validation.StringToDateValidator;
import org.eclipse.core.internal.databinding.validation.StringToDoubleValidator;
import org.eclipse.core.internal.databinding.validation.StringToFloatValidator;
import org.eclipse.core.internal.databinding.validation.StringToIntegerValidator;
import org.eclipse.core.internal.databinding.validation.StringToLongValidator;
import org.eclipse.core.internal.databinding.validation.StringToShortValidator;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class UpdateValueStrategyTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testDefaultValidatorForStringToInteger() throws Exception {
        this.assertDefaultValidator(String.class, Integer.class, StringToIntegerValidator.class);
    }

    @Test
    public void testDefaultValidatorForStringToIntegerPrimitive() throws Exception {
        this.assertDefaultValidator(String.class, Integer.TYPE, StringToIntegerValidator.class);
    }

    @Test
    public void testDefaultValidatorForStringToLong() throws Exception {
        this.assertDefaultValidator(String.class, Long.class, StringToLongValidator.class);
    }

    @Test
    public void testDefaultValidatorForStringToLongPrimitive() throws Exception {
        this.assertDefaultValidator(String.class, Long.TYPE, StringToLongValidator.class);
    }

    @Test
    public void testDefaultValidatorForStringToFloat() throws Exception {
        this.assertDefaultValidator(String.class, Float.class, StringToFloatValidator.class);
    }

    @Test
    public void testDefaultValidatorForStringToFloatPrimitive() throws Exception {
        this.assertDefaultValidator(String.class, Float.TYPE, StringToFloatValidator.class);
    }

    @Test
    public void testDefaultValidatorForStringToDouble() throws Exception {
        this.assertDefaultValidator(String.class, Double.class, StringToDoubleValidator.class);
    }

    @Test
    public void testDefaultValidatorForStringToDoublePrimitive() throws Exception {
        this.assertDefaultValidator(String.class, Double.TYPE, StringToDoubleValidator.class);
    }

    @Test
    public void testDefaultValidatorForStringToByte() throws Exception {
        this.assertDefaultValidator(String.class, Byte.class, StringToByteValidator.class);
    }

    @Test
    public void testDefaultValidatorForStringToBytePrimitive() throws Exception {
        this.assertDefaultValidator(String.class, Byte.TYPE, StringToByteValidator.class);
    }

    @Test
    public void testDefaultValidatorForStringToShort() throws Exception {
        this.assertDefaultValidator(String.class, Short.class, StringToShortValidator.class);
    }

    @Test
    public void testDefaultValidatorForStringToShortPrimitive() throws Exception {
        this.assertDefaultValidator(String.class, Short.TYPE, StringToShortValidator.class);
    }

    @Test
    public void testDefaultValidatorForStringToDate() throws Exception {
        this.assertDefaultValidator(String.class, Date.class, StringToDateValidator.class);
    }

    @Test
    public void testDefaultValidatorForNumberToByte() throws Exception {
        this.assertDefaultValidator(Integer.class, Byte.class, NumberToByteValidator.class);
    }

    @Test
    public void testDefaultValidatorForNumberToShort() throws Exception {
        this.assertDefaultValidator(Integer.class, Short.class, NumberToShortValidator.class);
    }

    @Test
    public void testDefaultValidatorForNumberToInteger() throws Exception {
        this.assertDefaultValidator(Short.class, Integer.class, NumberToIntegerValidator.class);
    }

    @Test
    public void testDefaultValidatorForNumberToLong() throws Exception {
        this.assertDefaultValidator(Short.class, Long.class, NumberToLongValidator.class);
    }

    @Test
    public void testDefaultValidatorForNumberToFloat() throws Exception {
        this.assertDefaultValidator(Short.class, Float.class, NumberToFloatValidator.class);
    }

    @Test
    public void testDefaultValidatorForNumberToDouble() throws Exception {
        this.assertDefaultValidator(Short.class, Double.class, NumberToDoubleValidator.class);
    }

    @Test
    public void testDefaultValidatorForNumberToBigInteger() throws Exception {
        this.assertDefaultValidator(Short.class, BigInteger.class, NumberToUnboundedNumberValidator.class);
    }

    @Test
    public void testDefaultValidatorForNumberToBigDecimal() throws Exception {
        this.assertDefaultValidator(Short.class, BigDecimal.class, NumberToUnboundedNumberValidator.class);
    }

    @Test
    public void testCachesDefaultedValidators() throws Exception {
        WritableValue source = WritableValue.withValueType(String.class);
        WritableValue destination = WritableValue.withValueType(Integer.class);
        UpdateValueStrategyStub strategy = new UpdateValueStrategyStub();
        strategy.fillDefaults(source, destination);
        IValidator validator = strategy.validator;
        Assert.assertNotNull(validator);
        strategy = new UpdateValueStrategyStub();
        strategy.fillDefaults(source, destination);
        Assert.assertSame(validator, strategy.validator);
    }

    @Test
    public void testFillDefaults_AssertSourceTypeExtendsConverterFromType() {
        UpdateValueStrategyStub strategy = new UpdateValueStrategyStub();
        strategy.setConverter((IConverter)new IdentityConverter(Object.class, Object.class));
        strategy.fillDefaults(WritableValue.withValueType(String.class), WritableValue.withValueType(Object.class));
        UpdateValueStrategyStub strategy2 = new UpdateValueStrategyStub();
        strategy2.setConverter((IConverter)new IdentityConverter(String.class, Object.class));
        Assert.assertThrows((String)"Expected BindingException since Object does not extend String", BindingException.class, () -> strategy2.fillDefaults(WritableValue.withValueType(Object.class), WritableValue.withValueType(Object.class)));
    }

    @Test
    public void testCreateValidatorWithNullConverter() {
        UpdateValueStrategyStub strategy = new UpdateValueStrategyStub();
        strategy.fillDefaults(WritableValue.withValueType(String.class), WritableValue.withValueType(Object.class));
        strategy.setConverter(null);
        strategy.createValidator(String.class, Object.class);
    }

    @Test
    public void testFillDefaults_AssertConverterToTypeExtendsDestinationType() {
        UpdateValueStrategyStub strategy = new UpdateValueStrategyStub();
        strategy.setConverter((IConverter)new IdentityConverter(Object.class, String.class));
        strategy.fillDefaults(WritableValue.withValueType(Object.class), WritableValue.withValueType(Object.class));
        UpdateValueStrategyStub strategy2 = new UpdateValueStrategyStub();
        strategy2.setConverter((IConverter)new IdentityConverter(Object.class, Object.class));
        Assert.assertThrows((String)"Expected BindingException since Object does not extend String", BindingException.class, () -> strategy2.fillDefaults(WritableValue.withValueType(Object.class), WritableValue.withValueType(String.class)));
    }

    private void assertDefaultValidator(Class<?> fromType, Class<?> toType, Class<?> validatorType) {
        WritableValue source = WritableValue.withValueType(fromType);
        WritableValue destination = WritableValue.withValueType(toType);
        UpdateValueStrategyStub strategy = new UpdateValueStrategyStub();
        strategy.fillDefaults(source, destination);
        IValidator validator = strategy.validator;
        Assert.assertNotNull((String)"validator not null", validator);
        Assert.assertTrue((String)("converter instanceof " + String.valueOf(validatorType)), (boolean)validatorType.isInstance(validator));
    }

    class UpdateValueStrategyStub<S, D>
    extends UpdateValueStrategy<S, D> {
        IValidator<S> validator;

        UpdateValueStrategyStub() {
        }

        protected void fillDefaults(IObservableValue<? extends S> source, IObservableValue<? super D> destination) {
            super.fillDefaults(source, destination);
        }

        protected IValidator<S> createValidator(Object fromType, Object toType) {
            this.validator = super.createValidator(fromType, toType);
            return this.validator;
        }
    }
}

