/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValueBindingTest
extends AbstractDefaultRealmTestCase {
    private WritableValue<Object> target;
    private WritableValue<String> model;
    private DataBindingContext dbc;
    private Binding binding;
    private List<String> log;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.target = WritableValue.withValueType(String.class);
        this.model = WritableValue.withValueType(String.class);
        this.dbc = new DataBindingContext();
        this.log = new ArrayList<String>();
    }

    @Override
    public void tearDown() throws Exception {
        this.dbc.dispose();
        this.model.dispose();
        this.target.dispose();
    }

    @Test
    public void testNoUpdateTargetFromModel() throws Exception {
        new DataBindingContext().bindValue(new ObservableValueStub(), new ObservableValueStub(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
    }

    @Test
    public void testValuePropagation() throws Exception {
        String initialValue = "value";
        this.model.setValue((Object)initialValue);
        Assert.assertFalse((boolean)((String)this.model.getValue()).equals(this.target.getValue()));
        this.dbc.bindValue(this.target, this.model);
        Assert.assertEquals((Object)this.target.getValue(), (Object)this.model.getValue());
    }

    @Test
    public void testGetTarget() throws Exception {
        Binding binding = this.dbc.bindValue(this.target, this.model);
        Assert.assertEquals(this.target, (Object)binding.getTarget());
    }

    @Test
    public void testGetModel() throws Exception {
        Binding binding = this.dbc.bindValue(this.target, this.model);
        Assert.assertEquals(this.model, (Object)binding.getModel());
    }

    @Test
    public void testOKStatusInValidationUpdatesModel() throws Exception {
        Binding binding = this.dbc.bindValue(this.target, this.model);
        String value = "value";
        Assert.assertFalse((boolean)value.equals(this.model.getValue()));
        this.target.setValue((Object)value);
        Assert.assertEquals((String)"value copied to model", (Object)value, (Object)this.model.getValue());
        Assert.assertTrue((boolean)((IStatus)binding.getValidationStatus().getValue()).isOK());
    }

    @Test
    public void testWarningStatusInValidationUpdatesModel() throws Exception {
        Binding binding = this.dbc.bindValue(this.target, this.model, new UpdateValueStrategy().setAfterGetValidator(this.warningValidator()), null);
        String value = "value";
        Assert.assertFalse((boolean)value.equals(this.model.getValue()));
        this.target.setValue((Object)value);
        Assert.assertEquals((String)"value copied to model", (Object)value, (Object)this.model.getValue());
        Assert.assertEquals((String)"warning status", (long)2L, (long)((IStatus)binding.getValidationStatus().getValue()).getSeverity());
    }

    @Test
    public void testInfoStatusInValidationUpdatesModel() throws Exception {
        Binding binding = this.dbc.bindValue(this.target, this.model, new UpdateValueStrategy().setAfterGetValidator(this.infoValidator()), null);
        String value = "value";
        Assert.assertFalse((boolean)value.equals(this.model.getValue()));
        this.target.setValue((Object)value);
        Assert.assertEquals((String)"value copied to model", (Object)value, (Object)this.model.getValue());
        Assert.assertEquals((String)"info status", (long)1L, (long)((IStatus)binding.getValidationStatus().getValue()).getSeverity());
    }

    @Test
    public void testErrorStatusInValidationDoesNotUpdateModel() throws Exception {
        Binding binding = this.dbc.bindValue(this.target, this.model, new UpdateValueStrategy().setAfterGetValidator(this.errorValidator()), null);
        String value = "value";
        Assert.assertFalse((boolean)value.equals(this.model.getValue()));
        this.target.setValue((Object)value);
        Assert.assertFalse((String)"value not copied to model", (boolean)value.equals(this.model.getValue()));
        Assert.assertEquals((String)"error status", (long)4L, (long)((IStatus)binding.getValidationStatus().getValue()).getSeverity());
    }

    @Test
    public void testCancelStatusInValidationDoesNotUpdateModel() throws Exception {
        Binding binding = this.dbc.bindValue(this.target, this.model, new UpdateValueStrategy().setAfterGetValidator(this.cancelValidator()), null);
        String value = "value";
        Assert.assertFalse((boolean)value.equals(this.model.getValue()));
        this.target.setValue((Object)value);
        Assert.assertFalse((String)"value not copied to model", (boolean)value.equals(this.model.getValue()));
        Assert.assertEquals((String)"cancel status", (long)8L, (long)((IStatus)binding.getValidationStatus().getValue()).getSeverity());
    }

    @Test
    public void testStatusesFromEveryPhaseAreReturned() throws Exception {
        UpdateValueStrategy<Object, String> strategy = new UpdateValueStrategy<Object, String>(){

            protected IStatus doSet(IObservableValue<? super String> observableValue, String value) {
                super.doSet(observableValue, (Object)value);
                return ValidationStatus.info((String)"");
            }
        };
        strategy.setAfterGetValidator(this.warningValidator());
        strategy.setAfterConvertValidator(this.infoValidator());
        strategy.setBeforeSetValidator(this.warningValidator());
        Binding binding = this.dbc.bindValue(this.target, this.model, (UpdateValueStrategy)strategy, null);
        String value = "value";
        Assert.assertFalse((boolean)value.equals(this.model.getValue()));
        this.target.setValue((Object)value);
        Assert.assertEquals((Object)value, (Object)this.model.getValue());
        IStatus status = (IStatus)binding.getValidationStatus().getValue();
        Assert.assertTrue((boolean)status.isMultiStatus());
        Assert.assertEquals((String)"max status", (long)2L, (long)status.getSeverity());
        MultiStatus multiStatus = (MultiStatus)status;
        Assert.assertEquals((long)4L, (long)multiStatus.getChildren().length);
        IStatus[] children = multiStatus.getChildren();
        Assert.assertEquals((String)"after get severity", (long)2L, (long)children[0].getSeverity());
        Assert.assertEquals((String)"after convert severity", (long)1L, (long)children[1].getSeverity());
        Assert.assertEquals((String)"before set severity", (long)2L, (long)children[2].getSeverity());
        Assert.assertEquals((String)"doSet severity", (long)1L, (long)children[3].getSeverity());
    }

    @Test
    public void testStatusIsInstanceOfBindingStatus() throws Exception {
        Binding binding = this.dbc.bindValue(this.target, this.model);
        Assert.assertTrue((boolean)(binding.getValidationStatus().getValue() instanceof BindingStatus));
    }

    @Test
    public void testDiffsAreCheckedForEqualityBeforeUpdate() throws Exception {
        class WritableValueStub
        extends WritableValue<String> {
            public WritableValueStub() {
                super((Object)"", String.class);
            }

            protected void fireValueChange(ValueDiff<String> diff) {
                super.fireValueChange(diff);
            }
        }
        WritableValueStub target = new WritableValueStub();
        WritableValue model = WritableValue.withValueType(String.class);
        class Strategy
        extends UpdateValueStrategy<String, String> {
            int afterGetCount;

            Strategy() {
            }

            public IStatus validateAfterGet(String value) {
                ++this.afterGetCount;
                return super.validateAfterGet((Object)value);
            }
        }
        Strategy strategy = new Strategy();
        this.dbc.bindValue((IObservableValue)target, (IObservableValue)model, (UpdateValueStrategy)strategy, null);
        int count = strategy.afterGetCount;
        target.fireValueChange((ValueDiff<String>)Diffs.createValueDiff((Object)"", (Object)""));
        Assert.assertEquals((String)"update does not occur", (long)count, (long)strategy.afterGetCount);
    }

    @Test
    public void testPostInit_UpdatePolicy_UpdateToTarget_UpdateToModel() {
        this.bindLoggingValue(this.loggingTargetToModelStrategy(UpdateValueStrategy.POLICY_UPDATE), this.loggingModelToTargetStrategy(UpdateValueStrategy.POLICY_UPDATE));
        Assert.assertEquals(List.of("model-get", "model-convert", "model-after-convert", "target-before-set", "target-set", "target-get", "target-convert", "target-after-convert", "model-before-set"), this.log);
    }

    @Test
    public void testPostInit_UpdatePolicy_UpdateToTarget_ConvertToModel() {
        this.bindLoggingValue(this.loggingTargetToModelStrategy(UpdateValueStrategy.POLICY_CONVERT), this.loggingModelToTargetStrategy(UpdateValueStrategy.POLICY_UPDATE));
        Assert.assertEquals(List.of("model-get", "model-convert", "model-after-convert", "target-before-set", "target-set", "target-get", "target-convert", "target-after-convert", "model-before-set"), this.log);
    }

    @Test
    public void testPostInit_UpdatePolicy_UpdateToTarget_OnRequestToModel() {
        this.bindLoggingValue(this.loggingTargetToModelStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), this.loggingModelToTargetStrategy(UpdateValueStrategy.POLICY_UPDATE));
        Assert.assertEquals(List.of("model-get", "model-convert", "model-after-convert", "target-before-set", "target-set"), this.log);
        this.log.clear();
        this.target.setValue(new Object());
        Assert.assertEquals(Collections.singletonList("target-set"), this.log);
        this.log.clear();
        this.binding.validateTargetToModel();
        Assert.assertEquals(Arrays.asList("target-get", "target-convert", "target-after-convert", "model-before-set"), this.log);
        this.log.clear();
        this.binding.updateTargetToModel();
        Assert.assertEquals(List.of("target-get", "target-convert", "target-after-convert", "model-before-set", "model-set"), this.log);
    }

    @Test
    public void testPostInit_UpdatePolicy_UpdateToTarget_NeverToModel() {
        this.bindLoggingValue(this.loggingTargetToModelStrategy(UpdateValueStrategy.POLICY_NEVER), this.loggingModelToTargetStrategy(UpdateValueStrategy.POLICY_UPDATE));
        Assert.assertEquals(List.of("model-get", "model-convert", "model-after-convert", "target-before-set", "target-set"), this.log);
        this.log.clear();
        this.target.setValue(new Object());
        Assert.assertEquals(Collections.singletonList("target-set"), this.log);
        this.log.clear();
        this.binding.validateTargetToModel();
        Assert.assertEquals(Collections.emptyList(), this.log);
        this.log.clear();
        this.binding.updateTargetToModel();
        Assert.assertEquals(Collections.emptyList(), this.log);
    }

    @Test
    public void testPostInit_UpdatePolicy_ConvertToTarget_UpdateToModel() {
        this.bindLoggingValue(this.loggingTargetToModelStrategy(UpdateValueStrategy.POLICY_UPDATE), this.loggingModelToTargetStrategy(UpdateValueStrategy.POLICY_CONVERT));
        Assert.assertEquals(List.of("model-get", "model-convert", "model-after-convert", "target-before-set", "target-get", "target-convert", "target-after-convert", "model-before-set"), this.log);
        this.log.clear();
        this.target.setValue(new Object());
        Assert.assertEquals(List.of("target-set", "target-get", "target-convert", "target-after-convert", "model-before-set", "model-set"), this.log);
        this.log.clear();
        this.model.setValue((Object)"dummy model value");
        Assert.assertEquals(List.of("model-set", "model-get", "model-convert", "model-after-convert"), this.log);
    }

    @Test
    public void testTargetValueIsSyncedToModelIfModelWasNotSyncedToTarget() {
        this.bindLoggingValue((UpdateValueStrategy<Object, String>)new UpdateValueStrategy(true, UpdateValueStrategy.POLICY_UPDATE), (UpdateValueStrategy<String, Object>)new UpdateValueStrategy(true, UpdateValueStrategy.POLICY_NEVER));
        Assert.assertEquals((Object)this.model.getValue(), (Object)this.target.getValue());
    }

    @Test
    public void testErrorDuringConversion() {
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter(IConverter.create(String.class, String.class, fromObject -> {
            throw new IllegalArgumentException();
        }));
        Binding binding = this.dbc.bindValue(this.target, this.model, new UpdateValueStrategy(), modelToTarget);
        CountDownLatch latch = new CountDownLatch(1);
        Policy.setLog(status -> {
            latch.countDown();
            Assert.assertEquals((long)4L, (long)status.getSeverity());
            Assert.assertTrue((boolean)(status.getException() instanceof IllegalArgumentException));
        });
        this.model.setValue((Object)"first");
        Assert.assertNull((String)"Target not changed on conversion error", (Object)this.target.getValue());
        Assert.assertEquals((long)0L, (long)latch.getCount());
        Assert.assertEquals((long)4L, (long)((IStatus)binding.getValidationStatus().getValue()).getCode());
        Policy.setLog(null);
    }

    private void bindLoggingValue(UpdateValueStrategy<Object, String> targetToModel, UpdateValueStrategy<String, Object> modelToTarget) {
        this.model.setValue((Object)"1");
        this.target.setValue((Object)"2");
        this.target.addValueChangeListener(event -> {
            boolean bl = this.log.add("target-set");
        });
        this.model.addValueChangeListener(event -> {
            boolean bl = this.log.add("model-set");
        });
        this.binding = this.dbc.bindValue(this.target, this.model, targetToModel, modelToTarget);
    }

    private UpdateValueStrategy<String, Object> loggingModelToTargetStrategy(int updatePolicy) {
        return new UpdateValueStrategy(updatePolicy).setAfterGetValidator(this.loggingValidator(this.log, "model-get")).setConverter(this.loggingConverter(this.log, "model-convert")).setAfterConvertValidator(this.loggingValidator(this.log, "model-after-convert")).setBeforeSetValidator(this.loggingValidator(this.log, "target-before-set"));
    }

    private UpdateValueStrategy<Object, String> loggingTargetToModelStrategy(int updatePolicy) {
        return new UpdateValueStrategy(updatePolicy).setAfterGetValidator(this.loggingValidator(this.log, "target-get")).setConverter(this.loggingConverter(this.log, "target-convert")).setAfterConvertValidator(this.loggingValidator(this.log, "target-after-convert")).setBeforeSetValidator(this.loggingValidator(this.log, "model-before-set"));
    }

    private IValidator<Object> loggingValidator(List<String> log, String message) {
        return value -> {
            log.add(message);
            return ValidationStatus.ok();
        };
    }

    private <F, T> IConverter<F, T> loggingConverter(final List<String> log, final String message) {
        return new Converter<F, T>(null, null){

            public T convert(F fromObject) {
                log.add(message);
                return fromObject;
            }
        };
    }

    private IValidator<Object> warningValidator() {
        return value -> ValidationStatus.warning((String)"");
    }

    private IValidator<Object> infoValidator() {
        return value -> ValidationStatus.info((String)"");
    }

    private IValidator<Object> errorValidator() {
        return value -> ValidationStatus.error((String)"");
    }

    private IValidator<Object> cancelValidator() {
        return value -> ValidationStatus.cancel((String)"");
    }

    private static class ObservableValueStub<T>
    extends AbstractObservableValue<T> {
        private ObservableValueStub() {
        }

        protected T doGetValue() {
            return null;
        }

        public Object getValueType() {
            return null;
        }

        protected void doSetValue(T value) {
        }
    }
}

