/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.beans;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableSetDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableValueDecorator;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BeansObservablesTest
extends AbstractDefaultRealmTestCase {
    Bean[] elements = null;
    Bean model = null;
    Class<?> elementType = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.elements = new Bean[]{new Bean("1"), new Bean("2"), new Bean("3")};
        this.model = new Bean(this.elements);
        this.model.setList(new ArrayList<Object>(Arrays.asList(this.elements)));
        this.elementType = Bean.class;
    }

    @Test
    public void testObserveListArrayInferredElementType() throws Exception {
        IObservableList list = BeanProperties.list((String)"list", null).observe(Realm.getDefault(), (Object)this.model);
        Assert.assertEquals((String)"element type", Object.class, (Object)list.getElementType());
    }

    @Test
    public void testObserveListNonInferredElementType() throws Exception {
        this.elementType = Object.class;
        IObservableList list = BeanProperties.list((String)"list", null).observe(Realm.getDefault(), (Object)this.model);
        Assert.assertEquals((String)"element type", this.elementType, (Object)list.getElementType());
    }

    @Test
    public void testListFactory() throws Exception {
        IObservableFactory factory = BeanProperties.list((String)"list", this.elementType).listFactory(Realm.getDefault());
        IObservableList list = (IObservableList)factory.createObservable((Object)this.model);
        Assert.assertTrue((String)"elements of the list", (boolean)Arrays.equals(this.elements, list.toArray((Object[])new Bean[list.size()])));
        Assert.assertEquals((String)"element type", this.elementType, (Object)list.getElementType());
    }

    @Test
    public void testObserveDetailListElementType() throws Exception {
        WritableValue parent = WritableValue.withValueType(Bean.class);
        parent.setValue((Object)this.model);
        IObservableList list = BeanProperties.list((String)"list", this.elementType).observeDetail((IObservableValue)parent);
        Assert.assertEquals((String)"element type", this.elementType, (Object)list.getElementType());
        Assert.assertTrue((String)"elements of list", (boolean)Arrays.equals(this.elements, list.toArray((Object[])new Bean[list.size()])));
    }

    @Test
    public void testObserveDetailValueIBeanObservable() throws Exception {
        WritableValue parent = WritableValue.withValueType(Bean.class);
        Bean bean = new Bean();
        parent.setValue((Object)bean);
        IObservableValue detailValue = BeanProperties.value(Bean.class, (String)"value", String.class).observeDetail((IObservableValue)parent);
        Assert.assertTrue((boolean)(detailValue instanceof IBeanObservable));
        BeanObservableValueDecorator beanObservable = (BeanObservableValueDecorator)detailValue;
        Assert.assertEquals((String)"property descriptor", (Object)Bean.class.getMethod("getValue", new Class[0]), (Object)beanObservable.getPropertyDescriptor().getReadMethod());
        Assert.assertEquals((String)"observed", (Object)bean, (Object)beanObservable.getObserved());
        Assert.assertTrue((String)"delegate", (boolean)beanObservable.getDecorated().getClass().getName().endsWith("DetailObservableValue"));
    }

    @Test
    public void testObserveDetailValueNullOuterElementType() throws Exception {
        WritableValue parent = new WritableValue((Object)new Bean(), null);
        IObservableValue detailValue = BeanProperties.value((String)"value", String.class).observeDetail((IObservableValue)parent);
        Assert.assertNull((String)"property descriptor", (Object)((IBeanObservable)detailValue).getPropertyDescriptor());
    }

    @Test
    public void testObservableDetailListIBeanObservable() throws Exception {
        WritableValue parent = WritableValue.withValueType(Bean.class);
        Bean bean = new Bean();
        parent.setValue((Object)bean);
        IObservableList detailList = BeanProperties.list(Bean.class, (String)"list", Bean.class).observeDetail((IObservableValue)parent);
        Assert.assertTrue((String)"detail is not an IBeanObservable", (boolean)(detailList instanceof IBeanObservable));
        BeanObservableListDecorator beanObservable = (BeanObservableListDecorator)detailList;
        Assert.assertEquals((String)"property descriptor", (Object)Bean.class.getMethod("getList", new Class[0]), (Object)beanObservable.getPropertyDescriptor().getReadMethod());
        Assert.assertEquals((String)"observed", (Object)bean, (Object)beanObservable.getObserved());
        Assert.assertTrue((String)"delegate is the observed", (boolean)beanObservable.getDecorated().equals(detailList));
    }

    @Test
    public void testObservableDetailListNullOuterElementType() throws Exception {
        WritableValue parent = new WritableValue((Object)new Bean(), null);
        IObservableList detailList = BeanProperties.list((String)"list", Bean.class).observeDetail((IObservableValue)parent);
        Assert.assertNull((String)"property descriptor", (Object)((IBeanObservable)detailList).getPropertyDescriptor());
    }

    @Test
    public void testObservableDetailSetIBeanObservable() throws Exception {
        WritableValue parent = WritableValue.withValueType(Bean.class);
        Bean bean = new Bean();
        parent.setValue((Object)bean);
        IObservableSet detailSet = BeanProperties.set(Bean.class, (String)"set", Bean.class).observe((Object)bean);
        Assert.assertTrue((String)"detail is not an IBeanObservable", (boolean)(detailSet instanceof IBeanObservable));
        BeanObservableSetDecorator beanObservable = (BeanObservableSetDecorator)detailSet;
        Assert.assertEquals((String)"property descriptor", (Object)Bean.class.getMethod("getSet", new Class[0]), (Object)beanObservable.getPropertyDescriptor().getReadMethod());
        Assert.assertEquals((String)"observed", (Object)bean, (Object)beanObservable.getObserved());
        Assert.assertTrue((String)"delegate is the observed", (boolean)beanObservable.getDecorated().equals(detailSet));
    }

    @Test
    public void testObservableDetailSetNullOuterElementType() throws Exception {
        WritableValue parent = new WritableValue((Object)new Bean(), null);
        IObservableSet detailSet = BeanProperties.set((String)"set", Bean.class).observeDetail((IObservableValue)parent);
        Assert.assertNull((String)"property descriptor", (Object)((IBeanObservable)detailSet).getPropertyDescriptor());
    }

    @Test
    public void testObserveSetElementType() throws Exception {
        Bean bean = new Bean();
        IObservableSet observableSet = BeanProperties.set((String)"set", Bean.class).observe(Realm.getDefault(), (Object)bean);
        Assert.assertEquals(Bean.class, (Object)observableSet.getElementType());
    }

    @Test
    public void testObserveSetNonInferredElementType() throws Exception {
        Bean bean = new Bean();
        IObservableSet observableSet = BeanProperties.set((String)"set").observe(Realm.getDefault(), (Object)bean);
        Assert.assertEquals(Object.class, (Object)observableSet.getElementType());
    }

    @Test
    public void testHandleExternalChangeToProperty() {
        Bean targetBean = new Bean();
        IObservableList modelObservable = BeanProperties.list((String)"array", this.elementType).observe(Realm.getDefault(), (Object)this.model);
        IObservableList targetObservable = BeanProperties.list((String)"array", this.elementType).observe(Realm.getDefault(), (Object)targetBean);
        DataBindingContext context = new DataBindingContext(Realm.getDefault());
        try {
            context.bindList(targetObservable, modelObservable);
            Assert.assertTrue((boolean)Arrays.equals(this.elements, targetBean.getArray()));
            Object[] newElements = new Bean[]{new Bean("4"), new Bean("5"), new Bean("6")};
            this.model.setArray(newElements);
            Assert.assertTrue((boolean)Arrays.equals(newElements, targetBean.getArray()));
            newElements = new Bean[]{new Bean("7"), new Bean("8"), new Bean("9")};
            targetBean.setArray(newElements);
            Assert.assertTrue((boolean)Arrays.equals(newElements, this.model.getArray()));
        }
        finally {
            context.dispose();
        }
    }

    @Test
    public void testObserveDetailValue_ValueType() {
        Bean inner = new Bean("string");
        Bean outer = new Bean(inner);
        IBeanValueProperty beanProperty = BeanProperties.value((String)"bean");
        IObservableValue beanObservable = beanProperty.observe((Object)outer);
        Assert.assertEquals(Bean.class, (Object)beanObservable.getValueType());
        IBeanValueProperty valueProperty = BeanProperties.value((String)"value");
        IObservableValue valueObservable = valueProperty.observeDetail(beanObservable);
        Assert.assertEquals(String.class, (Object)valueObservable.getValueType());
    }
}

